/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.cbean.cq.bs;

import java.util.Map;

import jp.sf.fess.db.cbean.CrawlingSessionCB;
import jp.sf.fess.db.cbean.cq.CrawlingSessionCQ;
import jp.sf.fess.db.cbean.cq.CrawlingSessionInfoCQ;
import jp.sf.fess.db.cbean.cq.ciq.CrawlingSessionCIQ;

import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;

/**
 * The base condition-query of CRAWLING_SESSION.
 * @author DBFlute(AutoGenerator)
 */
public class BsCrawlingSessionCQ extends AbstractBsCrawlingSessionCQ {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected CrawlingSessionCIQ _inlineQuery;

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public BsCrawlingSessionCQ(ConditionQuery childQuery, SqlClause sqlClause,
            String aliasName, int nestLevel) {
        super(childQuery, sqlClause, aliasName, nestLevel);
    }

    // ===================================================================================
    //                                                                              Inline
    //                                                                              ======
    /**
     * Prepare inline query. <br />
     * {select ... from ... left outer join (select * from CRAWLING_SESSION) where abc = [abc] ...}
     * @return Inline query. (NotNull)
     */
    public CrawlingSessionCIQ inline() {
        if (_inlineQuery == null) {
            _inlineQuery = new CrawlingSessionCIQ(getChildQuery(),
                    getSqlClause(), getAliasName(), getNestLevel(), this);
        }
        _inlineQuery.xsetOnClauseInline(false);
        return _inlineQuery;
    }

    /**
     * Prepare on-clause query. <br />
     * {select ... from ... left outer join CRAWLING_SESSION on ... and abc = [abc] ...}
     * @return On-clause query. (NotNull)
     */
    public CrawlingSessionCIQ on() {
        if (isBaseQuery(this)) {
            throw new UnsupportedOperationException(
                    "Unsupported on-clause for local table!");
        }
        CrawlingSessionCIQ inlineQuery = inline();
        inlineQuery.xsetOnClauseInline(true);
        return inlineQuery;
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====

    protected ConditionValue _id;

    public ConditionValue getId() {
        if (_id == null) {
            _id = nCV();
        }
        return _id;
    }

    protected ConditionValue getCValueId() {
        return getId();
    }

    protected Map<String, CrawlingSessionInfoCQ> _id_InScopeSubQuery_CrawlingSessionInfoListMap;

    public Map<String, CrawlingSessionInfoCQ> getId_InScopeSubQuery_CrawlingSessionInfoList() {
        return _id_InScopeSubQuery_CrawlingSessionInfoListMap;
    }

    public String keepId_InScopeSubQuery_CrawlingSessionInfoList(
            CrawlingSessionInfoCQ subQuery) {
        if (_id_InScopeSubQuery_CrawlingSessionInfoListMap == null) {
            _id_InScopeSubQuery_CrawlingSessionInfoListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_InScopeSubQuery_CrawlingSessionInfoListMap.size() + 1);
        _id_InScopeSubQuery_CrawlingSessionInfoListMap.put(key, subQuery);
        return "id_InScopeSubQuery_CrawlingSessionInfoList." + key;
    }

    protected Map<String, CrawlingSessionInfoCQ> _id_NotInScopeSubQuery_CrawlingSessionInfoListMap;

    public Map<String, CrawlingSessionInfoCQ> getId_NotInScopeSubQuery_CrawlingSessionInfoList() {
        return _id_NotInScopeSubQuery_CrawlingSessionInfoListMap;
    }

    public String keepId_NotInScopeSubQuery_CrawlingSessionInfoList(
            CrawlingSessionInfoCQ subQuery) {
        if (_id_NotInScopeSubQuery_CrawlingSessionInfoListMap == null) {
            _id_NotInScopeSubQuery_CrawlingSessionInfoListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotInScopeSubQuery_CrawlingSessionInfoListMap.size() + 1);
        _id_NotInScopeSubQuery_CrawlingSessionInfoListMap.put(key, subQuery);
        return "id_NotInScopeSubQuery_CrawlingSessionInfoList." + key;
    }

    protected Map<String, CrawlingSessionInfoCQ> _id_ExistsSubQuery_CrawlingSessionInfoListMap;

    public Map<String, CrawlingSessionInfoCQ> getId_ExistsSubQuery_CrawlingSessionInfoList() {
        return _id_ExistsSubQuery_CrawlingSessionInfoListMap;
    }

    public String keepId_ExistsSubQuery_CrawlingSessionInfoList(
            CrawlingSessionInfoCQ subQuery) {
        if (_id_ExistsSubQuery_CrawlingSessionInfoListMap == null) {
            _id_ExistsSubQuery_CrawlingSessionInfoListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_ExistsSubQuery_CrawlingSessionInfoListMap.size() + 1);
        _id_ExistsSubQuery_CrawlingSessionInfoListMap.put(key, subQuery);
        return "id_ExistsSubQuery_CrawlingSessionInfoList." + key;
    }

    protected Map<String, CrawlingSessionInfoCQ> _id_NotExistsSubQuery_CrawlingSessionInfoListMap;

    public Map<String, CrawlingSessionInfoCQ> getId_NotExistsSubQuery_CrawlingSessionInfoList() {
        return _id_NotExistsSubQuery_CrawlingSessionInfoListMap;
    }

    public String keepId_NotExistsSubQuery_CrawlingSessionInfoList(
            CrawlingSessionInfoCQ subQuery) {
        if (_id_NotExistsSubQuery_CrawlingSessionInfoListMap == null) {
            _id_NotExistsSubQuery_CrawlingSessionInfoListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotExistsSubQuery_CrawlingSessionInfoListMap.size() + 1);
        _id_NotExistsSubQuery_CrawlingSessionInfoListMap.put(key, subQuery);
        return "id_NotExistsSubQuery_CrawlingSessionInfoList." + key;
    }

    protected Map<String, CrawlingSessionInfoCQ> _id_SpecifyDerivedReferrer_CrawlingSessionInfoListMap;

    public Map<String, CrawlingSessionInfoCQ> getId_SpecifyDerivedReferrer_CrawlingSessionInfoList() {
        return _id_SpecifyDerivedReferrer_CrawlingSessionInfoListMap;
    }

    public String keepId_SpecifyDerivedReferrer_CrawlingSessionInfoList(
            CrawlingSessionInfoCQ subQuery) {
        if (_id_SpecifyDerivedReferrer_CrawlingSessionInfoListMap == null) {
            _id_SpecifyDerivedReferrer_CrawlingSessionInfoListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_SpecifyDerivedReferrer_CrawlingSessionInfoListMap.size() + 1);
        _id_SpecifyDerivedReferrer_CrawlingSessionInfoListMap
                .put(key, subQuery);
        return "id_SpecifyDerivedReferrer_CrawlingSessionInfoList." + key;
    }

    protected Map<String, CrawlingSessionInfoCQ> _id_QueryDerivedReferrer_CrawlingSessionInfoListMap;

    public Map<String, CrawlingSessionInfoCQ> getId_QueryDerivedReferrer_CrawlingSessionInfoList() {
        return _id_QueryDerivedReferrer_CrawlingSessionInfoListMap;
    }

    public String keepId_QueryDerivedReferrer_CrawlingSessionInfoList(
            CrawlingSessionInfoCQ subQuery) {
        if (_id_QueryDerivedReferrer_CrawlingSessionInfoListMap == null) {
            _id_QueryDerivedReferrer_CrawlingSessionInfoListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_QueryDerivedReferrer_CrawlingSessionInfoListMap.size() + 1);
        _id_QueryDerivedReferrer_CrawlingSessionInfoListMap.put(key, subQuery);
        return "id_QueryDerivedReferrer_CrawlingSessionInfoList." + key;
    }

    protected Map<String, Object> _id_QueryDerivedReferrer_CrawlingSessionInfoListParameterMap;

    public Map<String, Object> getId_QueryDerivedReferrer_CrawlingSessionInfoListParameter() {
        return _id_QueryDerivedReferrer_CrawlingSessionInfoListParameterMap;
    }

    public String keepId_QueryDerivedReferrer_CrawlingSessionInfoListParameter(
            Object parameterValue) {
        if (_id_QueryDerivedReferrer_CrawlingSessionInfoListParameterMap == null) {
            _id_QueryDerivedReferrer_CrawlingSessionInfoListParameterMap = newLinkedHashMap();
        }
        String key = "subQueryParameterKey"
                + (_id_QueryDerivedReferrer_CrawlingSessionInfoListParameterMap
                        .size() + 1);
        _id_QueryDerivedReferrer_CrawlingSessionInfoListParameterMap.put(key,
                parameterValue);
        return "id_QueryDerivedReferrer_CrawlingSessionInfoListParameter."
                + key;
    }

    public BsCrawlingSessionCQ addOrderBy_Id_Asc() {
        regOBA("ID");
        return this;
    }

    public BsCrawlingSessionCQ addOrderBy_Id_Desc() {
        regOBD("ID");
        return this;
    }

    protected ConditionValue _sessionId;

    public ConditionValue getSessionId() {
        if (_sessionId == null) {
            _sessionId = nCV();
        }
        return _sessionId;
    }

    protected ConditionValue getCValueSessionId() {
        return getSessionId();
    }

    public BsCrawlingSessionCQ addOrderBy_SessionId_Asc() {
        regOBA("SESSION_ID");
        return this;
    }

    public BsCrawlingSessionCQ addOrderBy_SessionId_Desc() {
        regOBD("SESSION_ID");
        return this;
    }

    protected ConditionValue _createdTime;

    public ConditionValue getCreatedTime() {
        if (_createdTime == null) {
            _createdTime = nCV();
        }
        return _createdTime;
    }

    protected ConditionValue getCValueCreatedTime() {
        return getCreatedTime();
    }

    public BsCrawlingSessionCQ addOrderBy_CreatedTime_Asc() {
        regOBA("CREATED_TIME");
        return this;
    }

    public BsCrawlingSessionCQ addOrderBy_CreatedTime_Desc() {
        regOBD("CREATED_TIME");
        return this;
    }

    // ===================================================================================
    //                                                           Specified Derived OrderBy
    //                                                           =========================
    public BsCrawlingSessionCQ addSpecifiedDerivedOrderBy_Asc(String aliasName) {
        registerSpecifiedDerivedOrderBy_Asc(aliasName);
        return this;
    }

    public BsCrawlingSessionCQ addSpecifiedDerivedOrderBy_Desc(String aliasName) {
        registerSpecifiedDerivedOrderBy_Desc(aliasName);
        return this;
    }

    // ===================================================================================
    //                                                                         Union Query
    //                                                                         ===========
    protected void reflectRelationOnUnionQuery(ConditionQuery baseQueryAsSuper,
            ConditionQuery unionQueryAsSuper) {
    }

    // ===================================================================================
    //                                                                       Foreign Query
    //                                                                       =============
    // ===================================================================================
    //                                                                     Scalar SubQuery
    //                                                                     ===============
    protected Map<String, CrawlingSessionCQ> _scalarSubQueryMap;

    public Map<String, CrawlingSessionCQ> getScalarSubQuery() {
        return _scalarSubQueryMap;
    }

    public String keepScalarSubQuery(CrawlingSessionCQ subQuery) {
        if (_scalarSubQueryMap == null) {
            _scalarSubQueryMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_scalarSubQueryMap.size() + 1);
        _scalarSubQueryMap.put(key, subQuery);
        return "scalarSubQuery." + key;
    }

    // ===================================================================================
    //                                                             MySelf InScope SubQuery
    //                                                             =======================
    protected Map<String, CrawlingSessionCQ> _myselfInScopeSubQueryMap;

    public Map<String, CrawlingSessionCQ> getMyselfInScopeSubQuery() {
        return _myselfInScopeSubQueryMap;
    }

    public String keepMyselfInScopeSubQuery(CrawlingSessionCQ subQuery) {
        if (_myselfInScopeSubQueryMap == null) {
            _myselfInScopeSubQueryMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_myselfInScopeSubQueryMap.size() + 1);
        _myselfInScopeSubQueryMap.put(key, subQuery);
        return "myselfInScopeSubQuery." + key;
    }

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // Very Internal (for Suppressing Warn about 'Not Use Import')
    String xCB() {
        return CrawlingSessionCB.class.getName();
    }

    String xCQ() {
        return CrawlingSessionCQ.class.getName();
    }

    String xMap() {
        return Map.class.getName();
    }
}
