/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.solr;

import java.net.MalformedURLException;
import java.net.URL;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;

public class FessSolrServer extends CommonsHttpSolrServer {

    private static final long serialVersionUID = 1L;

    public FessSolrServer(String solrServerUrl) throws MalformedURLException {
        super(new URL(solrServerUrl));
    }

    public FessSolrServer(String solrServerUrl, HttpClient httpClient)
            throws MalformedURLException {
        super(new URL(solrServerUrl), httpClient,
                ((ResponseParser) (new BinaryResponseParser())), false);
    }

    public FessSolrServer(String solrServerUrl, HttpClient httpClient,
            boolean useMultiPartPost) throws MalformedURLException {
        super(new URL(solrServerUrl), httpClient,
                ((ResponseParser) (new BinaryResponseParser())),
                useMultiPartPost);
    }

    public FessSolrServer(String solrServerUrl, HttpClient httpClient,
            ResponseParser parser) throws MalformedURLException {
        super(new URL(solrServerUrl), httpClient, parser, false);
    }

    public FessSolrServer(URL baseURL) {
        super(baseURL, null, ((ResponseParser) (new BinaryResponseParser())),
                false);
    }

    public FessSolrServer(URL baseURL, HttpClient client) {
        super(baseURL, client, ((ResponseParser) (new BinaryResponseParser())),
                false);
    }

    public FessSolrServer(URL baseURL, HttpClient client,
            boolean useMultiPartPost) {
        super(baseURL, client, ((ResponseParser) (new BinaryResponseParser())),
                useMultiPartPost);
    }

    public FessSolrServer(URL baseURL, HttpClient client,
            ResponseParser parser, boolean useMultiPartPost) {
        super(baseURL, client, parser, useMultiPartPost);
    }

    public void setCredentials(AuthScope authscope, Credentials credentials) {
        getHttpClient().getState().setCredentials(authscope, credentials);
    }
}
