/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.cbean.cq.bs;

import java.util.Map;

import jp.sf.fess.db.cbean.DataCrawlingConfigCB;
import jp.sf.fess.db.cbean.cq.DataConfigToBrowserTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.DataConfigToLabelTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.DataConfigToRoleTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.DataCrawlingConfigCQ;
import jp.sf.fess.db.cbean.cq.ciq.DataCrawlingConfigCIQ;

import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;

/**
 * The base condition-query of DATA_CRAWLING_CONFIG.
 * @author DBFlute(AutoGenerator)
 */
public class BsDataCrawlingConfigCQ extends AbstractBsDataCrawlingConfigCQ {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected DataCrawlingConfigCIQ _inlineQuery;

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public BsDataCrawlingConfigCQ(ConditionQuery childQuery,
            SqlClause sqlClause, String aliasName, int nestLevel) {
        super(childQuery, sqlClause, aliasName, nestLevel);
    }

    // ===================================================================================
    //                                                                              Inline
    //                                                                              ======
    /**
     * Prepare inline query. <br />
     * {select ... from ... left outer join (select * from DATA_CRAWLING_CONFIG) where abc = [abc] ...}
     * @return Inline query. (NotNull)
     */
    public DataCrawlingConfigCIQ inline() {
        if (_inlineQuery == null) {
            _inlineQuery = new DataCrawlingConfigCIQ(getChildQuery(),
                    getSqlClause(), getAliasName(), getNestLevel(), this);
        }
        _inlineQuery.xsetOnClauseInline(false);
        return _inlineQuery;
    }

    /**
     * Prepare on-clause query. <br />
     * {select ... from ... left outer join DATA_CRAWLING_CONFIG on ... and abc = [abc] ...}
     * @return On-clause query. (NotNull)
     */
    public DataCrawlingConfigCIQ on() {
        if (isBaseQuery(this)) {
            throw new UnsupportedOperationException(
                    "Unsupported on-clause for local table!");
        }
        DataCrawlingConfigCIQ inlineQuery = inline();
        inlineQuery.xsetOnClauseInline(true);
        return inlineQuery;
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====

    protected ConditionValue _id;

    public ConditionValue getId() {
        if (_id == null) {
            _id = nCV();
        }
        return _id;
    }

    protected ConditionValue getCValueId() {
        return getId();
    }

    protected Map<String, DataConfigToBrowserTypeMappingCQ> _id_InScopeSubQuery_DataConfigToBrowserTypeMappingListMap;

    public Map<String, DataConfigToBrowserTypeMappingCQ> getId_InScopeSubQuery_DataConfigToBrowserTypeMappingList() {
        return _id_InScopeSubQuery_DataConfigToBrowserTypeMappingListMap;
    }

    public String keepId_InScopeSubQuery_DataConfigToBrowserTypeMappingList(
            DataConfigToBrowserTypeMappingCQ subQuery) {
        if (_id_InScopeSubQuery_DataConfigToBrowserTypeMappingListMap == null) {
            _id_InScopeSubQuery_DataConfigToBrowserTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_InScopeSubQuery_DataConfigToBrowserTypeMappingListMap
                        .size() + 1);
        _id_InScopeSubQuery_DataConfigToBrowserTypeMappingListMap.put(key,
                subQuery);
        return "id_InScopeSubQuery_DataConfigToBrowserTypeMappingList." + key;
    }

    protected Map<String, DataConfigToLabelTypeMappingCQ> _id_InScopeSubQuery_DataConfigToLabelTypeMappingListMap;

    public Map<String, DataConfigToLabelTypeMappingCQ> getId_InScopeSubQuery_DataConfigToLabelTypeMappingList() {
        return _id_InScopeSubQuery_DataConfigToLabelTypeMappingListMap;
    }

    public String keepId_InScopeSubQuery_DataConfigToLabelTypeMappingList(
            DataConfigToLabelTypeMappingCQ subQuery) {
        if (_id_InScopeSubQuery_DataConfigToLabelTypeMappingListMap == null) {
            _id_InScopeSubQuery_DataConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_InScopeSubQuery_DataConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_InScopeSubQuery_DataConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_InScopeSubQuery_DataConfigToLabelTypeMappingList." + key;
    }

    protected Map<String, DataConfigToRoleTypeMappingCQ> _id_InScopeSubQuery_DataConfigToRoleTypeMappingListMap;

    public Map<String, DataConfigToRoleTypeMappingCQ> getId_InScopeSubQuery_DataConfigToRoleTypeMappingList() {
        return _id_InScopeSubQuery_DataConfigToRoleTypeMappingListMap;
    }

    public String keepId_InScopeSubQuery_DataConfigToRoleTypeMappingList(
            DataConfigToRoleTypeMappingCQ subQuery) {
        if (_id_InScopeSubQuery_DataConfigToRoleTypeMappingListMap == null) {
            _id_InScopeSubQuery_DataConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_InScopeSubQuery_DataConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_InScopeSubQuery_DataConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_InScopeSubQuery_DataConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, DataConfigToBrowserTypeMappingCQ> _id_NotInScopeSubQuery_DataConfigToBrowserTypeMappingListMap;

    public Map<String, DataConfigToBrowserTypeMappingCQ> getId_NotInScopeSubQuery_DataConfigToBrowserTypeMappingList() {
        return _id_NotInScopeSubQuery_DataConfigToBrowserTypeMappingListMap;
    }

    public String keepId_NotInScopeSubQuery_DataConfigToBrowserTypeMappingList(
            DataConfigToBrowserTypeMappingCQ subQuery) {
        if (_id_NotInScopeSubQuery_DataConfigToBrowserTypeMappingListMap == null) {
            _id_NotInScopeSubQuery_DataConfigToBrowserTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotInScopeSubQuery_DataConfigToBrowserTypeMappingListMap
                        .size() + 1);
        _id_NotInScopeSubQuery_DataConfigToBrowserTypeMappingListMap.put(key,
                subQuery);
        return "id_NotInScopeSubQuery_DataConfigToBrowserTypeMappingList."
                + key;
    }

    protected Map<String, DataConfigToLabelTypeMappingCQ> _id_NotInScopeSubQuery_DataConfigToLabelTypeMappingListMap;

    public Map<String, DataConfigToLabelTypeMappingCQ> getId_NotInScopeSubQuery_DataConfigToLabelTypeMappingList() {
        return _id_NotInScopeSubQuery_DataConfigToLabelTypeMappingListMap;
    }

    public String keepId_NotInScopeSubQuery_DataConfigToLabelTypeMappingList(
            DataConfigToLabelTypeMappingCQ subQuery) {
        if (_id_NotInScopeSubQuery_DataConfigToLabelTypeMappingListMap == null) {
            _id_NotInScopeSubQuery_DataConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotInScopeSubQuery_DataConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_NotInScopeSubQuery_DataConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_NotInScopeSubQuery_DataConfigToLabelTypeMappingList." + key;
    }

    protected Map<String, DataConfigToRoleTypeMappingCQ> _id_NotInScopeSubQuery_DataConfigToRoleTypeMappingListMap;

    public Map<String, DataConfigToRoleTypeMappingCQ> getId_NotInScopeSubQuery_DataConfigToRoleTypeMappingList() {
        return _id_NotInScopeSubQuery_DataConfigToRoleTypeMappingListMap;
    }

    public String keepId_NotInScopeSubQuery_DataConfigToRoleTypeMappingList(
            DataConfigToRoleTypeMappingCQ subQuery) {
        if (_id_NotInScopeSubQuery_DataConfigToRoleTypeMappingListMap == null) {
            _id_NotInScopeSubQuery_DataConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotInScopeSubQuery_DataConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_NotInScopeSubQuery_DataConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_NotInScopeSubQuery_DataConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, DataConfigToBrowserTypeMappingCQ> _id_ExistsSubQuery_DataConfigToBrowserTypeMappingListMap;

    public Map<String, DataConfigToBrowserTypeMappingCQ> getId_ExistsSubQuery_DataConfigToBrowserTypeMappingList() {
        return _id_ExistsSubQuery_DataConfigToBrowserTypeMappingListMap;
    }

    public String keepId_ExistsSubQuery_DataConfigToBrowserTypeMappingList(
            DataConfigToBrowserTypeMappingCQ subQuery) {
        if (_id_ExistsSubQuery_DataConfigToBrowserTypeMappingListMap == null) {
            _id_ExistsSubQuery_DataConfigToBrowserTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_ExistsSubQuery_DataConfigToBrowserTypeMappingListMap
                        .size() + 1);
        _id_ExistsSubQuery_DataConfigToBrowserTypeMappingListMap.put(key,
                subQuery);
        return "id_ExistsSubQuery_DataConfigToBrowserTypeMappingList." + key;
    }

    protected Map<String, DataConfigToLabelTypeMappingCQ> _id_ExistsSubQuery_DataConfigToLabelTypeMappingListMap;

    public Map<String, DataConfigToLabelTypeMappingCQ> getId_ExistsSubQuery_DataConfigToLabelTypeMappingList() {
        return _id_ExistsSubQuery_DataConfigToLabelTypeMappingListMap;
    }

    public String keepId_ExistsSubQuery_DataConfigToLabelTypeMappingList(
            DataConfigToLabelTypeMappingCQ subQuery) {
        if (_id_ExistsSubQuery_DataConfigToLabelTypeMappingListMap == null) {
            _id_ExistsSubQuery_DataConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_ExistsSubQuery_DataConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_ExistsSubQuery_DataConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_ExistsSubQuery_DataConfigToLabelTypeMappingList." + key;
    }

    protected Map<String, DataConfigToRoleTypeMappingCQ> _id_ExistsSubQuery_DataConfigToRoleTypeMappingListMap;

    public Map<String, DataConfigToRoleTypeMappingCQ> getId_ExistsSubQuery_DataConfigToRoleTypeMappingList() {
        return _id_ExistsSubQuery_DataConfigToRoleTypeMappingListMap;
    }

    public String keepId_ExistsSubQuery_DataConfigToRoleTypeMappingList(
            DataConfigToRoleTypeMappingCQ subQuery) {
        if (_id_ExistsSubQuery_DataConfigToRoleTypeMappingListMap == null) {
            _id_ExistsSubQuery_DataConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_ExistsSubQuery_DataConfigToRoleTypeMappingListMap.size() + 1);
        _id_ExistsSubQuery_DataConfigToRoleTypeMappingListMap
                .put(key, subQuery);
        return "id_ExistsSubQuery_DataConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, DataConfigToBrowserTypeMappingCQ> _id_NotExistsSubQuery_DataConfigToBrowserTypeMappingListMap;

    public Map<String, DataConfigToBrowserTypeMappingCQ> getId_NotExistsSubQuery_DataConfigToBrowserTypeMappingList() {
        return _id_NotExistsSubQuery_DataConfigToBrowserTypeMappingListMap;
    }

    public String keepId_NotExistsSubQuery_DataConfigToBrowserTypeMappingList(
            DataConfigToBrowserTypeMappingCQ subQuery) {
        if (_id_NotExistsSubQuery_DataConfigToBrowserTypeMappingListMap == null) {
            _id_NotExistsSubQuery_DataConfigToBrowserTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotExistsSubQuery_DataConfigToBrowserTypeMappingListMap
                        .size() + 1);
        _id_NotExistsSubQuery_DataConfigToBrowserTypeMappingListMap.put(key,
                subQuery);
        return "id_NotExistsSubQuery_DataConfigToBrowserTypeMappingList." + key;
    }

    protected Map<String, DataConfigToLabelTypeMappingCQ> _id_NotExistsSubQuery_DataConfigToLabelTypeMappingListMap;

    public Map<String, DataConfigToLabelTypeMappingCQ> getId_NotExistsSubQuery_DataConfigToLabelTypeMappingList() {
        return _id_NotExistsSubQuery_DataConfigToLabelTypeMappingListMap;
    }

    public String keepId_NotExistsSubQuery_DataConfigToLabelTypeMappingList(
            DataConfigToLabelTypeMappingCQ subQuery) {
        if (_id_NotExistsSubQuery_DataConfigToLabelTypeMappingListMap == null) {
            _id_NotExistsSubQuery_DataConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotExistsSubQuery_DataConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_NotExistsSubQuery_DataConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_NotExistsSubQuery_DataConfigToLabelTypeMappingList." + key;
    }

    protected Map<String, DataConfigToRoleTypeMappingCQ> _id_NotExistsSubQuery_DataConfigToRoleTypeMappingListMap;

    public Map<String, DataConfigToRoleTypeMappingCQ> getId_NotExistsSubQuery_DataConfigToRoleTypeMappingList() {
        return _id_NotExistsSubQuery_DataConfigToRoleTypeMappingListMap;
    }

    public String keepId_NotExistsSubQuery_DataConfigToRoleTypeMappingList(
            DataConfigToRoleTypeMappingCQ subQuery) {
        if (_id_NotExistsSubQuery_DataConfigToRoleTypeMappingListMap == null) {
            _id_NotExistsSubQuery_DataConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotExistsSubQuery_DataConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_NotExistsSubQuery_DataConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_NotExistsSubQuery_DataConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, DataConfigToBrowserTypeMappingCQ> _id_SpecifyDerivedReferrer_DataConfigToBrowserTypeMappingListMap;

    public Map<String, DataConfigToBrowserTypeMappingCQ> getId_SpecifyDerivedReferrer_DataConfigToBrowserTypeMappingList() {
        return _id_SpecifyDerivedReferrer_DataConfigToBrowserTypeMappingListMap;
    }

    public String keepId_SpecifyDerivedReferrer_DataConfigToBrowserTypeMappingList(
            DataConfigToBrowserTypeMappingCQ subQuery) {
        if (_id_SpecifyDerivedReferrer_DataConfigToBrowserTypeMappingListMap == null) {
            _id_SpecifyDerivedReferrer_DataConfigToBrowserTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_SpecifyDerivedReferrer_DataConfigToBrowserTypeMappingListMap
                        .size() + 1);
        _id_SpecifyDerivedReferrer_DataConfigToBrowserTypeMappingListMap.put(
                key, subQuery);
        return "id_SpecifyDerivedReferrer_DataConfigToBrowserTypeMappingList."
                + key;
    }

    protected Map<String, DataConfigToLabelTypeMappingCQ> _id_SpecifyDerivedReferrer_DataConfigToLabelTypeMappingListMap;

    public Map<String, DataConfigToLabelTypeMappingCQ> getId_SpecifyDerivedReferrer_DataConfigToLabelTypeMappingList() {
        return _id_SpecifyDerivedReferrer_DataConfigToLabelTypeMappingListMap;
    }

    public String keepId_SpecifyDerivedReferrer_DataConfigToLabelTypeMappingList(
            DataConfigToLabelTypeMappingCQ subQuery) {
        if (_id_SpecifyDerivedReferrer_DataConfigToLabelTypeMappingListMap == null) {
            _id_SpecifyDerivedReferrer_DataConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_SpecifyDerivedReferrer_DataConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_SpecifyDerivedReferrer_DataConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_SpecifyDerivedReferrer_DataConfigToLabelTypeMappingList."
                + key;
    }

    protected Map<String, DataConfigToRoleTypeMappingCQ> _id_SpecifyDerivedReferrer_DataConfigToRoleTypeMappingListMap;

    public Map<String, DataConfigToRoleTypeMappingCQ> getId_SpecifyDerivedReferrer_DataConfigToRoleTypeMappingList() {
        return _id_SpecifyDerivedReferrer_DataConfigToRoleTypeMappingListMap;
    }

    public String keepId_SpecifyDerivedReferrer_DataConfigToRoleTypeMappingList(
            DataConfigToRoleTypeMappingCQ subQuery) {
        if (_id_SpecifyDerivedReferrer_DataConfigToRoleTypeMappingListMap == null) {
            _id_SpecifyDerivedReferrer_DataConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_SpecifyDerivedReferrer_DataConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_SpecifyDerivedReferrer_DataConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_SpecifyDerivedReferrer_DataConfigToRoleTypeMappingList."
                + key;
    }

    protected Map<String, DataConfigToBrowserTypeMappingCQ> _id_QueryDerivedReferrer_DataConfigToBrowserTypeMappingListMap;

    public Map<String, DataConfigToBrowserTypeMappingCQ> getId_QueryDerivedReferrer_DataConfigToBrowserTypeMappingList() {
        return _id_QueryDerivedReferrer_DataConfigToBrowserTypeMappingListMap;
    }

    public String keepId_QueryDerivedReferrer_DataConfigToBrowserTypeMappingList(
            DataConfigToBrowserTypeMappingCQ subQuery) {
        if (_id_QueryDerivedReferrer_DataConfigToBrowserTypeMappingListMap == null) {
            _id_QueryDerivedReferrer_DataConfigToBrowserTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_QueryDerivedReferrer_DataConfigToBrowserTypeMappingListMap
                        .size() + 1);
        _id_QueryDerivedReferrer_DataConfigToBrowserTypeMappingListMap.put(key,
                subQuery);
        return "id_QueryDerivedReferrer_DataConfigToBrowserTypeMappingList."
                + key;
    }

    protected Map<String, Object> _id_QueryDerivedReferrer_DataConfigToBrowserTypeMappingListParameterMap;

    public Map<String, Object> getId_QueryDerivedReferrer_DataConfigToBrowserTypeMappingListParameter() {
        return _id_QueryDerivedReferrer_DataConfigToBrowserTypeMappingListParameterMap;
    }

    public String keepId_QueryDerivedReferrer_DataConfigToBrowserTypeMappingListParameter(
            Object parameterValue) {
        if (_id_QueryDerivedReferrer_DataConfigToBrowserTypeMappingListParameterMap == null) {
            _id_QueryDerivedReferrer_DataConfigToBrowserTypeMappingListParameterMap = newLinkedHashMap();
        }
        String key = "subQueryParameterKey"
                + (_id_QueryDerivedReferrer_DataConfigToBrowserTypeMappingListParameterMap
                        .size() + 1);
        _id_QueryDerivedReferrer_DataConfigToBrowserTypeMappingListParameterMap
                .put(key, parameterValue);
        return "id_QueryDerivedReferrer_DataConfigToBrowserTypeMappingListParameter."
                + key;
    }

    protected Map<String, DataConfigToLabelTypeMappingCQ> _id_QueryDerivedReferrer_DataConfigToLabelTypeMappingListMap;

    public Map<String, DataConfigToLabelTypeMappingCQ> getId_QueryDerivedReferrer_DataConfigToLabelTypeMappingList() {
        return _id_QueryDerivedReferrer_DataConfigToLabelTypeMappingListMap;
    }

    public String keepId_QueryDerivedReferrer_DataConfigToLabelTypeMappingList(
            DataConfigToLabelTypeMappingCQ subQuery) {
        if (_id_QueryDerivedReferrer_DataConfigToLabelTypeMappingListMap == null) {
            _id_QueryDerivedReferrer_DataConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_QueryDerivedReferrer_DataConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_QueryDerivedReferrer_DataConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_QueryDerivedReferrer_DataConfigToLabelTypeMappingList."
                + key;
    }

    protected Map<String, Object> _id_QueryDerivedReferrer_DataConfigToLabelTypeMappingListParameterMap;

    public Map<String, Object> getId_QueryDerivedReferrer_DataConfigToLabelTypeMappingListParameter() {
        return _id_QueryDerivedReferrer_DataConfigToLabelTypeMappingListParameterMap;
    }

    public String keepId_QueryDerivedReferrer_DataConfigToLabelTypeMappingListParameter(
            Object parameterValue) {
        if (_id_QueryDerivedReferrer_DataConfigToLabelTypeMappingListParameterMap == null) {
            _id_QueryDerivedReferrer_DataConfigToLabelTypeMappingListParameterMap = newLinkedHashMap();
        }
        String key = "subQueryParameterKey"
                + (_id_QueryDerivedReferrer_DataConfigToLabelTypeMappingListParameterMap
                        .size() + 1);
        _id_QueryDerivedReferrer_DataConfigToLabelTypeMappingListParameterMap
                .put(key, parameterValue);
        return "id_QueryDerivedReferrer_DataConfigToLabelTypeMappingListParameter."
                + key;
    }

    protected Map<String, DataConfigToRoleTypeMappingCQ> _id_QueryDerivedReferrer_DataConfigToRoleTypeMappingListMap;

    public Map<String, DataConfigToRoleTypeMappingCQ> getId_QueryDerivedReferrer_DataConfigToRoleTypeMappingList() {
        return _id_QueryDerivedReferrer_DataConfigToRoleTypeMappingListMap;
    }

    public String keepId_QueryDerivedReferrer_DataConfigToRoleTypeMappingList(
            DataConfigToRoleTypeMappingCQ subQuery) {
        if (_id_QueryDerivedReferrer_DataConfigToRoleTypeMappingListMap == null) {
            _id_QueryDerivedReferrer_DataConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_QueryDerivedReferrer_DataConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_QueryDerivedReferrer_DataConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_QueryDerivedReferrer_DataConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, Object> _id_QueryDerivedReferrer_DataConfigToRoleTypeMappingListParameterMap;

    public Map<String, Object> getId_QueryDerivedReferrer_DataConfigToRoleTypeMappingListParameter() {
        return _id_QueryDerivedReferrer_DataConfigToRoleTypeMappingListParameterMap;
    }

    public String keepId_QueryDerivedReferrer_DataConfigToRoleTypeMappingListParameter(
            Object parameterValue) {
        if (_id_QueryDerivedReferrer_DataConfigToRoleTypeMappingListParameterMap == null) {
            _id_QueryDerivedReferrer_DataConfigToRoleTypeMappingListParameterMap = newLinkedHashMap();
        }
        String key = "subQueryParameterKey"
                + (_id_QueryDerivedReferrer_DataConfigToRoleTypeMappingListParameterMap
                        .size() + 1);
        _id_QueryDerivedReferrer_DataConfigToRoleTypeMappingListParameterMap
                .put(key, parameterValue);
        return "id_QueryDerivedReferrer_DataConfigToRoleTypeMappingListParameter."
                + key;
    }

    public BsDataCrawlingConfigCQ addOrderBy_Id_Asc() {
        regOBA("ID");
        return this;
    }

    public BsDataCrawlingConfigCQ addOrderBy_Id_Desc() {
        regOBD("ID");
        return this;
    }

    protected ConditionValue _name;

    public ConditionValue getName() {
        if (_name == null) {
            _name = nCV();
        }
        return _name;
    }

    protected ConditionValue getCValueName() {
        return getName();
    }

    public BsDataCrawlingConfigCQ addOrderBy_Name_Asc() {
        regOBA("NAME");
        return this;
    }

    public BsDataCrawlingConfigCQ addOrderBy_Name_Desc() {
        regOBD("NAME");
        return this;
    }

    protected ConditionValue _handlerName;

    public ConditionValue getHandlerName() {
        if (_handlerName == null) {
            _handlerName = nCV();
        }
        return _handlerName;
    }

    protected ConditionValue getCValueHandlerName() {
        return getHandlerName();
    }

    public BsDataCrawlingConfigCQ addOrderBy_HandlerName_Asc() {
        regOBA("HANDLER_NAME");
        return this;
    }

    public BsDataCrawlingConfigCQ addOrderBy_HandlerName_Desc() {
        regOBD("HANDLER_NAME");
        return this;
    }

    protected ConditionValue _handlerParameter;

    public ConditionValue getHandlerParameter() {
        if (_handlerParameter == null) {
            _handlerParameter = nCV();
        }
        return _handlerParameter;
    }

    protected ConditionValue getCValueHandlerParameter() {
        return getHandlerParameter();
    }

    public BsDataCrawlingConfigCQ addOrderBy_HandlerParameter_Asc() {
        regOBA("HANDLER_PARAMETER");
        return this;
    }

    public BsDataCrawlingConfigCQ addOrderBy_HandlerParameter_Desc() {
        regOBD("HANDLER_PARAMETER");
        return this;
    }

    protected ConditionValue _handlerScript;

    public ConditionValue getHandlerScript() {
        if (_handlerScript == null) {
            _handlerScript = nCV();
        }
        return _handlerScript;
    }

    protected ConditionValue getCValueHandlerScript() {
        return getHandlerScript();
    }

    public BsDataCrawlingConfigCQ addOrderBy_HandlerScript_Asc() {
        regOBA("HANDLER_SCRIPT");
        return this;
    }

    public BsDataCrawlingConfigCQ addOrderBy_HandlerScript_Desc() {
        regOBD("HANDLER_SCRIPT");
        return this;
    }

    protected ConditionValue _boost;

    public ConditionValue getBoost() {
        if (_boost == null) {
            _boost = nCV();
        }
        return _boost;
    }

    protected ConditionValue getCValueBoost() {
        return getBoost();
    }

    public BsDataCrawlingConfigCQ addOrderBy_Boost_Asc() {
        regOBA("BOOST");
        return this;
    }

    public BsDataCrawlingConfigCQ addOrderBy_Boost_Desc() {
        regOBD("BOOST");
        return this;
    }

    protected ConditionValue _available;

    public ConditionValue getAvailable() {
        if (_available == null) {
            _available = nCV();
        }
        return _available;
    }

    protected ConditionValue getCValueAvailable() {
        return getAvailable();
    }

    public BsDataCrawlingConfigCQ addOrderBy_Available_Asc() {
        regOBA("AVAILABLE");
        return this;
    }

    public BsDataCrawlingConfigCQ addOrderBy_Available_Desc() {
        regOBD("AVAILABLE");
        return this;
    }

    protected ConditionValue _sortOrder;

    public ConditionValue getSortOrder() {
        if (_sortOrder == null) {
            _sortOrder = nCV();
        }
        return _sortOrder;
    }

    protected ConditionValue getCValueSortOrder() {
        return getSortOrder();
    }

    public BsDataCrawlingConfigCQ addOrderBy_SortOrder_Asc() {
        regOBA("SORT_ORDER");
        return this;
    }

    public BsDataCrawlingConfigCQ addOrderBy_SortOrder_Desc() {
        regOBD("SORT_ORDER");
        return this;
    }

    protected ConditionValue _createdBy;

    public ConditionValue getCreatedBy() {
        if (_createdBy == null) {
            _createdBy = nCV();
        }
        return _createdBy;
    }

    protected ConditionValue getCValueCreatedBy() {
        return getCreatedBy();
    }

    public BsDataCrawlingConfigCQ addOrderBy_CreatedBy_Asc() {
        regOBA("CREATED_BY");
        return this;
    }

    public BsDataCrawlingConfigCQ addOrderBy_CreatedBy_Desc() {
        regOBD("CREATED_BY");
        return this;
    }

    protected ConditionValue _createdTime;

    public ConditionValue getCreatedTime() {
        if (_createdTime == null) {
            _createdTime = nCV();
        }
        return _createdTime;
    }

    protected ConditionValue getCValueCreatedTime() {
        return getCreatedTime();
    }

    public BsDataCrawlingConfigCQ addOrderBy_CreatedTime_Asc() {
        regOBA("CREATED_TIME");
        return this;
    }

    public BsDataCrawlingConfigCQ addOrderBy_CreatedTime_Desc() {
        regOBD("CREATED_TIME");
        return this;
    }

    protected ConditionValue _updatedBy;

    public ConditionValue getUpdatedBy() {
        if (_updatedBy == null) {
            _updatedBy = nCV();
        }
        return _updatedBy;
    }

    protected ConditionValue getCValueUpdatedBy() {
        return getUpdatedBy();
    }

    public BsDataCrawlingConfigCQ addOrderBy_UpdatedBy_Asc() {
        regOBA("UPDATED_BY");
        return this;
    }

    public BsDataCrawlingConfigCQ addOrderBy_UpdatedBy_Desc() {
        regOBD("UPDATED_BY");
        return this;
    }

    protected ConditionValue _updatedTime;

    public ConditionValue getUpdatedTime() {
        if (_updatedTime == null) {
            _updatedTime = nCV();
        }
        return _updatedTime;
    }

    protected ConditionValue getCValueUpdatedTime() {
        return getUpdatedTime();
    }

    public BsDataCrawlingConfigCQ addOrderBy_UpdatedTime_Asc() {
        regOBA("UPDATED_TIME");
        return this;
    }

    public BsDataCrawlingConfigCQ addOrderBy_UpdatedTime_Desc() {
        regOBD("UPDATED_TIME");
        return this;
    }

    protected ConditionValue _deletedBy;

    public ConditionValue getDeletedBy() {
        if (_deletedBy == null) {
            _deletedBy = nCV();
        }
        return _deletedBy;
    }

    protected ConditionValue getCValueDeletedBy() {
        return getDeletedBy();
    }

    public BsDataCrawlingConfigCQ addOrderBy_DeletedBy_Asc() {
        regOBA("DELETED_BY");
        return this;
    }

    public BsDataCrawlingConfigCQ addOrderBy_DeletedBy_Desc() {
        regOBD("DELETED_BY");
        return this;
    }

    protected ConditionValue _deletedTime;

    public ConditionValue getDeletedTime() {
        if (_deletedTime == null) {
            _deletedTime = nCV();
        }
        return _deletedTime;
    }

    protected ConditionValue getCValueDeletedTime() {
        return getDeletedTime();
    }

    public BsDataCrawlingConfigCQ addOrderBy_DeletedTime_Asc() {
        regOBA("DELETED_TIME");
        return this;
    }

    public BsDataCrawlingConfigCQ addOrderBy_DeletedTime_Desc() {
        regOBD("DELETED_TIME");
        return this;
    }

    protected ConditionValue _versionNo;

    public ConditionValue getVersionNo() {
        if (_versionNo == null) {
            _versionNo = nCV();
        }
        return _versionNo;
    }

    protected ConditionValue getCValueVersionNo() {
        return getVersionNo();
    }

    public BsDataCrawlingConfigCQ addOrderBy_VersionNo_Asc() {
        regOBA("VERSION_NO");
        return this;
    }

    public BsDataCrawlingConfigCQ addOrderBy_VersionNo_Desc() {
        regOBD("VERSION_NO");
        return this;
    }

    // ===================================================================================
    //                                                           Specified Derived OrderBy
    //                                                           =========================
    public BsDataCrawlingConfigCQ addSpecifiedDerivedOrderBy_Asc(
            String aliasName) {
        registerSpecifiedDerivedOrderBy_Asc(aliasName);
        return this;
    }

    public BsDataCrawlingConfigCQ addSpecifiedDerivedOrderBy_Desc(
            String aliasName) {
        registerSpecifiedDerivedOrderBy_Desc(aliasName);
        return this;
    }

    // ===================================================================================
    //                                                                         Union Query
    //                                                                         ===========
    protected void reflectRelationOnUnionQuery(ConditionQuery baseQueryAsSuper,
            ConditionQuery unionQueryAsSuper) {
    }

    // ===================================================================================
    //                                                                       Foreign Query
    //                                                                       =============
    // ===================================================================================
    //                                                                     Scalar SubQuery
    //                                                                     ===============
    protected Map<String, DataCrawlingConfigCQ> _scalarSubQueryMap;

    public Map<String, DataCrawlingConfigCQ> getScalarSubQuery() {
        return _scalarSubQueryMap;
    }

    public String keepScalarSubQuery(DataCrawlingConfigCQ subQuery) {
        if (_scalarSubQueryMap == null) {
            _scalarSubQueryMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_scalarSubQueryMap.size() + 1);
        _scalarSubQueryMap.put(key, subQuery);
        return "scalarSubQuery." + key;
    }

    // ===================================================================================
    //                                                             MySelf InScope SubQuery
    //                                                             =======================
    protected Map<String, DataCrawlingConfigCQ> _myselfInScopeSubQueryMap;

    public Map<String, DataCrawlingConfigCQ> getMyselfInScopeSubQuery() {
        return _myselfInScopeSubQueryMap;
    }

    public String keepMyselfInScopeSubQuery(DataCrawlingConfigCQ subQuery) {
        if (_myselfInScopeSubQueryMap == null) {
            _myselfInScopeSubQueryMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_myselfInScopeSubQueryMap.size() + 1);
        _myselfInScopeSubQueryMap.put(key, subQuery);
        return "myselfInScopeSubQuery." + key;
    }

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // Very Internal (for Suppressing Warn about 'Not Use Import')
    String xCB() {
        return DataCrawlingConfigCB.class.getName();
    }

    String xCQ() {
        return DataCrawlingConfigCQ.class.getName();
    }

    String xMap() {
        return Map.class.getName();
    }
}
