package org.seasar.chronos.core.task.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.seasar.chronos.core.ThreadPoolType;
import org.seasar.chronos.core.task.TaskPropertyWriter;
import org.seasar.chronos.core.trigger.CNonDelayTrigger;
import org.seasar.chronos.core.util.NormalATask;
import org.seasar.framework.unit.Seasar2;

@RunWith(Seasar2.class)
public class TaskPropertyWriterImplTest {

    private TaskPropertyWriter taskPropertyWriter;

    private final NormalATask testTask = new NormalATask();

    public void postBindFields() {
        taskPropertyWriter.setup(testTask, NormalATask.class);
    }

    @Test
    public void testSetThreadPoolType() {
        try {
            taskPropertyWriter.setThreadPoolType(ThreadPoolType.CACHED);
            assertEquals(testTask.getThreadPoolType(), ThreadPoolType.CACHED);
        } catch (final Exception ex) {
            fail();
        }
    }

    @Test
    public void testSetDescription() {
        try {
            taskPropertyWriter.setDescription("description");
            assertEquals(testTask.getDescription(), "description");
        } catch (final Exception ex) {
            fail();
        }
    }

    @Test
    public void testSetEndTask() {
        try {
            taskPropertyWriter.setEndTask(false);
            assertEquals(testTask.isEndTask(), false);
        } catch (final Exception ex) {
            fail();
        }
    }

    @Test
    public void testSetExecuted() {
        try {
            taskPropertyWriter.setExecuted(false);
            assertEquals(testTask.isExecuted(), false);
        } catch (final Exception ex) {
            fail();
        }
    }

    @Test
    public void testSetReSchedule() {
        try {
            taskPropertyWriter.setReSchedule(false);
            assertEquals(testTask.isReScheduleTask(), false);
        } catch (final Exception ex) {
            ex.printStackTrace();
            fail();
        }
    }

    @Test
    public void testSetShutdownTask() {
        try {
            taskPropertyWriter.setShutdownTask(false);
            assertEquals(testTask.isShutdownTask(), false);
        } catch (final Exception ex) {
            fail();
        }
    }

    @Test
    public void testSetStartTask() {
        try {
            taskPropertyWriter.setStartTask(false);
            assertEquals(testTask.isStartTask(), false);
        } catch (final Exception ex) {
            ex.printStackTrace();
            fail();
        }
    }

    @Test
    public void testSetTaskId() {
        try {
            taskPropertyWriter.setTaskId(1L);
            assertEquals(testTask.getTaskId(), Long.valueOf(1L));
        } catch (final Exception ex) {
            fail();
        }
    }

    @Test
    public void testSetTaskName() {
        try {
            taskPropertyWriter.setTaskName("taskName");
            assertEquals(testTask.getTaskName(), "taskName");
        } catch (final Exception ex) {
            fail();
        }
    }

    @Test
    public void testSetThreadPoolSize() {
        try {
            taskPropertyWriter.setThreadPoolSize(1);
            assertEquals(testTask.getThreadPoolSize(), 1);
        } catch (final Exception ex) {
            fail();
        }
    }

    @Test
    public void testSetTrigger() {
        try {
            final CNonDelayTrigger trigger = new CNonDelayTrigger();
            taskPropertyWriter.setTrigger(trigger);
            assertEquals(testTask.getTrigger(), trigger);
        } catch (final Exception ex) {
            fail();
        }
    }

    @Test
    public void testHasDescription() {
        try {
            taskPropertyWriter.hasDescription();
        } catch (final Exception ex) {
            fail();
        }
    }

    @Test
    public void testHasEndTask() {
        try {
            taskPropertyWriter.hasEndTask();
        } catch (final Exception ex) {
            fail();
        }
    }

    @Test
    public void testHasExecuted() {
        try {
            taskPropertyWriter.hasExecuted();
        } catch (final Exception ex) {
            fail();
        }
    }

    @Test
    public void testHasReSchedule() {
        try {
            taskPropertyWriter.hasReSchedule();
        } catch (final Exception ex) {
            fail();
        }
    }

    @Test
    public void testHasShutdownTask() {
        try {
            taskPropertyWriter.hasShutdownTask();
        } catch (final Exception ex) {
            fail();
        }
    }

    @Test
    public void testHasStartTask() {
        try {
            taskPropertyWriter.hasStartTask();
        } catch (final Exception ex) {
            fail();
        }
    }

    @Test
    public void testHasTaskId() {
        try {
            taskPropertyWriter.hasTaskId();
        } catch (final Exception ex) {
            fail();
        }
    }

    @Test
    public void testHasTaskName() {
        try {
            taskPropertyWriter.hasTaskName();
        } catch (final Exception ex) {
            fail();
        }
    }

    @Test
    public void testHasThreadPoolSize() {
        try {
            taskPropertyWriter.hasThreadPoolSize();
        } catch (final Exception ex) {
            fail();
        }
    }

    @Test
    public void testHasThreadPoolType() {
        try {
            taskPropertyWriter.hasThreadPoolType();
        } catch (final Exception ex) {
            fail();
        }
    }

    @Test
    public void testHasTrigger() {
        try {
            taskPropertyWriter.hasTrigger();
        } catch (final Exception ex) {
            fail();
        }
    }

}
