#!/bin/bash

ZK_HOSTS=$1

cd `dirname $0`
BASE_DIR=`pwd`
BUILD_DIR=$BASE_DIR/target
FESS_SRC_DIR=$BASE_DIR/src/fess
SOLR_SRC_DIR=$BASE_DIR/src/solr

FESS_DOWNLOAD_URL="http://sourceforge.jp/frs/redir.php?m=jaist&f=%2Ffess%2F58184%2Ffess-server-8.0.0.zip"
FESS_NAME=fess-server-8.0.0
FESS_SERVER_DIR=$BUILD_DIR/$FESS_NAME
SOLR_DOWNLOAD_URL=http://archive.apache.org/dist/lucene/solr/4.1.0/solr-4.1.0.zip
SOLR_NAME=solr-4.1.0
SOLR_DIR=$BUILD_DIR/$SOLR_NAME
SOLR_CLOUD_DIR=$BUILD_DIR/fess-cloud-jetty

if [ x$ZK_HOSTS = "x" ] ; then
    echo "ZooKeeper Hosts is requied. ex. localhost:9180,localhost:9280,localhost:9380"
    exit 1;
fi
echo "ZooKeeper Hosts: $ZK_HOSTS"

rm -rf $BUILD_DIR
mkdir -p $BUILD_DIR
mkdir -p $SOLR_CLOUD_DIR

cd $BUILD_DIR

echo "Downloading fess..."
wget -O ${FESS_NAME}.zip "$FESS_DOWNLOAD_URL"
#cp ../${FESS_NAME}.zip .
unzip ${FESS_NAME}.zip 
chmod +x $FESS_NAME/bin/*.sh

echo "Downloading solr..."
wget -O ${SOLR_NAME}.zip "$SOLR_DOWNLOAD_URL"
#cp ../${SOLR_NAME}.zip .
unzip ${SOLR_NAME}.zip 

echo "Creating collection..."
cp -r $SOLR_DIR/example/* $SOLR_CLOUD_DIR
rm -rf $SOLR_CLOUD_DIR/solr/collection1/
cp -r $FESS_SERVER_DIR/solr/core1/ $SOLR_CLOUD_DIR/solr/collection1
rm -rf $SOLR_CLOUD_DIR/example* $SOLR_CLOUD_DIR/multicore


echo "Copying jars from solr..."
cp -r $FESS_SERVER_DIR/solr/dist/ $SOLR_CLOUD_DIR/solr/
cp -r $FESS_SERVER_DIR/solr/contrib/ $SOLR_CLOUD_DIR/solr/
cp -r $FESS_SERVER_DIR/solr/lib/ $SOLR_CLOUD_DIR/solr/

# workaround to ignore dictionaries
mv $SOLR_CLOUD_DIR/solr/collection1/conf/dictionary/ $SOLR_CLOUD_DIR/solr/collection1/conf/.dictionary/

# remove solr context from fess
rm -rf $FESS_SERVER_DIR/webapps/solr/

echo "Overwriting solr config files..."
cp -r $SOLR_SRC_DIR/* $SOLR_CLOUD_DIR
sed -e "s/__FESS_ZK_HOSTS__/$ZK_HOSTS/g" $SOLR_SRC_DIR/bin/server.sh > $SOLR_CLOUD_DIR/bin/server.sh

echo "Overwrite fess config files..."
cp -r $FESS_SRC_DIR/* $FESS_SERVER_DIR
sed -e "s/__FESS_ZK_HOSTS__/$ZK_HOSTS/g" $FESS_SRC_DIR/webapps/fess/WEB-INF/classes/solrlib.dicon > $FESS_SERVER_DIR/webapps/fess/WEB-INF/classes/solrlib.dicon




