/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.bsentity.dbmeta;

import java.util.List;
import java.util.Map;

import jp.sf.fess.db.exentity.RequestHeader;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.AbstractDBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.ForeignInfo;
import org.seasar.dbflute.dbmeta.info.UniqueInfo;
import org.seasar.dbflute.helper.StringKeyMap;

/**
 * The DB meta of REQUEST_HEADER. (Singleton)
 * @author DBFlute(AutoGenerator)
 */
public class RequestHeaderDbm extends AbstractDBMeta {

    // ===================================================================================
    //                                                                           Singleton
    //                                                                           =========
    private static final RequestHeaderDbm _instance = new RequestHeaderDbm();

    private RequestHeaderDbm() {
    }

    public static RequestHeaderDbm getInstance() {
        return _instance;
    }

    // ===================================================================================
    //                                                                          Table Info
    //                                                                          ==========
    public String getTableDbName() {
        return "REQUEST_HEADER";
    }

    public String getTablePropertyName() {
        return "requestHeader";
    }

    public String getTableSqlName() {
        return "REQUEST_HEADER";
    }

    // ===================================================================================
    //                                                                         Column Info
    //                                                                         ===========
    protected ColumnInfo _columnId = cci("ID", null, "id", Long.class, true,
            false, null, null);

    protected ColumnInfo _columnName = cci("NAME", null, "name", String.class,
            false, false, 100, 0);

    protected ColumnInfo _columnValue = cci("VALUE", null, "value",
            String.class, false, false, 1000, 0);

    protected ColumnInfo _columnWebCrawlingConfigId = cci(
            "WEB_CRAWLING_CONFIG_ID", null, "webCrawlingConfigId", Long.class,
            false, false, null, null);

    protected ColumnInfo _columnCreatedBy = cci("CREATED_BY", null,
            "createdBy", String.class, false, false, 255, 0);

    protected ColumnInfo _columnCreatedTime = cci("CREATED_TIME", null,
            "createdTime", java.sql.Timestamp.class, false, false, null, null);

    protected ColumnInfo _columnUpdatedBy = cci("UPDATED_BY", null,
            "updatedBy", String.class, false, false, 255, 0);

    protected ColumnInfo _columnUpdatedTime = cci("UPDATED_TIME", null,
            "updatedTime", java.sql.Timestamp.class, false, false, null, null);

    protected ColumnInfo _columnDeletedBy = cci("DELETED_BY", null,
            "deletedBy", String.class, false, false, 255, 0);

    protected ColumnInfo _columnDeletedTime = cci("DELETED_TIME", null,
            "deletedTime", java.sql.Timestamp.class, false, false, null, null);

    protected ColumnInfo _columnVersionNo = cci("VERSION_NO", null,
            "versionNo", Integer.class, false, false, null, null,
            OptimisticLockType.VERSION_NO);

    public ColumnInfo columnId() {
        return _columnId;
    }

    public ColumnInfo columnName() {
        return _columnName;
    }

    public ColumnInfo columnValue() {
        return _columnValue;
    }

    public ColumnInfo columnWebCrawlingConfigId() {
        return _columnWebCrawlingConfigId;
    }

    public ColumnInfo columnCreatedBy() {
        return _columnCreatedBy;
    }

    public ColumnInfo columnCreatedTime() {
        return _columnCreatedTime;
    }

    public ColumnInfo columnUpdatedBy() {
        return _columnUpdatedBy;
    }

    public ColumnInfo columnUpdatedTime() {
        return _columnUpdatedTime;
    }

    public ColumnInfo columnDeletedBy() {
        return _columnDeletedBy;
    }

    public ColumnInfo columnDeletedTime() {
        return _columnDeletedTime;
    }

    public ColumnInfo columnVersionNo() {
        return _columnVersionNo;
    }

    {
        initializeInformationResource();
    }

    // ===================================================================================
    //                                                                         Unique Info
    //                                                                         ===========
    // -----------------------------------------------------
    //                                       Primary Element
    //                                       ---------------
    public UniqueInfo getPrimaryUniqueInfo() {
        return cpui(columnId());
    }

    public boolean hasPrimaryKey() {
        return true;
    }

    public boolean hasTwoOrMorePrimaryKeys() {
        return false;
    }

    // ===================================================================================
    //                                                                       Relation Info
    //                                                                       =============
    // -----------------------------------------------------
    //                                      Foreign Property
    //                                      ----------------
    public ForeignInfo foreignWebCrawlingConfig() {
        Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(
                columnWebCrawlingConfigId(), WebCrawlingConfigDbm.getInstance()
                        .columnId());
        return cfi("webCrawlingConfig", this, WebCrawlingConfigDbm
                .getInstance(), map, 0, false);
    }

    // -----------------------------------------------------
    //                                     Referrer Property
    //                                     -----------------

    // ===================================================================================
    //                                                                        Various Info
    //                                                                        ============
    public boolean hasVersionNo() {
        return true;
    }

    public ColumnInfo getVersionNoColumnInfo() {
        return _columnVersionNo;
    }

    // ===================================================================================
    //                                                                           Type Name
    //                                                                           =========
    public String getEntityTypeName() {
        return "jp.sf.fess.db.exentity.RequestHeader";
    }

    public String getConditionBeanTypeName() {
        return "jp.sf.fess.db.cbean.bs.RequestHeaderCB";
    }

    public String getDaoTypeName() {
        return "jp.sf.fess.db.exdao.RequestHeaderDao";
    }

    public String getBehaviorTypeName() {
        return "jp.sf.fess.db.exbhv.RequestHeaderBhv";
    }

    // ===================================================================================
    //                                                                         Object Type
    //                                                                         ===========
    public Class<RequestHeader> getEntityType() {
        return RequestHeader.class;
    }

    // ===================================================================================
    //                                                                     Object Instance
    //                                                                     ===============
    public Entity newEntity() {
        return newMyEntity();
    }

    public RequestHeader newMyEntity() {
        return new RequestHeader();
    }

    // ===================================================================================
    //                                                                     Entity Handling
    //                                                                     ===============  
    // -----------------------------------------------------
    //                                                Accept
    //                                                ------
    public void acceptPrimaryKeyMap(Entity entity,
            Map<String, ? extends Object> primaryKeyMap) {
        doAcceptPrimaryKeyMap((RequestHeader) entity, primaryKeyMap, _epsMap);
    }

    public void acceptPrimaryKeyMapString(Entity entity,
            String primaryKeyMapString) {
        MapStringUtil.acceptPrimaryKeyMapString(primaryKeyMapString, entity);
    }

    public void acceptColumnValueMap(Entity entity,
            Map<String, ? extends Object> columnValueMap) {
        doAcceptColumnValueMap((RequestHeader) entity, columnValueMap, _epsMap);
    }

    public void acceptColumnValueMapString(Entity entity,
            String columnValueMapString) {
        MapStringUtil.acceptColumnValueMapString(columnValueMapString, entity);
    }

    // -----------------------------------------------------
    //                                               Extract
    //                                               -------
    public String extractPrimaryKeyMapString(Entity entity) {
        return MapStringUtil.extractPrimaryKeyMapString(entity);
    }

    public String extractPrimaryKeyMapString(Entity entity, String startBrace,
            String endBrace, String delimiter, String equal) {
        return doExtractPrimaryKeyMapString(entity, startBrace, endBrace,
                delimiter, equal);
    }

    public String extractColumnValueMapString(Entity entity) {
        return MapStringUtil.extractColumnValueMapString(entity);
    }

    public String extractColumnValueMapString(Entity entity, String startBrace,
            String endBrace, String delimiter, String equal) {
        return doExtractColumnValueMapString(entity, startBrace, endBrace,
                delimiter, equal);
    }

    // -----------------------------------------------------
    //                                               Convert
    //                                               -------
    public List<Object> convertToColumnValueList(Entity entity) {
        return newArrayList(convertToColumnValueMap(entity).values());
    }

    public Map<String, Object> convertToColumnValueMap(Entity entity) {
        return doConvertToColumnValueMap(entity);
    }

    public List<String> convertToColumnStringValueList(Entity entity) {
        return newArrayList(convertToColumnStringValueMap(entity).values());
    }

    public Map<String, String> convertToColumnStringValueMap(Entity entity) {
        return doConvertToColumnStringValueMap(entity);
    }

    // ===================================================================================
    //                                                               Entity Property Setup
    //                                                               =====================
    // It's very INTERNAL!
    protected final Map<String, Eps<RequestHeader>> _epsMap = StringKeyMap
            .createAsFlexibleConcurrent();
    {
        setupEps(_epsMap, new EpsId(), columnId());
        setupEps(_epsMap, new EpsName(), columnName());
        setupEps(_epsMap, new EpsValue(), columnValue());
        setupEps(_epsMap, new EpsWebCrawlingConfigId(),
                columnWebCrawlingConfigId());
        setupEps(_epsMap, new EpsCreatedBy(), columnCreatedBy());
        setupEps(_epsMap, new EpsCreatedTime(), columnCreatedTime());
        setupEps(_epsMap, new EpsUpdatedBy(), columnUpdatedBy());
        setupEps(_epsMap, new EpsUpdatedTime(), columnUpdatedTime());
        setupEps(_epsMap, new EpsDeletedBy(), columnDeletedBy());
        setupEps(_epsMap, new EpsDeletedTime(), columnDeletedTime());
        setupEps(_epsMap, new EpsVersionNo(), columnVersionNo());
    }

    public boolean hasEntityPropertySetupper(String propertyName) {
        return _epsMap.containsKey(propertyName);
    }

    public void setupEntityProperty(String propertyName, Object entity,
            Object value) {
        findEps(_epsMap, propertyName).setup((RequestHeader) entity, value);
    }

    public static class EpsId implements Eps<RequestHeader> {
        public void setup(RequestHeader e, Object v) {
            e.setId((Long) v);
        }
    }

    public static class EpsName implements Eps<RequestHeader> {
        public void setup(RequestHeader e, Object v) {
            e.setName((String) v);
        }
    }

    public static class EpsValue implements Eps<RequestHeader> {
        public void setup(RequestHeader e, Object v) {
            e.setValue((String) v);
        }
    }

    public static class EpsWebCrawlingConfigId implements Eps<RequestHeader> {
        public void setup(RequestHeader e, Object v) {
            e.setWebCrawlingConfigId((Long) v);
        }
    }

    public static class EpsCreatedBy implements Eps<RequestHeader> {
        public void setup(RequestHeader e, Object v) {
            e.setCreatedBy((String) v);
        }
    }

    public static class EpsCreatedTime implements Eps<RequestHeader> {
        public void setup(RequestHeader e, Object v) {
            e.setCreatedTime((java.sql.Timestamp) v);
        }
    }

    public static class EpsUpdatedBy implements Eps<RequestHeader> {
        public void setup(RequestHeader e, Object v) {
            e.setUpdatedBy((String) v);
        }
    }

    public static class EpsUpdatedTime implements Eps<RequestHeader> {
        public void setup(RequestHeader e, Object v) {
            e.setUpdatedTime((java.sql.Timestamp) v);
        }
    }

    public static class EpsDeletedBy implements Eps<RequestHeader> {
        public void setup(RequestHeader e, Object v) {
            e.setDeletedBy((String) v);
        }
    }

    public static class EpsDeletedTime implements Eps<RequestHeader> {
        public void setup(RequestHeader e, Object v) {
            e.setDeletedTime((java.sql.Timestamp) v);
        }
    }

    public static class EpsVersionNo implements Eps<RequestHeader> {
        public void setup(RequestHeader e, Object v) {
            e.setVersionNo((Integer) v);
        }
    }
}
