/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.helper;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import jp.sf.fess.Constants;

import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.util.StringUtil;
import org.seasar.struts.util.RequestUtil;

public class QueryHelper implements Serializable {

    private static final long serialVersionUID = 1L;

    @Binding(bindingType = BindingType.MAY)
    @Resource
    protected BrowserTypeHelper browserTypeHelper;

    public String build(String query) {
        String baseQuery = buildQuery(query);
        if (StringUtil.isBlank(baseQuery)) {
            return "";
        }

        if (browserTypeHelper == null) {
            return baseQuery;
        }

        return "(" + baseQuery + ") AND type:"
                + browserTypeHelper.getBrowserType();
    }

    protected String buildQuery(String query) {
        String[] values = splitQuery(query);
        if (values.length == 0) {
            return "";
        }

        // set queries to request
        RequestUtil.getRequest().setAttribute(Constants.QUERIES, values);

        StringBuilder titleBuf = new StringBuilder();
        StringBuilder contentBuf = new StringBuilder();
        for (String value : values) {
            // title
            if (titleBuf.length() > 0) {
                titleBuf.append(" AND ");
            }
            titleBuf.append("title:\"");
            titleBuf.append(value);
            titleBuf.append('"');

            // content
            if (contentBuf.length() > 0) {
                contentBuf.append(" AND ");
            }
            contentBuf.append("content:\"");
            contentBuf.append(value);
            contentBuf.append('"');
        }

        return "(" + titleBuf.toString() + ") OR (" + contentBuf.toString()
                + ")";
    }

    protected String[] splitQuery(String query) {
        List<String> valueList = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        boolean quoted = false;
        for (int i = 0; i < query.length(); i++) {
            char c = query.charAt(i);
            switch (c) {
            case '"':
                quoted = !quoted;
                break;
            case ' ':
                if (quoted) {
                    buf.append(c);
                } else {
                    if (buf.length() > 0) {
                        valueList.add(buf.toString());
                    }
                    buf = new StringBuilder();
                }
                break;
            default:
                buf.append(c);
                break;
            }
        }
        if (buf.length() > 0) {
            valueList.add(buf.toString());
        }
        return valueList.toArray(new String[valueList.size()]);
    }
}
