/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.allcommon.DBCurrent;
import jp.sf.fess.db.allcommon.DBFluteConfig;
import jp.sf.fess.db.bsentity.dbmeta.FileCrawlingConfigDbm;
import jp.sf.fess.db.cbean.FileConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.FileConfigToLabelTypeMappingCB;
import jp.sf.fess.db.cbean.FileConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.FileCrawlingConfigCB;
import jp.sf.fess.db.exbhv.FileConfigToBrowserTypeMappingBhv;
import jp.sf.fess.db.exbhv.FileConfigToLabelTypeMappingBhv;
import jp.sf.fess.db.exbhv.FileConfigToRoleTypeMappingBhv;
import jp.sf.fess.db.exentity.FileConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.FileConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.FileConfigToRoleTypeMapping;
import jp.sf.fess.db.exentity.FileCrawlingConfig;

import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.ConditionBeanSetupper;
import org.seasar.dbflute.bhv.LoadReferrerOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingBean;
import org.seasar.dbflute.cbean.PagingHandler;
import org.seasar.dbflute.cbean.PagingInvoker;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.ResultBeanBuilder;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.jdbc.StatementConfig;

/**
 * The behavior of FILE_CRAWLING_CONFIG that the type is TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, NAME, PATHS, INCLUDED_PATHS, EXCLUDED_PATHS, DEPTH, MAX_ACCESS_COUNT, NUM_OF_THREAD, INTERVAL_TIME, AVAILABLE, SORT_ORDER, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     FILE_CONFIG_TO_BROWSER_TYPE_MAPPING, FILE_CONFIG_TO_LABEL_TYPE_MAPPING, FILE_CONFIG_TO_ROLE_TYPE_MAPPING
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     fileConfigToBrowserTypeMappingList, fileConfigToLabelTypeMappingList, fileConfigToRoleTypeMappingList
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsFileCrawlingConfigBhv extends
        org.seasar.dbflute.bhv.AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "FILE_CRAWLING_CONFIG";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return FileCrawlingConfigDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public FileCrawlingConfigDbm getMyDBMeta() {
        return FileCrawlingConfigDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    public Entity newEntity() {
        return newMyEntity();
    }

    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    public FileCrawlingConfig newMyEntity() {
        return new FileCrawlingConfig();
    }

    public FileCrawlingConfigCB newMyConditionBean() {
        return new FileCrawlingConfigCB();
    }

    // ===================================================================================
    //                                                                       Current DBDef
    //                                                                       =============
    @Override
    protected DBDef getCurrentDBDef() {
        return DBCurrent.getInstance().currentDBDef();
    }

    // ===================================================================================
    //                                                             Default StatementConfig
    //                                                             =======================
    @Override
    protected StatementConfig getDefaultStatementConfig() {
        return DBFluteConfig.getInstance().getDefaultStatementConfig();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * @param cb The condition-bean of FileCrawlingConfig. (NotNull)
     * @return The selected count.
     */
    public int selectCount(FileCrawlingConfigCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean. <br />
     * Attention: It has a mapping cost from result set to entity.
     * @param cb The condition-bean of FileCrawlingConfig. (NotNull)
     * @param entityRowHandler The handler of entity row of FileCrawlingConfig. (NotNull)
     */
    public void selectCursor(FileCrawlingConfigCB cb,
            EntityRowHandler<FileCrawlingConfig> entityRowHandler) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<FileCrawlingConfig>",
                entityRowHandler);
        delegateSelectCursor(cb, entityRowHandler);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * @param cb The condition-bean of FileCrawlingConfig. (NotNull)
     * @return The selected entity. (Nullalble)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public FileCrawlingConfig selectEntity(final FileCrawlingConfigCB cb) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<FileCrawlingConfig, FileCrawlingConfigCB>() {
                    public List<FileCrawlingConfig> callbackSelectList(
                            FileCrawlingConfigCB cb) {
                        return selectList(cb);
                    }
                });
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * @param cb The condition-bean of FileCrawlingConfig. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public FileCrawlingConfig selectEntityWithDeletedCheck(
            final FileCrawlingConfigCB cb) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<FileCrawlingConfig, FileCrawlingConfigCB>() {
                    public List<FileCrawlingConfig> callbackSelectList(
                            FileCrawlingConfigCB cb) {
                        return selectList(cb);
                    }
                });
    }

    /* (non-javadoc)
     * Select the entity with deleted check. {by primary-key value}
     * @param primaryKey The keys of primary.
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public FileCrawlingConfig selectByPKValueWithDeletedCheck(Long id) {
        FileCrawlingConfig entity = new FileCrawlingConfig();
        entity.setId(id);
        final FileCrawlingConfigCB cb = newMyConditionBean();
        cb.acceptPrimaryKeyMapString(getDBMeta().extractPrimaryKeyMapString(
                entity));
        return selectEntityWithDeletedCheck(cb);
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * @param cb The condition-bean of FileCrawlingConfig. (NotNull)
     * @return The result bean of selected list. (NotNull)
     */
    public ListResultBean<FileCrawlingConfig> selectList(FileCrawlingConfigCB cb) {
        assertCBNotNull(cb);
        return new ResultBeanBuilder<FileCrawlingConfig>(getTableDbName())
                .buildListResultBean(cb, delegateSelectList(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean.
     * @param cb The condition-bean of FileCrawlingConfig. (NotNull)
     * @return The result bean of selected page. (NotNull)
     */
    public PagingResultBean<FileCrawlingConfig> selectPage(
            final FileCrawlingConfigCB cb) {
        assertCBNotNull(cb);
        final PagingInvoker<FileCrawlingConfig> invoker = new PagingInvoker<FileCrawlingConfig>(
                getTableDbName());
        final PagingHandler<FileCrawlingConfig> handler = new PagingHandler<FileCrawlingConfig>() {
            public PagingBean getPagingBean() {
                return cb;
            }

            public int count() {
                return selectCount(cb);
            }

            public List<FileCrawlingConfig> paging() {
                return selectList(cb);
            }
        };
        return invoker.invokePaging(handler);
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * Call a function method after this method called like as follows:
     * <pre>
     * fileCrawlingConfigBhv.scalarSelect(Date.class).max(new ScalarQuery(FileCrawlingConfigCB cb) {
     *     cb.specify().columnXxxDatetime(); // the required specification of target column
     *     cb.query().setXxxName_PrefixSearch("S"); // query as you like it
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<FileCrawlingConfigCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        FileCrawlingConfigCB cb = newMyConditionBean();
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<FileCrawlingConfigCB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                       Load Referrer
    //                                                                       =============
    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param fileCrawlingConfig The entity of fileCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadFileConfigToBrowserTypeMappingList(
            FileCrawlingConfig fileCrawlingConfig,
            ConditionBeanSetupper<FileConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(fileCrawlingConfig, conditionBeanSetupper);
        loadFileConfigToBrowserTypeMappingList(xnewLRLs(fileCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of fileConfigToBrowserTypeMappingList with the setupper for condition-bean of referrer. <br />
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the setupper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setFileConfigId_InScope(pkList);
     * cb.query().addOrderBy_FileConfigId_Asc();
     * </pre>
     * @param fileCrawlingConfigList The entity list of fileCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadFileConfigToBrowserTypeMappingList(
            List<FileCrawlingConfig> fileCrawlingConfigList,
            ConditionBeanSetupper<FileConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(fileCrawlingConfigList, conditionBeanSetupper);
        loadFileConfigToBrowserTypeMappingList(
                fileCrawlingConfigList,
                new LoadReferrerOption<FileConfigToBrowserTypeMappingCB, FileConfigToBrowserTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param fileCrawlingConfig The entity of fileCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileConfigToBrowserTypeMappingList(
            FileCrawlingConfig fileCrawlingConfig,
            LoadReferrerOption<FileConfigToBrowserTypeMappingCB, FileConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(fileCrawlingConfig, loadReferrerOption);
        loadFileConfigToBrowserTypeMappingList(xnewLRLs(fileCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param fileCrawlingConfigList The entity list of fileCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileConfigToBrowserTypeMappingList(
            List<FileCrawlingConfig> fileCrawlingConfigList,
            LoadReferrerOption<FileConfigToBrowserTypeMappingCB, FileConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(fileCrawlingConfigList, loadReferrerOption);
        if (fileCrawlingConfigList.isEmpty()) {
            return;
        }
        final FileConfigToBrowserTypeMappingBhv referrerBhv = xgetBSFLR()
                .select(FileConfigToBrowserTypeMappingBhv.class);
        helpLoadReferrerInternally(
                fileCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<FileCrawlingConfig, Long, FileConfigToBrowserTypeMappingCB, FileConfigToBrowserTypeMapping>() {
                    public Long callbackBase_getPrimaryKeyValue(
                            FileCrawlingConfig entity) {
                        return entity.getId();
                    }

                    public void callbackBase_setReferrerList(
                            FileCrawlingConfig entity,
                            List<FileConfigToBrowserTypeMapping> referrerList) {
                        entity
                                .setFileConfigToBrowserTypeMappingList(referrerList);
                    }

                    public FileConfigToBrowserTypeMappingCB callbackReferrer_newMyConditionBean() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void callbackReferrer_queryForeignKeyInScope(
                            FileConfigToBrowserTypeMappingCB cb,
                            List<Long> pkList) {
                        cb.query().setFileConfigId_InScope(pkList);
                    }

                    public void callbackReferrer_queryAddOrderByForeignKeyAsc(
                            FileConfigToBrowserTypeMappingCB cb) {
                        cb.query().addOrderBy_FileConfigId_Asc();
                    }

                    public List<FileConfigToBrowserTypeMapping> callbackReferrer_selectList(
                            FileConfigToBrowserTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long callbackReferrer_getForeignKeyValue(
                            FileConfigToBrowserTypeMapping entity) {
                        return entity.getFileConfigId();
                    }

                    public void callbackReferrer_setForeignEntity(
                            FileConfigToBrowserTypeMapping referrerEntity,
                            FileCrawlingConfig baseEntity) {
                        referrerEntity.setFileCrawlingConfig(baseEntity);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param fileCrawlingConfig The entity of fileCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadFileConfigToLabelTypeMappingList(
            FileCrawlingConfig fileCrawlingConfig,
            ConditionBeanSetupper<FileConfigToLabelTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(fileCrawlingConfig, conditionBeanSetupper);
        loadFileConfigToLabelTypeMappingList(xnewLRLs(fileCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of fileConfigToLabelTypeMappingList with the setupper for condition-bean of referrer. <br />
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the setupper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setFileConfigId_InScope(pkList);
     * cb.query().addOrderBy_FileConfigId_Asc();
     * </pre>
     * @param fileCrawlingConfigList The entity list of fileCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadFileConfigToLabelTypeMappingList(
            List<FileCrawlingConfig> fileCrawlingConfigList,
            ConditionBeanSetupper<FileConfigToLabelTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(fileCrawlingConfigList, conditionBeanSetupper);
        loadFileConfigToLabelTypeMappingList(
                fileCrawlingConfigList,
                new LoadReferrerOption<FileConfigToLabelTypeMappingCB, FileConfigToLabelTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param fileCrawlingConfig The entity of fileCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileConfigToLabelTypeMappingList(
            FileCrawlingConfig fileCrawlingConfig,
            LoadReferrerOption<FileConfigToLabelTypeMappingCB, FileConfigToLabelTypeMapping> loadReferrerOption) {
        xassLRArg(fileCrawlingConfig, loadReferrerOption);
        loadFileConfigToLabelTypeMappingList(xnewLRLs(fileCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param fileCrawlingConfigList The entity list of fileCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileConfigToLabelTypeMappingList(
            List<FileCrawlingConfig> fileCrawlingConfigList,
            LoadReferrerOption<FileConfigToLabelTypeMappingCB, FileConfigToLabelTypeMapping> loadReferrerOption) {
        xassLRArg(fileCrawlingConfigList, loadReferrerOption);
        if (fileCrawlingConfigList.isEmpty()) {
            return;
        }
        final FileConfigToLabelTypeMappingBhv referrerBhv = xgetBSFLR().select(
                FileConfigToLabelTypeMappingBhv.class);
        helpLoadReferrerInternally(
                fileCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<FileCrawlingConfig, Long, FileConfigToLabelTypeMappingCB, FileConfigToLabelTypeMapping>() {
                    public Long callbackBase_getPrimaryKeyValue(
                            FileCrawlingConfig entity) {
                        return entity.getId();
                    }

                    public void callbackBase_setReferrerList(
                            FileCrawlingConfig entity,
                            List<FileConfigToLabelTypeMapping> referrerList) {
                        entity
                                .setFileConfigToLabelTypeMappingList(referrerList);
                    }

                    public FileConfigToLabelTypeMappingCB callbackReferrer_newMyConditionBean() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void callbackReferrer_queryForeignKeyInScope(
                            FileConfigToLabelTypeMappingCB cb, List<Long> pkList) {
                        cb.query().setFileConfigId_InScope(pkList);
                    }

                    public void callbackReferrer_queryAddOrderByForeignKeyAsc(
                            FileConfigToLabelTypeMappingCB cb) {
                        cb.query().addOrderBy_FileConfigId_Asc();
                    }

                    public List<FileConfigToLabelTypeMapping> callbackReferrer_selectList(
                            FileConfigToLabelTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long callbackReferrer_getForeignKeyValue(
                            FileConfigToLabelTypeMapping entity) {
                        return entity.getFileConfigId();
                    }

                    public void callbackReferrer_setForeignEntity(
                            FileConfigToLabelTypeMapping referrerEntity,
                            FileCrawlingConfig baseEntity) {
                        referrerEntity.setFileCrawlingConfig(baseEntity);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param fileCrawlingConfig The entity of fileCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadFileConfigToRoleTypeMappingList(
            FileCrawlingConfig fileCrawlingConfig,
            ConditionBeanSetupper<FileConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(fileCrawlingConfig, conditionBeanSetupper);
        loadFileConfigToRoleTypeMappingList(xnewLRLs(fileCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of fileConfigToRoleTypeMappingList with the setupper for condition-bean of referrer. <br />
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the setupper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setFileConfigId_InScope(pkList);
     * cb.query().addOrderBy_FileConfigId_Asc();
     * </pre>
     * @param fileCrawlingConfigList The entity list of fileCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadFileConfigToRoleTypeMappingList(
            List<FileCrawlingConfig> fileCrawlingConfigList,
            ConditionBeanSetupper<FileConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(fileCrawlingConfigList, conditionBeanSetupper);
        loadFileConfigToRoleTypeMappingList(
                fileCrawlingConfigList,
                new LoadReferrerOption<FileConfigToRoleTypeMappingCB, FileConfigToRoleTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param fileCrawlingConfig The entity of fileCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileConfigToRoleTypeMappingList(
            FileCrawlingConfig fileCrawlingConfig,
            LoadReferrerOption<FileConfigToRoleTypeMappingCB, FileConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(fileCrawlingConfig, loadReferrerOption);
        loadFileConfigToRoleTypeMappingList(xnewLRLs(fileCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param fileCrawlingConfigList The entity list of fileCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileConfigToRoleTypeMappingList(
            List<FileCrawlingConfig> fileCrawlingConfigList,
            LoadReferrerOption<FileConfigToRoleTypeMappingCB, FileConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(fileCrawlingConfigList, loadReferrerOption);
        if (fileCrawlingConfigList.isEmpty()) {
            return;
        }
        final FileConfigToRoleTypeMappingBhv referrerBhv = xgetBSFLR().select(
                FileConfigToRoleTypeMappingBhv.class);
        helpLoadReferrerInternally(
                fileCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<FileCrawlingConfig, Long, FileConfigToRoleTypeMappingCB, FileConfigToRoleTypeMapping>() {
                    public Long callbackBase_getPrimaryKeyValue(
                            FileCrawlingConfig entity) {
                        return entity.getId();
                    }

                    public void callbackBase_setReferrerList(
                            FileCrawlingConfig entity,
                            List<FileConfigToRoleTypeMapping> referrerList) {
                        entity.setFileConfigToRoleTypeMappingList(referrerList);
                    }

                    public FileConfigToRoleTypeMappingCB callbackReferrer_newMyConditionBean() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void callbackReferrer_queryForeignKeyInScope(
                            FileConfigToRoleTypeMappingCB cb, List<Long> pkList) {
                        cb.query().setFileConfigId_InScope(pkList);
                    }

                    public void callbackReferrer_queryAddOrderByForeignKeyAsc(
                            FileConfigToRoleTypeMappingCB cb) {
                        cb.query().addOrderBy_FileConfigId_Asc();
                    }

                    public List<FileConfigToRoleTypeMapping> callbackReferrer_selectList(
                            FileConfigToRoleTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long callbackReferrer_getForeignKeyValue(
                            FileConfigToRoleTypeMapping entity) {
                        return entity.getFileConfigId();
                    }

                    public void callbackReferrer_setForeignEntity(
                            FileConfigToRoleTypeMapping referrerEntity,
                            FileCrawlingConfig baseEntity) {
                        referrerEntity.setFileCrawlingConfig(baseEntity);
                    }
                });
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * @param fileCrawlingConfig The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(FileCrawlingConfig fileCrawlingConfig) {
        assertEntityNotNull(fileCrawlingConfig);
        delegateInsert(fileCrawlingConfig);
    }

    @Override
    protected void doCreate(Entity fileCrawlingConfig) {
        insert((FileCrawlingConfig) fileCrawlingConfig);
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ConcurrencyControl}
     * @param fileCrawlingConfig The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final FileCrawlingConfig fileCrawlingConfig) {
        helpUpdateInternally(fileCrawlingConfig,
                new InternalUpdateCallback<FileCrawlingConfig>() {
                    public int callbackDelegateUpdate(FileCrawlingConfig entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update((FileCrawlingConfig) entity);
    }

    /**
     * Update the entity non-strictly modified-only. {UpdateCountZeroException, NonConcurrencyControl}
     * @param fileCrawlingConfig The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void updateNonstrict(final FileCrawlingConfig fileCrawlingConfig) {
        helpUpdateNonstrictInternally(fileCrawlingConfig,
                new InternalUpdateNonstrictCallback<FileCrawlingConfig>() {
                    public int callbackDelegateUpdateNonstrict(
                            FileCrawlingConfig entity) {
                        return delegateUpdateNonstrict(entity);
                    }
                });
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        updateNonstrict((FileCrawlingConfig) entity);
    }

    /**
     * Insert or update the entity modified-only. {ConcurrencyControl(when update)}
     * @param fileCrawlingConfig The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(final FileCrawlingConfig fileCrawlingConfig) {
        helpInsertOrUpdateInternally(
                fileCrawlingConfig,
                new InternalInsertOrUpdateCallback<FileCrawlingConfig, FileCrawlingConfigCB>() {
                    public void callbackInsert(FileCrawlingConfig entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(FileCrawlingConfig entity) {
                        update(entity);
                    }

                    public FileCrawlingConfigCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(FileCrawlingConfigCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity fileCrawlingConfig) {
        insertOrUpdate((FileCrawlingConfig) fileCrawlingConfig);
    }

    /**
     * Insert or update the entity non-strictly modified-only. {NonConcurrencyControl(when update)}
     * @param fileCrawlingConfig The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdateNonstrict(FileCrawlingConfig fileCrawlingConfig) {
        helpInsertOrUpdateInternally(
                fileCrawlingConfig,
                new InternalInsertOrUpdateNonstrictCallback<FileCrawlingConfig>() {
                    public void callbackInsert(FileCrawlingConfig entity) {
                        insert(entity);
                    }

                    public void callbackUpdateNonstrict(
                            FileCrawlingConfig entity) {
                        updateNonstrict(entity);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdateNonstrict((FileCrawlingConfig) entity);
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ConcurrencyControl}
     * @param fileCrawlingConfig The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(FileCrawlingConfig fileCrawlingConfig) {
        helpDeleteInternally(fileCrawlingConfig,
                new InternalDeleteCallback<FileCrawlingConfig>() {
                    public int callbackDelegateDelete(FileCrawlingConfig entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity fileCrawlingConfig) {
        delete((FileCrawlingConfig) fileCrawlingConfig);
    }

    /**
     * Delete the entity non-strictly. {UpdateCountZeroException, NonConcurrencyControl}
     * @param fileCrawlingConfig Entity. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrict(FileCrawlingConfig fileCrawlingConfig) {
        helpDeleteNonstrictInternally(fileCrawlingConfig,
                new InternalDeleteNonstrictCallback<FileCrawlingConfig>() {
                    public int callbackDelegateDeleteNonstrict(
                            FileCrawlingConfig entity) {
                        return delegateDeleteNonstrict(entity);
                    }
                });
    }

    /**
     * Delete the entity non-strictly ignoring deleted. {UpdateCountZeroException, NonConcurrencyControl}
     * @param fileCrawlingConfig Entity. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrictIgnoreDeleted(
            FileCrawlingConfig fileCrawlingConfig) {
        helpDeleteNonstrictIgnoreDeletedInternally(
                fileCrawlingConfig,
                new InternalDeleteNonstrictIgnoreDeletedCallback<FileCrawlingConfig>() {
                    public int callbackDelegateDeleteNonstrict(
                            FileCrawlingConfig entity) {
                        return delegateDeleteNonstrict(entity);
                    }
                });
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch insert the list. This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param fileCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<FileCrawlingConfig> fileCrawlingConfigList) {
        assertObjectNotNull("fileCrawlingConfigList", fileCrawlingConfigList);
        return delegateInsertList(fileCrawlingConfigList);
    }

    /**
     * Batch update the list. All columns are update target. {NOT modified only} <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param fileCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<FileCrawlingConfig> fileCrawlingConfigList) {
        assertObjectNotNull("fileCrawlingConfigList", fileCrawlingConfigList);
        return delegateUpdateList(fileCrawlingConfigList);
    }

    /**
     * Batch update the list non-strictly. All columns are update target. {NOT modified only} <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param fileCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(
            List<FileCrawlingConfig> fileCrawlingConfigList) {
        assertObjectNotNull("fileCrawlingConfigList", fileCrawlingConfigList);
        return delegateUpdateListNonstrict(fileCrawlingConfigList);
    }

    /**
     * Batch delete the list. <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param fileCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchDelete(List<FileCrawlingConfig> fileCrawlingConfigList) {
        assertObjectNotNull("fileCrawlingConfigList", fileCrawlingConfigList);
        return delegateDeleteList(fileCrawlingConfigList);
    }

    /**
     * Batch delete the list non-strictly. <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param fileCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDeleteNonstrict(
            List<FileCrawlingConfig> fileCrawlingConfigList) {
        assertObjectNotNull("fileCrawlingConfigList", fileCrawlingConfigList);
        return delegateDeleteListNonstrict(fileCrawlingConfigList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query update the several entities. {NoConcurrencyControl}
     * @param fileCrawlingConfig Entity. (NotNull) {PrimaryKeyNotRequired}
     * @param cb Condition-bean. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(FileCrawlingConfig fileCrawlingConfig,
            FileCrawlingConfigCB cb) {
        assertObjectNotNull("fileCrawlingConfig", fileCrawlingConfig);
        assertCBNotNull(cb);
        setupCommonColumnOfUpdateIfNeeds(fileCrawlingConfig);
        filterEntityOfUpdate(fileCrawlingConfig);
        assertEntityOfUpdate(fileCrawlingConfig);
        return invoke(createQueryUpdateEntityCBCommand(fileCrawlingConfig, cb));
    }

    /**
     * Query delete the several entities. {NoConcurrencyControl}
     * @param cb Condition-bean. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(FileCrawlingConfigCB cb) {
        assertCBNotNull(cb);
        return invoke(createQueryDeleteCBCommand(cb));
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(FileCrawlingConfigCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected void delegateSelectCursor(FileCrawlingConfigCB cb,
            EntityRowHandler<FileCrawlingConfig> entityRowHandler) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler,
                FileCrawlingConfig.class));
    }

    protected int doCallReadCount(ConditionBean cb) {
        return delegateSelectCount((FileCrawlingConfigCB) cb);
    }

    protected List<FileCrawlingConfig> delegateSelectList(
            FileCrawlingConfigCB cb) {
        return invoke(createSelectListCBCommand(cb, FileCrawlingConfig.class));
    }

    @SuppressWarnings("unchecked")
    protected List<Entity> doCallReadList(ConditionBean cb) {
        return (List) delegateSelectList((FileCrawlingConfigCB) cb);
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(FileCrawlingConfig e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int doCallCreate(Entity entity) {
        return delegateInsert(downcast(entity));
    }

    protected int delegateUpdate(FileCrawlingConfig e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateEntityCommand(e));
    }

    protected int doCallModify(Entity entity) {
        return delegateUpdate(downcast(entity));
    }

    protected int delegateUpdateNonstrict(FileCrawlingConfig e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(FileCrawlingConfig e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteEntityCommand(e));
    }

    protected int doCallRemove(Entity entity) {
        return delegateDelete(downcast(entity));
    }

    protected int delegateDeleteNonstrict(FileCrawlingConfig e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<FileCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<FileCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateUpdateListNonstrict(List<FileCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    protected int[] delegateDeleteList(List<FileCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int[] delegateDeleteListNonstrict(List<FileCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return !(downcast(entity).getVersionNo() + "").equals("null");// For primitive type
    }

    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                              Helper
    //                                                                              ======
    protected FileCrawlingConfig downcast(Entity entity) {
        return helpDowncastInternally(entity, FileCrawlingConfig.class);
    }
}
