/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsentity;

import java.io.Serializable;
import java.util.Set;

import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.exentity.DataCrawlingConfig;
import jp.sf.fess.db.exentity.LabelType;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The entity of DATA_CONFIG_TO_LABEL_TYPE_MAPPING that the type is TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, DATA_CONFIG_ID, LABEL_TYPE_ID
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     DATA_CRAWLING_CONFIG, LABEL_TYPE
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     dataCrawlingConfig, labelType
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsDataConfigToLabelTypeMapping implements Entity,
        Serializable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /** Serial version UID. (Default) */
    private static final long serialVersionUID = 1L;

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    // -----------------------------------------------------
    //                                                Column
    //                                                ------
    /** ID: {PK : ID : NotNull : BIGINT} */
    protected Long _id;

    /** DATA_CONFIG_ID: {NotNull : BIGINT : FK to DATA_CRAWLING_CONFIG} */
    protected Long _dataConfigId;

    /** LABEL_TYPE_ID: {NotNull : BIGINT : FK to LABEL_TYPE} */
    protected Long _labelTypeId;

    // -----------------------------------------------------
    //                                              Internal
    //                                              --------
    /** The attribute of entity modified properties. (for S2Dao) */
    protected EntityModifiedProperties _modifiedProperties = newEntityModifiedProperties();

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    public String getTableDbName() {
        return "DATA_CONFIG_TO_LABEL_TYPE_MAPPING";
    }

    public String getTablePropertyName() { // as JavaBeansRule
        return "dataConfigToLabelTypeMapping";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    public DBMeta getDBMeta() {
        return DBMetaInstanceHandler.findDBMeta(getTableDbName());
    }

    // ===================================================================================
    //                                                          Classification Classifying
    //                                                          ==========================
    // ===================================================================================
    //                                                        Classification Determination
    //                                                        ============================
    // ===================================================================================
    //                                                           Classification Name/Alias
    //                                                           =========================
    // ===================================================================================
    //                                                                    Foreign Property
    //                                                                    ================
    /** DATA_CRAWLING_CONFIG as 'dataCrawlingConfig'. */
    protected DataCrawlingConfig _parentDataCrawlingConfig;

    /**
     * DATA_CRAWLING_CONFIG as 'dataCrawlingConfig'. {without lazy-load}
     * @return The entity of foreign property 'dataCrawlingConfig'. (Nullable: If the foreign key does not have 'NotNull' constraint, please check null.)
     */
    public DataCrawlingConfig getDataCrawlingConfig() {
        return _parentDataCrawlingConfig;
    }

    /**
     * DATA_CRAWLING_CONFIG as 'dataCrawlingConfig'.
     * @param dataCrawlingConfig The entity of foreign property 'dataCrawlingConfig'. (Nullable)
     */
    public void setDataCrawlingConfig(DataCrawlingConfig dataCrawlingConfig) {
        _parentDataCrawlingConfig = dataCrawlingConfig;
    }

    /** LABEL_TYPE as 'labelType'. */
    protected LabelType _parentLabelType;

    /**
     * LABEL_TYPE as 'labelType'. {without lazy-load}
     * @return The entity of foreign property 'labelType'. (Nullable: If the foreign key does not have 'NotNull' constraint, please check null.)
     */
    public LabelType getLabelType() {
        return _parentLabelType;
    }

    /**
     * LABEL_TYPE as 'labelType'.
     * @param labelType The entity of foreign property 'labelType'. (Nullable)
     */
    public void setLabelType(LabelType labelType) {
        _parentLabelType = labelType;
    }

    // ===================================================================================
    //                                                                   Referrer Property
    //                                                                   =================
    // ===================================================================================
    //                                                                       Determination
    //                                                                       =============
    public boolean hasPrimaryKeyValue() {
        if (_id == null) {
            return false;
        }
        return true;
    }

    // ===================================================================================
    //                                                                 Modified Properties
    //                                                                 ===================
    public Set<String> getModifiedPropertyNames() {
        return _modifiedProperties.getPropertyNames();
    }

    protected EntityModifiedProperties newEntityModifiedProperties() {
        return new EntityModifiedProperties();
    }

    public void clearModifiedPropertyNames() {
        _modifiedProperties.clear();
    }

    public boolean hasModification() {
        return !_modifiedProperties.isEmpty();
    }

    // ===================================================================================
    //                                                                      Basic Override
    //                                                                      ==============
    /**
     * If the primary-key of the other is same as this one, returns true.
     * @param other Other entity.
     * @return Comparing result.
     */
    public boolean equals(Object other) {
        if (other == null || !(other instanceof BsDataConfigToLabelTypeMapping)) {
            return false;
        }
        BsDataConfigToLabelTypeMapping otherEntity = (BsDataConfigToLabelTypeMapping) other;
        if (!helpComparingValue(getId(), otherEntity.getId())) {
            return false;
        }
        return true;
    }

    protected boolean helpComparingValue(Object value1, Object value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        return value1 != null && value2 != null && value1.equals(value2);
    }

    /**
     * Calculates hash-code from primary-key.
     * @return Hash-code from primary-key.
     */
    public int hashCode() {
        int result = 17;
        if (getId() != null) {
            result = (31 * result) + getId().hashCode();
        }
        return result;
    }

    /**
     * @return The view string of all columns. (NotNull)
     */
    public String toString() {
        String delimiter = ",";
        StringBuilder sb = new StringBuilder();
        sb.append(delimiter).append(getId());
        sb.append(delimiter).append(getDataConfigId());
        sb.append(delimiter).append(getLabelTypeId());
        if (sb.length() > 0) {
            sb.delete(0, delimiter.length());
        }
        sb.insert(0, "{").append("}");
        return sb.toString();
    }

    // ===================================================================================
    //                                                                            Accessor
    //                                                                            ========
    /**
     * ID: {PK : ID : NotNull : BIGINT} <br />
     * @return The value of the column 'ID'. (Nullable)
     */
    public Long getId() {
        return _id;
    }

    /**
     * ID: {PK : ID : NotNull : BIGINT} <br />
     * @param id The value of the column 'ID'. (Nullable)
     */
    public void setId(Long id) {
        _modifiedProperties.addPropertyName("id");
        this._id = id;
    }

    /**
     * DATA_CONFIG_ID: {NotNull : BIGINT : FK to DATA_CRAWLING_CONFIG} <br />
     * @return The value of the column 'DATA_CONFIG_ID'. (Nullable)
     */
    public Long getDataConfigId() {
        return _dataConfigId;
    }

    /**
     * DATA_CONFIG_ID: {NotNull : BIGINT : FK to DATA_CRAWLING_CONFIG} <br />
     * @param dataConfigId The value of the column 'DATA_CONFIG_ID'. (Nullable)
     */
    public void setDataConfigId(Long dataConfigId) {
        _modifiedProperties.addPropertyName("dataConfigId");
        this._dataConfigId = dataConfigId;
    }

    /**
     * LABEL_TYPE_ID: {NotNull : BIGINT : FK to LABEL_TYPE} <br />
     * @return The value of the column 'LABEL_TYPE_ID'. (Nullable)
     */
    public Long getLabelTypeId() {
        return _labelTypeId;
    }

    /**
     * LABEL_TYPE_ID: {NotNull : BIGINT : FK to LABEL_TYPE} <br />
     * @param labelTypeId The value of the column 'LABEL_TYPE_ID'. (Nullable)
     */
    public void setLabelTypeId(Long labelTypeId) {
        _modifiedProperties.addPropertyName("labelTypeId");
        this._labelTypeId = labelTypeId;
    }
}
