/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.allcommon.DBCurrent;
import jp.sf.fess.db.allcommon.DBFluteConfig;
import jp.sf.fess.db.bsentity.dbmeta.CrawlingSessionInfoDbm;
import jp.sf.fess.db.cbean.CrawlingSessionInfoCB;
import jp.sf.fess.db.exentity.CrawlingSession;
import jp.sf.fess.db.exentity.CrawlingSessionInfo;

import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingBean;
import org.seasar.dbflute.cbean.PagingHandler;
import org.seasar.dbflute.cbean.PagingInvoker;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.ResultBeanBuilder;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.jdbc.StatementConfig;

/**
 * The behavior of CRAWLING_SESSION_INFO that the type is TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, CRAWLING_SESSION_ID, KEY, VALUE, CREATED_TIME
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     CRAWLING_SESSION
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     crawlingSession
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsCrawlingSessionInfoBhv extends
        org.seasar.dbflute.bhv.AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "CRAWLING_SESSION_INFO";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return CrawlingSessionInfoDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public CrawlingSessionInfoDbm getMyDBMeta() {
        return CrawlingSessionInfoDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    public Entity newEntity() {
        return newMyEntity();
    }

    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    public CrawlingSessionInfo newMyEntity() {
        return new CrawlingSessionInfo();
    }

    public CrawlingSessionInfoCB newMyConditionBean() {
        return new CrawlingSessionInfoCB();
    }

    // ===================================================================================
    //                                                                       Current DBDef
    //                                                                       =============
    @Override
    protected DBDef getCurrentDBDef() {
        return DBCurrent.getInstance().currentDBDef();
    }

    // ===================================================================================
    //                                                             Default StatementConfig
    //                                                             =======================
    @Override
    protected StatementConfig getDefaultStatementConfig() {
        return DBFluteConfig.getInstance().getDefaultStatementConfig();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * @param cb The condition-bean of CrawlingSessionInfo. (NotNull)
     * @return The selected count.
     */
    public int selectCount(CrawlingSessionInfoCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean. <br />
     * Attention: It has a mapping cost from result set to entity.
     * @param cb The condition-bean of CrawlingSessionInfo. (NotNull)
     * @param entityRowHandler The handler of entity row of CrawlingSessionInfo. (NotNull)
     */
    public void selectCursor(CrawlingSessionInfoCB cb,
            EntityRowHandler<CrawlingSessionInfo> entityRowHandler) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<CrawlingSessionInfo>",
                entityRowHandler);
        delegateSelectCursor(cb, entityRowHandler);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * @param cb The condition-bean of CrawlingSessionInfo. (NotNull)
     * @return The selected entity. (Nullalble)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public CrawlingSessionInfo selectEntity(final CrawlingSessionInfoCB cb) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<CrawlingSessionInfo, CrawlingSessionInfoCB>() {
                    public List<CrawlingSessionInfo> callbackSelectList(
                            CrawlingSessionInfoCB cb) {
                        return selectList(cb);
                    }
                });
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * @param cb The condition-bean of CrawlingSessionInfo. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public CrawlingSessionInfo selectEntityWithDeletedCheck(
            final CrawlingSessionInfoCB cb) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<CrawlingSessionInfo, CrawlingSessionInfoCB>() {
                    public List<CrawlingSessionInfo> callbackSelectList(
                            CrawlingSessionInfoCB cb) {
                        return selectList(cb);
                    }
                });
    }

    /* (non-javadoc)
     * Select the entity with deleted check. {by primary-key value}
     * @param primaryKey The keys of primary.
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public CrawlingSessionInfo selectByPKValueWithDeletedCheck(Long id) {
        CrawlingSessionInfo entity = new CrawlingSessionInfo();
        entity.setId(id);
        final CrawlingSessionInfoCB cb = newMyConditionBean();
        cb.acceptPrimaryKeyMapString(getDBMeta().extractPrimaryKeyMapString(
                entity));
        return selectEntityWithDeletedCheck(cb);
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * @param cb The condition-bean of CrawlingSessionInfo. (NotNull)
     * @return The result bean of selected list. (NotNull)
     */
    public ListResultBean<CrawlingSessionInfo> selectList(
            CrawlingSessionInfoCB cb) {
        assertCBNotNull(cb);
        return new ResultBeanBuilder<CrawlingSessionInfo>(getTableDbName())
                .buildListResultBean(cb, delegateSelectList(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean.
     * @param cb The condition-bean of CrawlingSessionInfo. (NotNull)
     * @return The result bean of selected page. (NotNull)
     */
    public PagingResultBean<CrawlingSessionInfo> selectPage(
            final CrawlingSessionInfoCB cb) {
        assertCBNotNull(cb);
        final PagingInvoker<CrawlingSessionInfo> invoker = new PagingInvoker<CrawlingSessionInfo>(
                getTableDbName());
        final PagingHandler<CrawlingSessionInfo> handler = new PagingHandler<CrawlingSessionInfo>() {
            public PagingBean getPagingBean() {
                return cb;
            }

            public int count() {
                return selectCount(cb);
            }

            public List<CrawlingSessionInfo> paging() {
                return selectList(cb);
            }
        };
        return invoker.invokePaging(handler);
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * Call a function method after this method called like as follows:
     * <pre>
     * crawlingSessionInfoBhv.scalarSelect(Date.class).max(new ScalarQuery(CrawlingSessionInfoCB cb) {
     *     cb.specify().columnXxxDatetime(); // the required specification of target column
     *     cb.query().setXxxName_PrefixSearch("S"); // query as you like it
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<CrawlingSessionInfoCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        CrawlingSessionInfoCB cb = newMyConditionBean();
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CrawlingSessionInfoCB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                       Load Referrer
    //                                                                       =============
    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'CrawlingSession'.
     * @param crawlingSessionInfoList The list of crawlingSessionInfo. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<CrawlingSession> pulloutCrawlingSession(
            List<CrawlingSessionInfo> crawlingSessionInfoList) {
        return helpPulloutInternally(
                crawlingSessionInfoList,
                new InternalPulloutCallback<CrawlingSessionInfo, CrawlingSession>() {
                    public CrawlingSession callbackGetForeignEntity(
                            CrawlingSessionInfo entity) {
                        return entity.getCrawlingSession();
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * @param crawlingSessionInfo The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(CrawlingSessionInfo crawlingSessionInfo) {
        assertEntityNotNull(crawlingSessionInfo);
        delegateInsert(crawlingSessionInfo);
    }

    @Override
    protected void doCreate(Entity crawlingSessionInfo) {
        insert((CrawlingSessionInfo) crawlingSessionInfo);
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ConcurrencyControl}
     * @param crawlingSessionInfo The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final CrawlingSessionInfo crawlingSessionInfo) {
        helpUpdateInternally(crawlingSessionInfo,
                new InternalUpdateCallback<CrawlingSessionInfo>() {
                    public int callbackDelegateUpdate(CrawlingSessionInfo entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update((CrawlingSessionInfo) entity);
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        update((CrawlingSessionInfo) entity);
    }

    /**
     * Insert or update the entity modified-only. {ConcurrencyControl(when update)}
     * @param crawlingSessionInfo The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(final CrawlingSessionInfo crawlingSessionInfo) {
        helpInsertOrUpdateInternally(
                crawlingSessionInfo,
                new InternalInsertOrUpdateCallback<CrawlingSessionInfo, CrawlingSessionInfoCB>() {
                    public void callbackInsert(CrawlingSessionInfo entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(CrawlingSessionInfo entity) {
                        update(entity);
                    }

                    public CrawlingSessionInfoCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(CrawlingSessionInfoCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity crawlingSessionInfo) {
        insertOrUpdate((CrawlingSessionInfo) crawlingSessionInfo);
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdate((CrawlingSessionInfo) entity);
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ConcurrencyControl}
     * @param crawlingSessionInfo The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(CrawlingSessionInfo crawlingSessionInfo) {
        helpDeleteInternally(crawlingSessionInfo,
                new InternalDeleteCallback<CrawlingSessionInfo>() {
                    public int callbackDelegateDelete(CrawlingSessionInfo entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity crawlingSessionInfo) {
        delete((CrawlingSessionInfo) crawlingSessionInfo);
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch insert the list. This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param crawlingSessionInfoList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<CrawlingSessionInfo> crawlingSessionInfoList) {
        assertObjectNotNull("crawlingSessionInfoList", crawlingSessionInfoList);
        return delegateInsertList(crawlingSessionInfoList);
    }

    /**
     * Batch update the list. All columns are update target. {NOT modified only} <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param crawlingSessionInfoList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(List<CrawlingSessionInfo> crawlingSessionInfoList) {
        assertObjectNotNull("crawlingSessionInfoList", crawlingSessionInfoList);
        return delegateUpdateList(crawlingSessionInfoList);
    }

    /**
     * Batch delete the list. <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param crawlingSessionInfoList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(List<CrawlingSessionInfo> crawlingSessionInfoList) {
        assertObjectNotNull("crawlingSessionInfoList", crawlingSessionInfoList);
        return delegateDeleteList(crawlingSessionInfoList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query update the several entities. {NoConcurrencyControl}
     * @param crawlingSessionInfo Entity. (NotNull) {PrimaryKeyNotRequired}
     * @param cb Condition-bean. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(CrawlingSessionInfo crawlingSessionInfo,
            CrawlingSessionInfoCB cb) {
        assertObjectNotNull("crawlingSessionInfo", crawlingSessionInfo);
        assertCBNotNull(cb);
        setupCommonColumnOfUpdateIfNeeds(crawlingSessionInfo);
        filterEntityOfUpdate(crawlingSessionInfo);
        assertEntityOfUpdate(crawlingSessionInfo);
        return invoke(createQueryUpdateEntityCBCommand(crawlingSessionInfo, cb));
    }

    /**
     * Query delete the several entities. {NoConcurrencyControl}
     * @param cb Condition-bean. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(CrawlingSessionInfoCB cb) {
        assertCBNotNull(cb);
        return invoke(createQueryDeleteCBCommand(cb));
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(CrawlingSessionInfoCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected void delegateSelectCursor(CrawlingSessionInfoCB cb,
            EntityRowHandler<CrawlingSessionInfo> entityRowHandler) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler,
                CrawlingSessionInfo.class));
    }

    protected int doCallReadCount(ConditionBean cb) {
        return delegateSelectCount((CrawlingSessionInfoCB) cb);
    }

    protected List<CrawlingSessionInfo> delegateSelectList(
            CrawlingSessionInfoCB cb) {
        return invoke(createSelectListCBCommand(cb, CrawlingSessionInfo.class));
    }

    @SuppressWarnings("unchecked")
    protected List<Entity> doCallReadList(ConditionBean cb) {
        return (List) delegateSelectList((CrawlingSessionInfoCB) cb);
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(CrawlingSessionInfo e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int doCallCreate(Entity entity) {
        return delegateInsert(downcast(entity));
    }

    protected int delegateUpdate(CrawlingSessionInfo e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateEntityCommand(e));
    }

    protected int doCallModify(Entity entity) {
        return delegateUpdate(downcast(entity));
    }

    protected int delegateDelete(CrawlingSessionInfo e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteEntityCommand(e));
    }

    protected int doCallRemove(Entity entity) {
        return delegateDelete(downcast(entity));
    }

    protected int[] delegateInsertList(List<CrawlingSessionInfo> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<CrawlingSessionInfo> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateDeleteList(List<CrawlingSessionInfo> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return false;
    }

    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                              Helper
    //                                                                              ======
    protected CrawlingSessionInfo downcast(Entity entity) {
        return helpDowncastInternally(entity, CrawlingSessionInfo.class);
    }
}
