package jp.sf.fess.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.seasar.extension.unit.S2TestCase;

public class CrawlingSessionHelperTest extends S2TestCase {

    public CrawlingSessionHelper crawlingSessionHelper;

    @Override
    protected String getRootDicon() throws Throwable {
        return "app.dicon";
    }

    public void test_generateId() {
        Map<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("url", "http://hoge.com/");
        List<String> typeList = new ArrayList<String>();
        typeList.add("pc");
        typeList.add("docomo");
        typeList.add("softbank");
        typeList.add("au");
        dataMap.put("type", typeList);

        assertEquals("http://hoge.com/;type=pc,docomo,softbank,au",
                crawlingSessionHelper.generateId(dataMap));

    }
}
