/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.WebConfigToLabelTypeMappingDbm;
import jp.sf.fess.db.cbean.WebConfigToLabelTypeMappingCB;
import jp.sf.fess.db.exentity.LabelType;
import jp.sf.fess.db.exentity.WebConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.WebCrawlingConfig;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The behavior of WEB_CONFIG_TO_LABEL_TYPE_MAPPING as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, WEB_CONFIG_ID, LABEL_TYPE_ID
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     LABEL_TYPE, WEB_CRAWLING_CONFIG
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     labelType, webCrawlingConfig
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsWebConfigToLabelTypeMappingBhv extends
        AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "WEB_CONFIG_TO_LABEL_TYPE_MAPPING";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return WebConfigToLabelTypeMappingDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public WebConfigToLabelTypeMappingDbm getMyDBMeta() {
        return WebConfigToLabelTypeMappingDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public WebConfigToLabelTypeMapping newMyEntity() {
        return new WebConfigToLabelTypeMapping();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public WebConfigToLabelTypeMappingCB newMyConditionBean() {
        return new WebConfigToLabelTypeMappingCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * <pre>
     * WebConfigToLabelTypeMappingCB cb = new WebConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * int count = webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of WebConfigToLabelTypeMapping. (NotNull)
     * @return The selected count.
     */
    public int selectCount(WebConfigToLabelTypeMappingCB cb) {
        return doSelectCount(cb);
    }

    protected int doSelectCount(WebConfigToLabelTypeMappingCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * WebConfigToLabelTypeMappingCB cb = new WebConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;WebConfigToLabelTypeMapping&gt;() {
     *     public void handle(WebConfigToLabelTypeMapping entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of WebConfigToLabelTypeMapping. (NotNull)
     * @param entityRowHandler The handler of entity row of WebConfigToLabelTypeMapping. (NotNull)
     */
    public void selectCursor(WebConfigToLabelTypeMappingCB cb,
            EntityRowHandler<WebConfigToLabelTypeMapping> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, WebConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToLabelTypeMapping> void doSelectCursor(
            WebConfigToLabelTypeMappingCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<WebConfigToLabelTypeMapping>",
                entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * WebConfigToLabelTypeMappingCB cb = new WebConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * WebConfigToLabelTypeMapping webConfigToLabelTypeMapping = webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (webConfigToLabelTypeMapping != null) {
     *     ... = webConfigToLabelTypeMapping.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of WebConfigToLabelTypeMapping. (NotNull)
     * @return The selected entity. (Nullable: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebConfigToLabelTypeMapping selectEntity(
            WebConfigToLabelTypeMappingCB cb) {
        return doSelectEntity(cb, WebConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToLabelTypeMapping> ENTITY doSelectEntity(
            final WebConfigToLabelTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<ENTITY, WebConfigToLabelTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            WebConfigToLabelTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * WebConfigToLabelTypeMappingCB cb = new WebConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * WebConfigToLabelTypeMapping webConfigToLabelTypeMapping = webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = webConfigToLabelTypeMapping.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of WebConfigToLabelTypeMapping. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebConfigToLabelTypeMapping selectEntityWithDeletedCheck(
            WebConfigToLabelTypeMappingCB cb) {
        return doSelectEntityWithDeletedCheck(cb,
                WebConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToLabelTypeMapping> ENTITY doSelectEntityWithDeletedCheck(
            final WebConfigToLabelTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, WebConfigToLabelTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            WebConfigToLabelTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (Nullable: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebConfigToLabelTypeMapping selectByPKValue(Long id) {
        return doSelectByPKValue(id, WebConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToLabelTypeMapping> ENTITY doSelectByPKValue(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebConfigToLabelTypeMapping selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id,
                WebConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToLabelTypeMapping> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private WebConfigToLabelTypeMappingCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        WebConfigToLabelTypeMappingCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * WebConfigToLabelTypeMappingCB cb = new WebConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;WebConfigToLabelTypeMapping&gt; webConfigToLabelTypeMappingList = webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (WebConfigToLabelTypeMapping webConfigToLabelTypeMapping : webConfigToLabelTypeMappingList) {
     *     ... = webConfigToLabelTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of WebConfigToLabelTypeMapping. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<WebConfigToLabelTypeMapping> selectList(
            WebConfigToLabelTypeMappingCB cb) {
        return doSelectList(cb, WebConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToLabelTypeMapping> ListResultBean<ENTITY> doSelectList(
            WebConfigToLabelTypeMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(
                cb,
                entityType,
                new InternalSelectListCallback<ENTITY, WebConfigToLabelTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            WebConfigToLabelTypeMappingCB cb,
                            Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * WebConfigToLabelTypeMappingCB cb = new WebConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;WebConfigToLabelTypeMapping&gt; page = webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (WebConfigToLabelTypeMapping webConfigToLabelTypeMapping : page) {
     *     ... = webConfigToLabelTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of WebConfigToLabelTypeMapping. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<WebConfigToLabelTypeMapping> selectPage(
            WebConfigToLabelTypeMappingCB cb) {
        return doSelectPage(cb, WebConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToLabelTypeMapping> PagingResultBean<ENTITY> doSelectPage(
            WebConfigToLabelTypeMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(
                cb,
                entityType,
                new InternalSelectPageCallback<ENTITY, WebConfigToLabelTypeMappingCB>() {
                    public int callbackSelectCount(
                            WebConfigToLabelTypeMappingCB cb) {
                        return doSelectCount(cb);
                    }

                    public List<ENTITY> callbackSelectList(
                            WebConfigToLabelTypeMappingCB cb,
                            Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(WebConfigToLabelTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<WebConfigToLabelTypeMappingCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends WebConfigToLabelTypeMappingCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'LabelType'.
     * @param webConfigToLabelTypeMappingList The list of webConfigToLabelTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<LabelType> pulloutLabelType(
            List<WebConfigToLabelTypeMapping> webConfigToLabelTypeMappingList) {
        return helpPulloutInternally(
                webConfigToLabelTypeMappingList,
                new InternalPulloutCallback<WebConfigToLabelTypeMapping, LabelType>() {
                    public LabelType getFr(WebConfigToLabelTypeMapping e) {
                        return e.getLabelType();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(LabelType e,
                            List<WebConfigToLabelTypeMapping> ls) {
                        e.setWebConfigToLabelTypeMappingList(ls);
                    }
                });
    }

    /**
     * Pull out the list of foreign table 'WebCrawlingConfig'.
     * @param webConfigToLabelTypeMappingList The list of webConfigToLabelTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<WebCrawlingConfig> pulloutWebCrawlingConfig(
            List<WebConfigToLabelTypeMapping> webConfigToLabelTypeMappingList) {
        return helpPulloutInternally(
                webConfigToLabelTypeMappingList,
                new InternalPulloutCallback<WebConfigToLabelTypeMapping, WebCrawlingConfig>() {
                    public WebCrawlingConfig getFr(WebConfigToLabelTypeMapping e) {
                        return e.getWebCrawlingConfig();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(WebCrawlingConfig e,
                            List<WebConfigToLabelTypeMapping> ls) {
                        e.setWebConfigToLabelTypeMappingList(ls);
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * WebConfigToLabelTypeMapping webConfigToLabelTypeMapping = new WebConfigToLabelTypeMapping();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * webConfigToLabelTypeMapping.setFoo...(value);
     * webConfigToLabelTypeMapping.setBar...(value);
     * webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">insert</span>(webConfigToLabelTypeMapping);
     * ... = webConfigToLabelTypeMapping.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param webConfigToLabelTypeMapping The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(WebConfigToLabelTypeMapping webConfigToLabelTypeMapping) {
        assertEntityNotNull(webConfigToLabelTypeMapping);
        delegateInsert(webConfigToLabelTypeMapping);
    }

    @Override
    protected void doCreate(Entity entity) {
        insert(downcast(entity));
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * WebConfigToLabelTypeMapping webConfigToLabelTypeMapping = new WebConfigToLabelTypeMapping();
     * webConfigToLabelTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * webConfigToLabelTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * webConfigToLabelTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">update</span>(webConfigToLabelTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param webConfigToLabelTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(
            final WebConfigToLabelTypeMapping webConfigToLabelTypeMapping) {
        helpUpdateInternally(webConfigToLabelTypeMapping,
                new InternalUpdateCallback<WebConfigToLabelTypeMapping>() {
                    public int callbackDelegateUpdate(
                            WebConfigToLabelTypeMapping entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update(downcast(entity));
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        update(downcast(entity));
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param webConfigToLabelTypeMapping The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(
            final WebConfigToLabelTypeMapping webConfigToLabelTypeMapping) {
        helpInsertOrUpdateInternally(
                webConfigToLabelTypeMapping,
                new InternalInsertOrUpdateCallback<WebConfigToLabelTypeMapping, WebConfigToLabelTypeMappingCB>() {
                    public void callbackInsert(
                            WebConfigToLabelTypeMapping entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(
                            WebConfigToLabelTypeMapping entity) {
                        update(entity);
                    }

                    public WebConfigToLabelTypeMappingCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(
                            WebConfigToLabelTypeMappingCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * WebConfigToLabelTypeMapping webConfigToLabelTypeMapping = new WebConfigToLabelTypeMapping();
     * webConfigToLabelTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * webConfigToLabelTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">delete</span>(webConfigToLabelTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param webConfigToLabelTypeMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(WebConfigToLabelTypeMapping webConfigToLabelTypeMapping) {
        helpDeleteInternally(webConfigToLabelTypeMapping,
                new InternalDeleteCallback<WebConfigToLabelTypeMapping>() {
                    public int callbackDelegateDelete(
                            WebConfigToLabelTypeMapping entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity entity) {
        delete(downcast(entity));
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param webConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(
            List<WebConfigToLabelTypeMapping> webConfigToLabelTypeMappingList) {
        assertObjectNotNull("webConfigToLabelTypeMappingList",
                webConfigToLabelTypeMappingList);
        return delegateInsertList(webConfigToLabelTypeMappingList);
    }

    /**
     * Batch-update the list. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param webConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(
            List<WebConfigToLabelTypeMapping> webConfigToLabelTypeMappingList) {
        assertObjectNotNull("webConfigToLabelTypeMappingList",
                webConfigToLabelTypeMappingList);
        return delegateUpdateList(webConfigToLabelTypeMappingList);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param webConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(
            List<WebConfigToLabelTypeMapping> webConfigToLabelTypeMappingList) {
        assertObjectNotNull("webConfigToLabelTypeMappingList",
                webConfigToLabelTypeMappingList);
        return delegateDeleteList(webConfigToLabelTypeMappingList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * WebConfigToLabelTypeMapping webConfigToLabelTypeMapping = new WebConfigToLabelTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//webConfigToLabelTypeMapping.setPK...(value);</span>
     * webConfigToLabelTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webConfigToLabelTypeMapping.setVersionNo(value);</span>
     * WebConfigToLabelTypeMappingCB cb = new WebConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">queryUpdate</span>(webConfigToLabelTypeMapping, cb);
     * </pre>
     * @param webConfigToLabelTypeMapping The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of WebConfigToLabelTypeMapping. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(
            WebConfigToLabelTypeMapping webConfigToLabelTypeMapping,
            WebConfigToLabelTypeMappingCB cb) {
        return delegateQueryUpdate(webConfigToLabelTypeMapping, cb);
    }

    /**
     * Query-delete the several entities. {NonExclusiveControl}
     * <pre>
     * WebConfigToLabelTypeMappingCB cb = new WebConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">queryDelete</span>(webConfigToLabelTypeMapping, cb);
     * </pre>
     * @param cb The condition-bean of WebConfigToLabelTypeMapping. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(WebConfigToLabelTypeMappingCB cb) {
        return delegateQueryDelete(cb);
    }

    /**
     * Varying-update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * WebConfigToLabelTypeMapping webConfigToLabelTypeMapping = new WebConfigToLabelTypeMapping();
     * webConfigToLabelTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * webConfigToLabelTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * webConfigToLabelTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     UpdateOption&lt;WebConfigToLabelTypeMappingCB&gt; option = new UpdateOption&lt;WebConfigToLabelTypeMappingCB&gt;();
     *     option.self(new SpecifyQuery&lt;WebConfigToLabelTypeMappingCB&gt;() {
     *         public void specify(WebConfigToLabelTypeMappingCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">varyingUpdate</span>(webConfigToLabelTypeMapping, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param webConfigToLabelTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(
            WebConfigToLabelTypeMapping webConfigToLabelTypeMapping,
            final UpdateOption<WebConfigToLabelTypeMappingCB> option) {
        processVaryingUpdate(option);
        helpUpdateInternally(webConfigToLabelTypeMapping,
                new InternalUpdateCallback<WebConfigToLabelTypeMapping>() {
                    public int callbackDelegateUpdate(
                            WebConfigToLabelTypeMapping entity) {
                        return delegateVaryingUpdate(entity, option);
                    }
                });
    }

    /**
     * Varying-query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * WebConfigToLabelTypeMapping webConfigToLabelTypeMapping = new WebConfigToLabelTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//webConfigToLabelTypeMapping.setPK...(value);</span>
     * webConfigToLabelTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webConfigToLabelTypeMapping.setVersionNo(value);</span>
     * WebConfigToLabelTypeMappingCB cb = new WebConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;WebConfigToLabelTypeMappingCB&gt; option = new UpdateOption&lt;WebConfigToLabelTypeMappingCB&gt;();
     * option.self(new SpecifyQuery&lt;WebConfigToLabelTypeMappingCB&gt;() {
     *     public void specify(WebConfigToLabelTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(webConfigToLabelTypeMapping, cb, option);
     * </pre>
     * @param webConfigToLabelTypeMapping The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of WebConfigToLabelTypeMapping. (NotNull)
     * @param option The option of update for varying values. (NotNull)
     * @return The updated count.
     */
    public int varyingQueryUpdate(
            WebConfigToLabelTypeMapping webConfigToLabelTypeMapping,
            WebConfigToLabelTypeMappingCB cb,
            final UpdateOption<WebConfigToLabelTypeMappingCB> option) {
        processVaryingUpdate(option);
        return delegateVaryingQueryUpdate(webConfigToLabelTypeMapping, cb,
                option);
    }

    protected void processVaryingUpdate(
            UpdateOption<WebConfigToLabelTypeMappingCB> option) {
        assertUpdateOptionNotNull(option);
        WebConfigToLabelTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        option.resolveSpecification(cb);
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(WebConfigToLabelTypeMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected <ENTITY extends WebConfigToLabelTypeMapping> void delegateSelectCursor(
            WebConfigToLabelTypeMappingCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler, entityType));
    }

    protected <ENTITY extends WebConfigToLabelTypeMapping> List<ENTITY> delegateSelectList(
            WebConfigToLabelTypeMappingCB cb, Class<ENTITY> entityType) {
        return invoke(createSelectListCBCommand(cb, entityType));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(WebConfigToLabelTypeMapping e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int delegateUpdate(WebConfigToLabelTypeMapping e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(WebConfigToLabelTypeMapping e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<WebConfigToLabelTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<WebConfigToLabelTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateDeleteList(List<WebConfigToLabelTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int delegateQueryUpdate(WebConfigToLabelTypeMapping e,
            WebConfigToLabelTypeMappingCB cb) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createQueryUpdateEntityCBCommand(e, cb));
    }

    protected int delegateQueryDelete(WebConfigToLabelTypeMappingCB cb) {
        if (!processBeforeQueryDelete(cb)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb));
    }

    protected int delegateVaryingUpdate(WebConfigToLabelTypeMapping e,
            UpdateOption<WebConfigToLabelTypeMappingCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateVaryingQueryUpdate(WebConfigToLabelTypeMapping e,
            WebConfigToLabelTypeMappingCB cb,
            UpdateOption<WebConfigToLabelTypeMappingCB> op) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createVaryingQueryUpdateEntityCBCommand(e, cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected WebConfigToLabelTypeMapping downcast(Entity entity) {
        return helpEntityDowncastInternally(entity,
                WebConfigToLabelTypeMapping.class);
    }

    protected WebConfigToLabelTypeMappingCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb,
                WebConfigToLabelTypeMappingCB.class);
    }
}
