//
// Copyright 2009-2010 Fess Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

#import "CommonTextViewController.h"


@interface CommonTextStyleSheet : TTDefaultStyleSheet
@end

@implementation CommonTextStyleSheet


@end


@implementation CommonTextViewController

///////////////////////////////////////////////////////////////////////////////////////////////////
// NSObject

- (id)initWithTitle:(NSString *)pageTitle fileName:(NSString *)fileName {
	if (self = [super init]) {
		self.title = NSLocalizedString(pageTitle, nil);
		[TTStyleSheet setGlobalStyleSheet:[[[CommonTextStyleSheet alloc] init] autorelease]];
		textFileName = [fileName copy];
	}
	return self;
}

- (void)dealloc {
	[textFileName release];
	[TTStyleSheet setGlobalStyleSheet:nil];
	[super dealloc];
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// UIViewController

- (void)loadView {
	[super loadView];

	UIScrollView* scrollView = [[[UIScrollView alloc] initWithFrame:TTNavigationFrame()] autorelease];
	scrollView.autoresizesSubviews = YES;
	scrollView.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
	scrollView.backgroundColor = [UIColor whiteColor];
	self.view = scrollView;
	
	NSBundle        *mainBundle = [NSBundle mainBundle];
    NSString        *fileName, *bodyText;
    NSData          *data;
	    
    fileName = [mainBundle pathForResource:textFileName ofType:@"txt"];
    data = [NSData dataWithContentsOfFile:fileName];
    bodyText = [[[NSString alloc] initWithData:data
                                     encoding:NSUTF8StringEncoding] autorelease];

	TTStyledTextLabel* label1 = [[[TTStyledTextLabel alloc] initWithFrame:self.view.bounds] autorelease];
	label1.font = [UIFont systemFontOfSize:12];
	label1.text = [TTStyledText textFromXHTML:bodyText lineBreaks:YES URLs:YES];
	label1.contentInset = UIEdgeInsetsMake(10, 10, 10, 10);
	[label1 sizeToFit];
	[self.view addSubview:label1];
	
	scrollView.contentSize = CGSizeMake(scrollView.width, label1.height);

}

@end

