/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.action;

import java.io.IOException;
import java.io.Serializable;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.sf.fess.Constants;
import jp.sf.fess.FessSystemException;
import jp.sf.fess.crypto.FessCipher;
import jp.sf.fess.entity.LoginInfo;
import jp.sf.fess.form.LoginForm;

import org.seasar.framework.util.StringUtil;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;
import org.seasar.struts.util.RequestUtil;
import org.seasar.struts.util.ResponseUtil;

public class LoginAction implements Serializable {

    private static final long serialVersionUID = 1L;

    @ActionForm
    @Resource
    protected LoginForm loginForm;

    @Execute(validator = false)
    public String index() {
        HttpServletRequest request = RequestUtil.getRequest();
        HttpSession session = request.getSession();
        // check login session
        if (session.getAttribute(Constants.LOGIN_INFO) != null) {
            return "login";
        }

        String returnPath;
        if (StringUtil.isNotBlank(loginForm.returnPath)) {
            FessCipher fessCipher = FessCipher.class.cast(RequestUtil
                    .getRequest().getAttribute(Constants.AUTH_CIPHER));
            if (fessCipher == null) {
                throw new FessSystemException(
                        "A cipher for authentication is null. Please check a filter setting.");
            }
            String value = fessCipher.decryptoText(loginForm.returnPath);
            int idx = value.indexOf("|");
            if (idx >= 0) {
                returnPath = value.substring(idx + 1);
            } else {
                // invalid returnPath
                returnPath = "/";
            }
        } else {
            returnPath = "/";
        }

        RequestUtil.getRequest().getSession().setAttribute(
                Constants.RETURN_PATH, returnPath);

        return "login?redirect=true";
    }

    @Execute(validator = false)
    public String login() {
        HttpServletRequest request = RequestUtil.getRequest();
        HttpSession session = request.getSession();
        String returnPath = (String) session
                .getAttribute(Constants.RETURN_PATH);
        if (returnPath != null) {
            session.removeAttribute(Constants.RETURN_PATH);
        } else {
            // TODO admin page
            returnPath = RequestUtil.getRequest().getContextPath();
        }
        HttpServletResponse response = ResponseUtil.getResponse();
        try {
            response.sendRedirect(response.encodeURL(returnPath));
        } catch (IOException e) {
            throw new FessSystemException(
                    "Failed to redirect to " + returnPath, e);
        }

        // create user info
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setUsername(request.getRemoteUser());
        session.setAttribute(Constants.LOGIN_INFO, loginInfo);

        return null;
    }

    @Execute(validator = false)
    public String logout() {
        HttpServletRequest request = RequestUtil.getRequest();
        HttpSession session = request.getSession();
        session.invalidate();

        return "login?redirect=true";
    }
}