/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.interceptor;

import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.struts.interceptor.ActionMessagesThrowsInterceptor;

public class FessActionMessagesThrowsInterceptor extends
        ActionMessagesThrowsInterceptor {

    private static final String SYSTEM_ERROR_JSP = "/error/system.jsp";

    private static final Log log = LogFactory
            .getLog(FessActionMessagesThrowsInterceptor.class);

    private static final long serialVersionUID = 1L;

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            return super.invoke(invocation);
        } catch (Throwable t) {
            log.error("System error occured.", t);
            return SYSTEM_ERROR_JSP;
        }
    }

}
