/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.PathMappingDbm;
import jp.sf.fess.db.cbean.PathMappingCB;
import jp.sf.fess.db.exbhv.PathMappingBhv;
import jp.sf.fess.db.exentity.PathMapping;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.DeleteOption;
import org.seasar.dbflute.bhv.InsertOption;
import org.seasar.dbflute.bhv.QueryInsertSetupper;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.SpecifyQuery;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.outsidesql.executor.OutsideSqlBasicExecutor;

/**
 * The behavior of PATH_MAPPING as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, REGEX, REPLACEMENT, PROCESS_TYPE, SORT_ORDER, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsPathMappingBhv extends AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:beginQueryPath*/
    /*df:endQueryPath*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "PATH_MAPPING";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return PathMappingDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public PathMappingDbm getMyDBMeta() {
        return PathMappingDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public PathMapping newMyEntity() {
        return new PathMapping();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public PathMappingCB newMyConditionBean() {
        return new PathMappingCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count of uniquely-selected records by the condition-bean. {IgnorePagingCondition, IgnoreSpecifyColumn}<br />
     * SpecifyColumn is ignored but you can use it only to remove text type column for union's distinct.
     * <pre>
     * PathMappingCB cb = new PathMappingCB();
     * cb.query().setFoo...(value);
     * int count = pathMappingBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of PathMapping. (NotNull)
     * @return The selected count.
     */
    public int selectCount(PathMappingCB cb) {
        return doSelectCountUniquely(cb);
    }

    protected int doSelectCountUniquely(PathMappingCB cb) { // called by selectCount(cb) 
        assertCBNotNull(cb);
        return delegateSelectCountUniquely(cb);
    }

    protected int doSelectCountPlainly(PathMappingCB cb) { // called by selectPage(cb)
        assertCBNotNull(cb);
        return delegateSelectCountPlainly(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * PathMappingCB cb = new PathMappingCB();
     * cb.query().setFoo...(value);
     * pathMappingBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;PathMapping&gt;() {
     *     public void handle(PathMapping entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of PathMapping. (NotNull)
     * @param entityRowHandler The handler of entity row of PathMapping. (NotNull)
     */
    public void selectCursor(PathMappingCB cb,
            EntityRowHandler<PathMapping> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, PathMapping.class);
    }

    protected <ENTITY extends PathMapping> void doSelectCursor(
            PathMappingCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<PathMapping>", entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * PathMappingCB cb = new PathMappingCB();
     * cb.query().setFoo...(value);
     * PathMapping pathMapping = pathMappingBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (pathMapping != null) {
     *     ... = pathMapping.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of PathMapping. (NotNull)
     * @return The selected entity. (NullAllowed: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public PathMapping selectEntity(PathMappingCB cb) {
        return doSelectEntity(cb, PathMapping.class);
    }

    protected <ENTITY extends PathMapping> ENTITY doSelectEntity(
            final PathMappingCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(cb,
                new InternalSelectEntityCallback<ENTITY, PathMappingCB>() {
                    public List<ENTITY> callbackSelectList(PathMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * PathMappingCB cb = new PathMappingCB();
     * cb.query().setFoo...(value);
     * PathMapping pathMapping = pathMappingBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = pathMapping.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of PathMapping. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public PathMapping selectEntityWithDeletedCheck(PathMappingCB cb) {
        return doSelectEntityWithDeletedCheck(cb, PathMapping.class);
    }

    protected <ENTITY extends PathMapping> ENTITY doSelectEntityWithDeletedCheck(
            final PathMappingCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, PathMappingCB>() {
                    public List<ENTITY> callbackSelectList(PathMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NullAllowed: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public PathMapping selectByPKValue(Long id) {
        return doSelectByPKValue(id, PathMapping.class);
    }

    protected <ENTITY extends PathMapping> ENTITY doSelectByPKValue(Long id,
            Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public PathMapping selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id, PathMapping.class);
    }

    protected <ENTITY extends PathMapping> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private PathMappingCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        PathMappingCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * PathMappingCB cb = new PathMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;PathMapping&gt; pathMappingList = pathMappingBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (PathMapping pathMapping : pathMappingList) {
     *     ... = pathMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of PathMapping. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<PathMapping> selectList(PathMappingCB cb) {
        return doSelectList(cb, PathMapping.class);
    }

    protected <ENTITY extends PathMapping> ListResultBean<ENTITY> doSelectList(
            PathMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(cb, entityType,
                new InternalSelectListCallback<ENTITY, PathMappingCB>() {
                    public List<ENTITY> callbackSelectList(PathMappingCB cb,
                            Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * PathMappingCB cb = new PathMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;PathMapping&gt; page = pathMappingBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (PathMapping pathMapping : page) {
     *     ... = pathMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of PathMapping. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<PathMapping> selectPage(PathMappingCB cb) {
        return doSelectPage(cb, PathMapping.class);
    }

    protected <ENTITY extends PathMapping> PagingResultBean<ENTITY> doSelectPage(
            PathMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(cb, entityType,
                new InternalSelectPageCallback<ENTITY, PathMappingCB>() {
                    public int callbackSelectCount(PathMappingCB cb) {
                        return doSelectCountPlainly(cb);
                    }

                    public List<ENTITY> callbackSelectList(PathMappingCB cb,
                            Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function from uniquely-selected records. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * pathMappingBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(PathMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (NullAllowed)
     */
    public <RESULT> SLFunction<PathMappingCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends PathMappingCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * PathMapping pathMapping = new PathMapping();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * pathMapping.setFoo...(value);
     * pathMapping.setBar...(value);
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//pathMapping.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//pathMapping.set...;</span>
     * pathMappingBhv.<span style="color: #FD4747">insert</span>(pathMapping);
     * ... = pathMapping.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param pathMapping The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(PathMapping pathMapping) {
        doInsert(pathMapping, null);
    }

    protected void doInsert(PathMapping pathMapping,
            InsertOption<PathMappingCB> option) {
        assertObjectNotNull("pathMapping", pathMapping);
        prepareInsertOption(option);
        delegateInsert(pathMapping, option);
    }

    protected void prepareInsertOption(InsertOption<PathMappingCB> option) {
        if (option == null) {
            return;
        }
        assertInsertOptionStatus(option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreate(Entity entity,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            insert(downcast(entity));
        } else {
            varyingInsert(downcast(entity), (InsertOption) option);
        }
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * PathMapping pathMapping = new PathMapping();
     * pathMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * pathMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//pathMapping.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//pathMapping.set...;</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * pathMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     pathMappingBhv.<span style="color: #FD4747">update</span>(pathMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param pathMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final PathMapping pathMapping) {
        doUpdate(pathMapping, null);
    }

    protected void doUpdate(PathMapping pathMapping,
            final UpdateOption<PathMappingCB> option) {
        assertObjectNotNull("pathMapping", pathMapping);
        prepareUpdateOption(option);
        helpUpdateInternally(pathMapping,
                new InternalUpdateCallback<PathMapping>() {
                    public int callbackDelegateUpdate(PathMapping entity) {
                        return delegateUpdate(entity, option);
                    }
                });
    }

    protected void prepareUpdateOption(UpdateOption<PathMappingCB> option) {
        if (option == null) {
            return;
        }
        assertUpdateOptionStatus(option);
        if (option.hasSelfSpecification()) {
            option.resolveSelfSpecification(createCBForVaryingUpdate());
        }
        if (option.hasSpecifiedUpdateColumn()) {
            option.resolveUpdateColumnSpecification(createCBForSpecifiedUpdate());
        }
    }

    protected PathMappingCB createCBForVaryingUpdate() {
        PathMappingCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        return cb;
    }

    protected PathMappingCB createCBForSpecifiedUpdate() {
        PathMappingCB cb = newMyConditionBean();
        cb.xsetupForSpecifiedUpdate();
        return cb;
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doModify(Entity entity,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            update(downcast(entity));
        } else {
            varyingUpdate(downcast(entity), (UpdateOption) option);
        }
    }

    /**
     * Update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * PathMapping pathMapping = new PathMapping();
     * pathMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * pathMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//pathMapping.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//pathMapping.set...;</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//pathMapping.setVersionNo(value);</span>
     * pathMappingBhv.<span style="color: #FD4747">updateNonstrict</span>(pathMapping);
     * </pre>
     * @param pathMapping The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void updateNonstrict(final PathMapping pathMapping) {
        doUpdateNonstrict(pathMapping, null);
    }

    protected void doUpdateNonstrict(PathMapping pathMapping,
            final UpdateOption<PathMappingCB> option) {
        assertObjectNotNull("pathMapping", pathMapping);
        prepareUpdateOption(option);
        helpUpdateNonstrictInternally(pathMapping,
                new InternalUpdateNonstrictCallback<PathMapping>() {
                    public int callbackDelegateUpdateNonstrict(
                            PathMapping entity) {
                        return delegateUpdateNonstrict(entity, option);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doModifyNonstrict(Entity entity,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            updateNonstrict(downcast(entity));
        } else {
            varyingUpdateNonstrict(downcast(entity), (UpdateOption) option);
        }
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param pathMapping The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(PathMapping pathMapping) {
        doInesrtOrUpdate(pathMapping, null, null);
    }

    protected void doInesrtOrUpdate(PathMapping pathMapping,
            final InsertOption<PathMappingCB> insertOption,
            final UpdateOption<PathMappingCB> updateOption) {
        helpInsertOrUpdateInternally(
                pathMapping,
                new InternalInsertOrUpdateCallback<PathMapping, PathMappingCB>() {
                    public void callbackInsert(PathMapping entity) {
                        doInsert(entity, insertOption);
                    }

                    public void callbackUpdate(PathMapping entity) {
                        doUpdate(entity, updateOption);
                    }

                    public PathMappingCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(PathMappingCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreateOrModify(Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        if (insertOption == null && updateOption == null) {
            insertOrUpdate(downcast(entity));
        } else {
            insertOption = insertOption == null ? new InsertOption()
                    : insertOption;
            updateOption = updateOption == null ? new UpdateOption()
                    : updateOption;
            varyingInsertOrUpdate(downcast(entity),
                    (InsertOption) insertOption, (UpdateOption) updateOption);
        }
    }

    /**
     * Insert or update the entity non-strictly modified-only. {NonExclusiveControl(when update)}
     * @param pathMapping The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdateNonstrict(PathMapping pathMapping) {
        doInesrtOrUpdateNonstrict(pathMapping, null, null);
    }

    protected void doInesrtOrUpdateNonstrict(PathMapping pathMapping,
            final InsertOption<PathMappingCB> insertOption,
            final UpdateOption<PathMappingCB> updateOption) {
        helpInsertOrUpdateInternally(pathMapping,
                new InternalInsertOrUpdateNonstrictCallback<PathMapping>() {
                    public void callbackInsert(PathMapping entity) {
                        doInsert(entity, insertOption);
                    }

                    public void callbackUpdateNonstrict(PathMapping entity) {
                        doUpdateNonstrict(entity, updateOption);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreateOrModifyNonstrict(Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        if (insertOption == null && updateOption == null) {
            insertOrUpdateNonstrict(downcast(entity));
        } else {
            insertOption = insertOption == null ? new InsertOption()
                    : insertOption;
            updateOption = updateOption == null ? new UpdateOption()
                    : updateOption;
            varyingInsertOrUpdateNonstrict(downcast(entity),
                    (InsertOption) insertOption, (UpdateOption) updateOption);
        }
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * PathMapping pathMapping = new PathMapping();
     * pathMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * pathMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     pathMappingBhv.<span style="color: #FD4747">delete</span>(pathMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param pathMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(PathMapping pathMapping) {
        doDelete(pathMapping, null);
    }

    protected void doDelete(PathMapping pathMapping,
            final DeleteOption<PathMappingCB> option) {
        assertObjectNotNull("pathMapping", pathMapping);
        prepareDeleteOption(option);
        helpDeleteInternally(pathMapping,
                new InternalDeleteCallback<PathMapping>() {
                    public int callbackDelegateDelete(PathMapping entity) {
                        return delegateDelete(entity, option);
                    }
                });
    }

    protected void prepareDeleteOption(DeleteOption<PathMappingCB> option) {
        if (option == null) {
            return;
        }
        assertDeleteOptionStatus(option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doRemove(Entity entity,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            delete(downcast(entity));
        } else {
            varyingDelete(downcast(entity), (DeleteOption) option);
        }
    }

    /**
     * Delete the entity non-strictly. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * PathMapping pathMapping = new PathMapping();
     * pathMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//pathMapping.setVersionNo(value);</span>
     * pathMappingBhv.<span style="color: #FD4747">deleteNonstrict</span>(pathMapping);
     * </pre>
     * @param pathMapping The entity of delete target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrict(PathMapping pathMapping) {
        doDeleteNonstrict(pathMapping, null);
    }

    protected void doDeleteNonstrict(PathMapping pathMapping,
            final DeleteOption<PathMappingCB> option) {
        assertObjectNotNull("pathMapping", pathMapping);
        prepareDeleteOption(option);
        helpDeleteNonstrictInternally(pathMapping,
                new InternalDeleteNonstrictCallback<PathMapping>() {
                    public int callbackDelegateDeleteNonstrict(
                            PathMapping entity) {
                        return delegateDeleteNonstrict(entity, option);
                    }
                });
    }

    /**
     * Delete the entity non-strictly ignoring deleted. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * PathMapping pathMapping = new PathMapping();
     * pathMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//pathMapping.setVersionNo(value);</span>
     * pathMappingBhv.<span style="color: #FD4747">deleteNonstrictIgnoreDeleted</span>(pathMapping);
     * <span style="color: #3F7E5E">// if the target entity doesn't exist, no exception</span>
     * </pre>
     * @param pathMapping The entity of delete target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrictIgnoreDeleted(PathMapping pathMapping) {
        doDeleteNonstrictIgnoreDeleted(pathMapping, null);
    }

    protected void doDeleteNonstrictIgnoreDeleted(PathMapping pathMapping,
            final DeleteOption<PathMappingCB> option) {
        assertObjectNotNull("pathMapping", pathMapping);
        prepareDeleteOption(option);
        helpDeleteNonstrictIgnoreDeletedInternally(
                pathMapping,
                new InternalDeleteNonstrictIgnoreDeletedCallback<PathMapping>() {
                    public int callbackDelegateDeleteNonstrict(
                            PathMapping entity) {
                        return delegateDeleteNonstrict(entity, option);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doRemoveNonstrict(Entity entity,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            deleteNonstrict(downcast(entity));
        } else {
            varyingDeleteNonstrict(downcast(entity), (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are insert target. (so default constraints are not available) <br />
     * And if the table has an identity, entities after the process do not have incremented values.
     * (When you use the (normal) insert(), an entity after the process has an incremented value)
     * @param pathMappingList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<PathMapping> pathMappingList) {
        return doBatchInsert(pathMappingList, null);
    }

    protected int[] doBatchInsert(List<PathMapping> pathMappingList,
            InsertOption<PathMappingCB> option) {
        assertObjectNotNull("pathMappingList", pathMappingList);
        prepareInsertOption(option);
        return delegateBatchInsert(pathMappingList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpCreate(List<Entity> ls,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchInsert((List) ls);
        } else {
            return varyingBatchInsert((List) ls, (InsertOption) option);
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are update target. {NOT modified only}
     * @param pathMappingList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<PathMapping> pathMappingList) {
        return doBatchUpdate(pathMappingList, null);
    }

    protected int[] doBatchUpdate(List<PathMapping> pathMappingList,
            UpdateOption<PathMappingCB> option) {
        assertObjectNotNull("pathMappingList", pathMappingList);
        prepareUpdateOption(option);
        return delegateBatchUpdate(pathMappingList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpModify(List<Entity> ls,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchUpdate((List) ls);
        } else {
            return varyingBatchUpdate((List) ls, (UpdateOption) option);
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * You can specify update columns used on set clause of update statement.
     * However you do not need to specify common columns for update
     * and an optimistick lock column because they are specified implicitly.
     * @param pathMappingList The list of the entity. (NotNull)
     * @param updateColumnSpec The specification of update columns. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<PathMapping> pathMappingList,
            SpecifyQuery<PathMappingCB> updateColumnSpec) {
        return doBatchUpdate(pathMappingList,
                createSpecifiedUpdateOption(updateColumnSpec));
    }

    /**
     * Batch-update the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are update target. {NOT modified only}
     * @param pathMappingList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(List<PathMapping> pathMappingList) {
        return doBatchUpdateNonstrict(pathMappingList, null);
    }

    protected int[] doBatchUpdateNonstrict(List<PathMapping> pathMappingList,
            UpdateOption<PathMappingCB> option) {
        assertObjectNotNull("pathMappingList", pathMappingList);
        prepareUpdateOption(option);
        return delegateBatchUpdateNonstrict(pathMappingList, option);
    }

    /**
     * Batch-update the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * You can specify update columns used on set clause of update statement.
     * However you do not need to specify common columns for update
     * and an optimistick lock column because they are specified implicitly.
     * @param pathMappingList The list of the entity. (NotNull)
     * @param updateColumnSpec The specification of update columns. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(List<PathMapping> pathMappingList,
            SpecifyQuery<PathMappingCB> updateColumnSpec) {
        return doBatchUpdateNonstrict(pathMappingList,
                createSpecifiedUpdateOption(updateColumnSpec));
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpModifyNonstrict(List<Entity> ls,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchUpdateNonstrict((List) ls);
        } else {
            return varyingBatchUpdateNonstrict((List) ls, (UpdateOption) option);
        }
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param pathMappingList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchDelete(List<PathMapping> pathMappingList) {
        return doBatchDelete(pathMappingList, null);
    }

    protected int[] doBatchDelete(List<PathMapping> pathMappingList,
            DeleteOption<PathMappingCB> option) {
        assertObjectNotNull("pathMappingList", pathMappingList);
        prepareDeleteOption(option);
        return delegateBatchDelete(pathMappingList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpRemove(List<Entity> ls,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchDelete((List) ls);
        } else {
            return varyingBatchDelete((List) ls, (DeleteOption) option);
        }
    }

    /**
     * Batch-delete the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param pathMappingList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDeleteNonstrict(List<PathMapping> pathMappingList) {
        return doBatchDeleteNonstrict(pathMappingList, null);
    }

    protected int[] doBatchDeleteNonstrict(List<PathMapping> pathMappingList,
            DeleteOption<PathMappingCB> option) {
        assertObjectNotNull("pathMappingList", pathMappingList);
        prepareDeleteOption(option);
        return delegateBatchDeleteNonstrict(pathMappingList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpRemoveNonstrict(List<Entity> ls,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchDeleteNonstrict((List) ls);
        } else {
            return varyingBatchDeleteNonstrict((List) ls, (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Insert the several entities by query (modified-only for fixed value).
     * <pre>
     * pathMappingBhv.<span style="color: #FD4747">queryInsert</span>(new QueryInsertSetupper&lt;pathMapping, PathMappingCB&gt;() {
     *     public ConditionBean setup(pathMapping entity, PathMappingCB intoCB) {
     *         FooCB cb = FooCB();
     *         cb.setupSelect_Bar();
     * 
     *         <span style="color: #3F7E5E">// mapping</span>
     *         intoCB.specify().columnMyName().mappedFrom(cb.specify().columnFooName());
     *         intoCB.specify().columnMyCount().mappedFrom(cb.specify().columnFooCount());
     *         intoCB.specify().columnMyDate().mappedFrom(cb.specify().specifyBar().columnBarDate());
     *         entity.setMyFixedValue("foo"); <span style="color: #3F7E5E">// fixed value</span>
     *         <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     *         <span style="color: #3F7E5E">//entity.setRegisterUser(value);</span>
     *         <span style="color: #3F7E5E">//entity.set...;</span>
     *         <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     *         <span style="color: #3F7E5E">//entity.setVersionNo(value);</span>
     * 
     *         return cb;
     *     }
     * });
     * </pre>
     * @param setupper The setup-per of query-insert. (NotNull)
     * @return The inserted count.
     */
    public int queryInsert(
            QueryInsertSetupper<PathMapping, PathMappingCB> setupper) {
        return doQueryInsert(setupper, null);
    }

    protected int doQueryInsert(
            QueryInsertSetupper<PathMapping, PathMappingCB> setupper,
            InsertOption<PathMappingCB> option) {
        assertObjectNotNull("setupper", setupper);
        prepareInsertOption(option);
        PathMapping entity = new PathMapping();
        PathMappingCB intoCB = createCBForQueryInsert();
        ConditionBean resourceCB = setupper.setup(entity, intoCB);
        return delegateQueryInsert(entity, intoCB, resourceCB, option);
    }

    protected PathMappingCB createCBForQueryInsert() {
        PathMappingCB cb = newMyConditionBean();
        cb.xsetupForQueryInsert();
        return cb;
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeCreate(
            QueryInsertSetupper<? extends Entity, ? extends ConditionBean> setupper,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryInsert((QueryInsertSetupper) setupper);
        } else {
            return varyingQueryInsert((QueryInsertSetupper) setupper,
                    (InsertOption) option);
        }
    }

    /**
     * Update the several entities by query non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * PathMapping pathMapping = new PathMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//pathMapping.setPK...(value);</span>
     * pathMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//pathMapping.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//pathMapping.set...;</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//pathMapping.setVersionNo(value);</span>
     * PathMappingCB cb = new PathMappingCB();
     * cb.query().setFoo...(value);
     * pathMappingBhv.<span style="color: #FD4747">queryUpdate</span>(pathMapping, cb);
     * </pre>
     * @param pathMapping The entity that contains update values. (NotNull, PrimaryKeyNullAllowed)
     * @param cb The condition-bean of PathMapping. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition.
     */
    public int queryUpdate(PathMapping pathMapping, PathMappingCB cb) {
        return doQueryUpdate(pathMapping, cb, null);
    }

    protected int doQueryUpdate(PathMapping pathMapping, PathMappingCB cb,
            UpdateOption<PathMappingCB> option) {
        assertObjectNotNull("pathMapping", pathMapping);
        assertCBNotNull(cb);
        prepareUpdateOption(option);
        return delegateQueryUpdate(pathMapping, cb, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeModify(Entity entity, ConditionBean cb,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryUpdate(downcast(entity), (PathMappingCB) cb);
        } else {
            return varyingQueryUpdate(downcast(entity), (PathMappingCB) cb,
                    (UpdateOption) option);
        }
    }

    /**
     * Delete the several entities by query. {NonExclusiveControl}
     * <pre>
     * PathMappingCB cb = new PathMappingCB();
     * cb.query().setFoo...(value);
     * pathMappingBhv.<span style="color: #FD4747">queryDelete</span>(pathMapping, cb);
     * </pre>
     * @param cb The condition-bean of PathMapping. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition.
     */
    public int queryDelete(PathMappingCB cb) {
        return doQueryDelete(cb, null);
    }

    protected int doQueryDelete(PathMappingCB cb,
            DeleteOption<PathMappingCB> option) {
        assertCBNotNull(cb);
        prepareDeleteOption(option);
        return delegateQueryDelete(cb, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeRemove(ConditionBean cb,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryDelete((PathMappingCB) cb);
        } else {
            return varyingQueryDelete((PathMappingCB) cb, (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                      Varying Update
    //                                                                      ==============
    // -----------------------------------------------------
    //                                         Entity Update
    //                                         -------------
    /**
     * Insert the entity with varying requests. <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as insert(entity).
     * <pre>
     * PathMapping pathMapping = new PathMapping();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * pathMapping.setFoo...(value);
     * pathMapping.setBar...(value);
     * InsertOption<PathMappingCB> option = new InsertOption<PathMappingCB>();
     * <span style="color: #3F7E5E">// you can insert by your values for common columns</span>
     * option.disableCommonColumnAutoSetup();
     * pathMappingBhv.<span style="color: #FD4747">varyingInsert</span>(pathMapping, option);
     * ... = pathMapping.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param pathMapping The entity of insert target. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsert(PathMapping pathMapping,
            InsertOption<PathMappingCB> option) {
        assertInsertOptionNotNull(option);
        doInsert(pathMapping, option);
    }

    /**
     * Update the entity with varying requests modified-only. {UpdateCountZeroException, ExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification), disableCommonColumnAutoSetup(). <br />
     * Other specifications are same as update(entity).
     * <pre>
     * PathMapping pathMapping = new PathMapping();
     * pathMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * pathMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * pathMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     <span style="color: #3F7E5E">// you can update by self calculation values</span>
     *     UpdateOption&lt;PathMappingCB&gt; option = new UpdateOption&lt;PathMappingCB&gt;();
     *     option.self(new SpecifyQuery&lt;PathMappingCB&gt;() {
     *         public void specify(PathMappingCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     pathMappingBhv.<span style="color: #FD4747">varyingUpdate</span>(pathMapping, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param pathMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(PathMapping pathMapping,
            UpdateOption<PathMappingCB> option) {
        assertUpdateOptionNotNull(option);
        doUpdate(pathMapping, option);
    }

    /**
     * Update the entity with varying requests non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification), disableCommonColumnAutoSetup(). <br />
     * Other specifications are same as updateNonstrict(entity).
     * <pre>
     * <span style="color: #3F7E5E">// ex) you can update by self calculation values</span>
     * PathMapping pathMapping = new PathMapping();
     * pathMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * pathMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//pathMapping.setVersionNo(value);</span>
     * UpdateOption&lt;PathMappingCB&gt; option = new UpdateOption&lt;PathMappingCB&gt;();
     * option.self(new SpecifyQuery&lt;PathMappingCB&gt;() {
     *     public void specify(PathMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * pathMappingBhv.<span style="color: #FD4747">varyingUpdateNonstrict</span>(pathMapping, option);
     * </pre>
     * @param pathMapping The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdateNonstrict(PathMapping pathMapping,
            UpdateOption<PathMappingCB> option) {
        assertUpdateOptionNotNull(option);
        doUpdateNonstrict(pathMapping, option);
    }

    /**
     * Insert or update the entity with varying requests. {ExclusiveControl(when update)}<br />
     * Other specifications are same as insertOrUpdate(entity).
     * @param pathMapping The entity of insert or update target. (NotNull)
     * @param insertOption The option of insert for varying requests. (NotNull)
     * @param updateOption The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsertOrUpdate(PathMapping pathMapping,
            InsertOption<PathMappingCB> insertOption,
            UpdateOption<PathMappingCB> updateOption) {
        assertInsertOptionNotNull(insertOption);
        assertUpdateOptionNotNull(updateOption);
        doInesrtOrUpdate(pathMapping, insertOption, updateOption);
    }

    /**
     * Insert or update the entity with varying requests non-strictly. {NonExclusiveControl(when update)}<br />
     * Other specifications are same as insertOrUpdateNonstrict(entity).
     * @param pathMapping The entity of insert or update target. (NotNull)
     * @param insertOption The option of insert for varying requests. (NotNull)
     * @param updateOption The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsertOrUpdateNonstrict(PathMapping pathMapping,
            InsertOption<PathMappingCB> insertOption,
            UpdateOption<PathMappingCB> updateOption) {
        assertInsertOptionNotNull(insertOption);
        assertUpdateOptionNotNull(updateOption);
        doInesrtOrUpdateNonstrict(pathMapping, insertOption, updateOption);
    }

    /**
     * Delete the entity with varying requests. {UpdateCountZeroException, ExclusiveControl} <br />
     * Now a valid option does not exist. <br />
     * Other specifications are same as delete(entity).
     * @param pathMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void varyingDelete(PathMapping pathMapping,
            DeleteOption<PathMappingCB> option) {
        assertDeleteOptionNotNull(option);
        doDelete(pathMapping, option);
    }

    /**
     * Delete the entity with varying requests non-strictly. {UpdateCountZeroException, NonExclusiveControl} <br />
     * Now a valid option does not exist. <br />
     * Other specifications are same as deleteNonstrict(entity).
     * @param pathMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void varyingDeleteNonstrict(PathMapping pathMapping,
            DeleteOption<PathMappingCB> option) {
        assertDeleteOptionNotNull(option);
        doDeleteNonstrict(pathMapping, option);
    }

    // -----------------------------------------------------
    //                                          Batch Update
    //                                          ------------
    /**
     * Batch-insert the list with varying requests. <br />
     * For example, disableCommonColumnAutoSetup()
     * , disablePrimaryKeyIdentity(), limitBatchInsertLogging(). <br />
     * Other specifications are same as batchInsert(entityList).
     * @param pathMappingList The list of the entity. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The array of inserted count.
     */
    public int[] varyingBatchInsert(List<PathMapping> pathMappingList,
            InsertOption<PathMappingCB> option) {
        assertInsertOptionNotNull(option);
        return doBatchInsert(pathMappingList, option);
    }

    /**
     * Batch-update the list with varying requests. <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), limitBatchUpdateLogging(). <br />
     * Other specifications are same as batchUpdate(entityList).
     * @param pathMappingList The list of the entity. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The array of updated count.
     */
    public int[] varyingBatchUpdate(List<PathMapping> pathMappingList,
            UpdateOption<PathMappingCB> option) {
        assertUpdateOptionNotNull(option);
        return doBatchUpdate(pathMappingList, option);
    }

    /**
     * Batch-update the list with varying requests non-strictly. <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), limitBatchUpdateLogging(). <br />
     * Other specifications are same as batchUpdateNonstrict(entityList).
     * @param pathMappingList The list of the entity. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The array of updated count.
     */
    public int[] varyingBatchUpdateNonstrict(List<PathMapping> pathMappingList,
            UpdateOption<PathMappingCB> option) {
        assertUpdateOptionNotNull(option);
        return doBatchUpdateNonstrict(pathMappingList, option);
    }

    /**
     * Batch-delete the list with varying requests. <br />
     * For example, limitBatchDeleteLogging(). <br />
     * Other specifications are same as batchDelete(entityList).
     * @param pathMappingList The list of the entity. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The array of deleted count.
     */
    public int[] varyingBatchDelete(List<PathMapping> pathMappingList,
            DeleteOption<PathMappingCB> option) {
        assertDeleteOptionNotNull(option);
        return doBatchDelete(pathMappingList, option);
    }

    /**
     * Batch-delete the list with varying requests non-strictly. <br />
     * For example, limitBatchDeleteLogging(). <br />
     * Other specifications are same as batchDeleteNonstrict(entityList).
     * @param pathMappingList The list of the entity. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The array of deleted count.
     */
    public int[] varyingBatchDeleteNonstrict(List<PathMapping> pathMappingList,
            DeleteOption<PathMappingCB> option) {
        assertDeleteOptionNotNull(option);
        return doBatchDeleteNonstrict(pathMappingList, option);
    }

    // -----------------------------------------------------
    //                                          Query Update
    //                                          ------------
    /**
     * Insert the several entities by query with varying requests (modified-only for fixed value). <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as queryInsert(entity, setupper). 
     * @param setupper The setup-per of query-insert. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The inserted count.
     */
    public int varyingQueryInsert(
            QueryInsertSetupper<PathMapping, PathMappingCB> setupper,
            InsertOption<PathMappingCB> option) {
        assertInsertOptionNotNull(option);
        return doQueryInsert(setupper, option);
    }

    /**
     * Update the several entities by query with varying requests non-strictly modified-only. {NonExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), allowNonQueryUpdate(). <br />
     * Other specifications are same as queryUpdate(entity, cb). 
     * <pre>
     * <span style="color: #3F7E5E">// ex) you can update by self calculation values</span>
     * PathMapping pathMapping = new PathMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//pathMapping.setPK...(value);</span>
     * pathMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//pathMapping.setVersionNo(value);</span>
     * PathMappingCB cb = new PathMappingCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;PathMappingCB&gt; option = new UpdateOption&lt;PathMappingCB&gt;();
     * option.self(new SpecifyQuery&lt;PathMappingCB&gt;() {
     *     public void specify(PathMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * pathMappingBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(pathMapping, cb, option);
     * </pre>
     * @param pathMapping The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of PathMapping. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryUpdate(PathMapping pathMapping, PathMappingCB cb,
            UpdateOption<PathMappingCB> option) {
        assertUpdateOptionNotNull(option);
        return doQueryUpdate(pathMapping, cb, option);
    }

    /**
     * Delete the several entities by query with varying requests non-strictly. <br />
     * For example, allowNonQueryDelete(). <br />
     * Other specifications are same as batchUpdateNonstrict(entityList).
     * @param cb The condition-bean of PathMapping. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryDelete(PathMappingCB cb,
            DeleteOption<PathMappingCB> option) {
        assertDeleteOptionNotNull(option);
        return doQueryDelete(cb, option);
    }

    // ===================================================================================
    //                                                                          OutsideSql
    //                                                                          ==========
    /**
     * Prepare the basic executor of outside-SQL to execute it. <br />
     * The invoker of behavior command should be not null when you call this method.
     * <pre>
     * You can use the methods for outside-SQL are as follows:
     * {Basic}
     *   o selectList()
     *   o execute()
     *   o call()
     * 
     * {Entity}
     *   o entityHandling().selectEntity()
     *   o entityHandling().selectEntityWithDeletedCheck()
     * 
     * {Paging}
     *   o autoPaging().selectList()
     *   o autoPaging().selectPage()
     *   o manualPaging().selectList()
     *   o manualPaging().selectPage()
     * 
     * {Cursor}
     *   o cursorHandling().selectCursor()
     * 
     * {Option}
     *   o dynamicBinding().selectList()
     *   o removeBlockComment().selectList()
     *   o removeLineComment().selectList()
     *   o formatSql().selectList()
     * </pre>
     * @return The basic executor of outside-SQL. (NotNull) 
     */
    public OutsideSqlBasicExecutor<PathMappingBhv> outsideSql() {
        return doOutsideSql();
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCountUniquely(PathMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb, true));
    }

    protected int delegateSelectCountPlainly(PathMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb, false));
    }

    protected <ENTITY extends PathMapping> void delegateSelectCursor(
            PathMappingCB cb, EntityRowHandler<ENTITY> erh, Class<ENTITY> et) {
        invoke(createSelectCursorCBCommand(cb, erh, et));
    }

    protected <ENTITY extends PathMapping> List<ENTITY> delegateSelectList(
            PathMappingCB cb, Class<ENTITY> et) {
        return invoke(createSelectListCBCommand(cb, et));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(PathMapping e, InsertOption<PathMappingCB> op) {
        if (!processBeforeInsert(e, op)) {
            return 0;
        }
        return invoke(createInsertEntityCommand(e, op));
    }

    protected int delegateUpdate(PathMapping e, UpdateOption<PathMappingCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return invoke(createUpdateEntityCommand(e, op));
    }

    protected int delegateUpdateNonstrict(PathMapping e,
            UpdateOption<PathMappingCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return invoke(createUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateDelete(PathMapping e, DeleteOption<PathMappingCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return invoke(createDeleteEntityCommand(e, op));
    }

    protected int delegateDeleteNonstrict(PathMapping e,
            DeleteOption<PathMappingCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return invoke(createDeleteNonstrictEntityCommand(e, op));
    }

    protected int[] delegateBatchInsert(List<PathMapping> ls,
            InsertOption<PathMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertCommand(processBatchInternally(ls, op),
                op));
    }

    protected int[] delegateBatchUpdate(List<PathMapping> ls,
            UpdateOption<PathMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateCommand(
                processBatchInternally(ls, op, false), op));
    }

    protected int[] delegateBatchUpdateNonstrict(List<PathMapping> ls,
            UpdateOption<PathMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int[] delegateBatchDelete(List<PathMapping> ls,
            DeleteOption<PathMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteCommand(
                processBatchInternally(ls, op, false), op));
    }

    protected int[] delegateBatchDeleteNonstrict(List<PathMapping> ls,
            DeleteOption<PathMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int delegateQueryInsert(PathMapping e, PathMappingCB inCB,
            ConditionBean resCB, InsertOption<PathMappingCB> op) {
        if (!processBeforeQueryInsert(e, inCB, resCB, op)) {
            return 0;
        }
        return invoke(createQueryInsertCBCommand(e, inCB, resCB, op));
    }

    protected int delegateQueryUpdate(PathMapping e, PathMappingCB cb,
            UpdateOption<PathMappingCB> op) {
        if (!processBeforeQueryUpdate(e, cb, op)) {
            return 0;
        }
        return invoke(createQueryUpdateCBCommand(e, cb, op));
    }

    protected int delegateQueryDelete(PathMappingCB cb,
            DeleteOption<PathMappingCB> op) {
        if (!processBeforeQueryDelete(cb, op)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return !(downcast(entity).getVersionNo() + "").equals("null");// For primitive type
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected PathMapping downcast(Entity entity) {
        return helpEntityDowncastInternally(entity, PathMapping.class);
    }

    protected PathMappingCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb, PathMappingCB.class);
    }
}
