/*
 * Copyright 2007-2008 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.chronos.core.task.strategy;

import java.util.concurrent.TimeUnit;

import org.seasar.chronos.core.Scheduler;
import org.seasar.chronos.core.TaskThreadPool;
import org.seasar.chronos.core.TaskTrigger;
import org.seasar.chronos.core.ThreadPoolType;
import org.seasar.chronos.core.task.TaskPropertyReader;
import org.seasar.chronos.core.task.TaskPropertyWriter;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;

public class TaskExecuteStrategyWrapper implements TaskExecuteStrategy {

    private final TaskExecuteStrategy taskExecuteStrategy;

    public TaskExecuteStrategyWrapper(
            final TaskExecuteStrategy taskExecuteStrategy) {
        this.taskExecuteStrategy = taskExecuteStrategy;
    }

    public boolean await(final long time, final TimeUnit timeUnit)
            throws InterruptedException {
        return taskExecuteStrategy.await(time, timeUnit);
    }

    public boolean cancel() {
        return taskExecuteStrategy.cancel();
    }

    public boolean checkMoveAnotherTask(final String nextTaskName) {
        return taskExecuteStrategy.checkMoveAnotherTask(nextTaskName);
    }

    public void destroy() throws InterruptedException {
        taskExecuteStrategy.destroy();
    }

    public String end() throws InterruptedException {
        return taskExecuteStrategy.end();
    }

    public void execute(final String startTaskName) throws InterruptedException {
        taskExecuteStrategy.execute(startTaskName);
    }

    public String getDescription() {
        return taskExecuteStrategy.getDescription();
    }

    public Scheduler getScheduler() {
        return taskExecuteStrategy.getScheduler();
    }

    public Object getTask() {
        return taskExecuteStrategy.getTask();
    }

    public Class<?> getTaskClass() {
        return taskExecuteStrategy.getTaskClass();
    }

    public long getTaskId() {
        return taskExecuteStrategy.getTaskId();
    }

    public String getTaskName() {
        return taskExecuteStrategy.getTaskName();
    }

    public TaskPropertyReader getTaskPropertyReader() {
        return taskExecuteStrategy.getTaskPropertyReader();
    }

    public TaskPropertyWriter getTaskPropertyWriter() {
        return taskExecuteStrategy.getTaskPropertyWriter();
    }

    public TaskThreadPool getThreadPool() {
        return taskExecuteStrategy.getThreadPool();
    }

    public int getThreadPoolSize() {
        return taskExecuteStrategy.getThreadPoolSize();
    }

    public ThreadPoolType getThreadPoolType() {
        return taskExecuteStrategy.getThreadPoolType();
    }

    public TaskTrigger getTrigger() {
        return taskExecuteStrategy.getTrigger();
    }

    public void hotdeployStart() {
        taskExecuteStrategy.hotdeployStart();
    }

    public void hotdeployStop() {
        taskExecuteStrategy.hotdeployStop();
    }

    public void initialize() throws InterruptedException {
        taskExecuteStrategy.initialize();
    }

    public String start() throws InterruptedException {
        return taskExecuteStrategy.start();
    }

    public boolean isEndTask() {
        return taskExecuteStrategy.isEndTask();
    }

    public boolean isExecuted() {
        return taskExecuteStrategy.isExecuted();
    }

    public boolean isPrepared() {
        return taskExecuteStrategy.isPrepared();
    }

    public boolean isReScheduleTask() {
        return taskExecuteStrategy.isReScheduleTask();
    }

    public boolean isShutdownTask() {
        return taskExecuteStrategy.isShutdownTask();
    }

    public boolean isStartTask() {
        return taskExecuteStrategy.isStartTask();
    }

    public void prepare() {
        taskExecuteStrategy.prepare();
    }

    public void setComponentDef(final ComponentDef componentDef) {
        taskExecuteStrategy.setComponentDef(componentDef);
    }

    public void setEndTask(final boolean endTask) {
        taskExecuteStrategy.setEndTask(endTask);
    }

    public void setExecuted(final boolean executed) {
        taskExecuteStrategy.setExecuted(executed);
    }

    public void setGetterSignal(final Object getterSignal) {
        taskExecuteStrategy.setGetterSignal(getterSignal);
    }

    public void setScheduler(final Scheduler scheduler) {
        taskExecuteStrategy.setScheduler(scheduler);
    }

    public void setShutdownTask(final boolean shutdownTask) {
        taskExecuteStrategy.setShutdownTask(shutdownTask);
    }

    public void setStartTask(final boolean startTask) {
        taskExecuteStrategy.setStartTask(startTask);
    }

    public void setTask(final Object task) {
        taskExecuteStrategy.setTask(task);
    }

    public void setTaskClass(final Class<?> taskClass) {
        taskExecuteStrategy.setTaskClass(taskClass);
    }

    public void setTaskId(final long taskId) {
        taskExecuteStrategy.setTaskId(taskId);
    }

    @Binding(bindingType = BindingType.NONE)
    public void setThreadPool(final TaskThreadPool taskThreadPool) {
        taskExecuteStrategy.setThreadPool(taskThreadPool);
    }

    @Binding(bindingType = BindingType.NONE)
    public void setTrigger(final TaskTrigger taskTrigger) {
        taskExecuteStrategy.setTrigger(taskTrigger);
    }

    public void unprepare() {
        taskExecuteStrategy.unprepare();
    }

    public void waitOne() throws InterruptedException {
        taskExecuteStrategy.waitOne();
    }

    public Exception getException() {
        return taskExecuteStrategy.getException();
    }

    public void setException(final Exception exception) {
        taskExecuteStrategy.setException(exception);
    }

    public boolean isHotdeployDisable() {
        return taskExecuteStrategy.isHotdeployDisable();
    }

    public void setHotdeployDisable(final boolean hotdeployDisable) {
        taskExecuteStrategy.setHotdeployDisable(hotdeployDisable);
    }

    public void catchException(final Exception exception) {
        taskExecuteStrategy.catchException(exception);
    }

}
