/*
 * Copyright 2007-2008 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.chronos.core.task.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import org.seasar.chronos.core.TaskTrigger;
import org.seasar.chronos.core.annotation.task.Task;
import org.seasar.chronos.core.task.TaskAnnotationReader;
import org.seasar.chronos.core.task.TaskConstant;
import org.seasar.chronos.core.task.TaskTriggerFinder;
import org.seasar.framework.exception.NoSuchMethodRuntimeException;
import org.seasar.framework.util.tiger.ReflectionUtil;

public class TaskAnnotationReaderImpl implements TaskAnnotationReader {

    private static final String METHOD_NAME_GET_TRIGGER = "getTrigger";

    private Class<?> taskClass;

    private TaskTriggerFinder taskTriggerFinder;

    public void setup(final Class<?> taskClass) {
        this.taskClass = taskClass;
    }

    public boolean hasTaskAnnotation() {
        final Task task = taskClass.getAnnotation(Task.class);
        if (task != null) {
            return true;
        }
        return false;
    }

    public boolean hasTriggerAnnotation() {
        final Annotation[] annotaions = taskClass.getAnnotations();
        for (final Annotation annotaion : annotaions) {
            final Class<?> annotaionClass = annotaion.annotationType();
            final String annotationName = annotaionClass.getSimpleName();
            // サフィックスがTriggerなアノテーションを検索する
            if (annotationName
                    .endsWith(TaskConstant.NAME_SPACE_TRIGGER_ANNOTATION_SUFFIX)) {
                return true;
            }
        }
        return false;
    }

    public boolean hasTriggerProperty() {
        try {
            final Method method = ReflectionUtil.getMethod(taskClass,
                    METHOD_NAME_GET_TRIGGER, new Class[0]);
            return method != null;
        } catch (final NoSuchMethodRuntimeException ex) {
            ;
        }
        return false;
    }

    public Task getTaskAnnotation() {
        final Task task = taskClass.getAnnotation(Task.class);
        return task;
    }

    public TaskTrigger getTriggerAnnotationClass(
            final TriggerAnnotationHandler triggerAnnotationHandler) {
        final Annotation[] annotations = taskClass.getAnnotations();
        final TaskTrigger taskTrigger = taskTriggerFinder.find(annotations,
                triggerAnnotationHandler);
        return taskTrigger;
    }

    public void setTaskTriggerFinder(final TaskTriggerFinder taskTriggerFinder) {
        this.taskTriggerFinder = taskTriggerFinder;
    }

}
