﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class AppBase
    Partial Public Class Archive
        Partial Public Class Threading

            Public Class CoverLoadTask
                Implements IAppBase
                Implements Logic.Threading.TaskQueueingThread.ITask
                Public Property AppBase As AppBase Implements IAppBase.AppBase

                Public Path As Logic.FileSystem.Path
                Public Entries() As EntryInfo

                Public Sub Task(ByVal SenderIsStopRequested As Logic.Threading.SignalHandler) Implements Logic.Threading.TaskQueueingThread.ITask.Task

                    ' parameter check /////////////////////////////////////////////////////////////////////////////////////////////////////////

                    If (AppBase Is Nothing Or Entries Is Nothing) OrElse (Entries.Length <= 0) Then Return

                    Dim SamplingCount As Integer = AppBase.ImagingConfig.SamplingCount
                    If SamplingCount <= 0 Then Return

                    AppBase.Echoing.Log.Echo("Cover Load", AppendLogArgs.LogType.Status)
                    AppBase.Echoing.Log.EchoProgressOutline(Path)

                    If Path.FileExists = False Then
                        AppBase.Echoing.Log.Echo(String.Format("File Not Found : {0}", Path))
                        AppBase.Echoing.Log.Echo("Exit Task")
                        Return
                    End If

                    ' create archive operation process ////////////////////////////////////////////////////////////////////////////////////////

                    Dim p As ArchiveProcess = Nothing
                    Dim ext_cfg As ArchiveOptionConfig = AppBase.Config.ExportableGroup.DefaultCompressSetting(Path.Extention)
                    If ext_cfg IsNot Nothing Then p = ext_cfg.CreateProcess(AppBase, SenderIsStopRequested)
                    If p Is Nothing Then
                        AppBase.Echoing.Log.Echo(String.Format("Not Supported FileType : {0}", Path))
                        AppBase.Echoing.Log.Echo("Exit Task")
                        Return
                    End If

                    ' extention filtering /////////////////////////////////////////////////////////////////////////////////////////////////////

                    Dim ImgExtentions As New Logic.FileSystem.Extention.Collection(Logic.Graphics.GDIPlusExtentions)
                    Dim FilteredImagePath As New Collections.Generic.List(Of String)
                    For Each Entry As EntryInfo In Entries
                        If ImgExtentions.Contains(Logic.FileSystem.Path.GetExtention(Entry.EntryPath)) Then FilteredImagePath.Add(Entry.EntryPath)
                    Next
                    If FilteredImagePath.Count <= 0 Then Return

                    ' entry extract loop //////////////////////////////////////////////////////////////////////////////////////////////////////

                    SamplingCount = Math.Min(ImgExtentions.Count, SamplingCount)
                    Dim ExtractedWidthPerHeight As New Collections.Generic.List(Of Double)
                    For idx As Integer = 1 To SamplingCount
                        Dim MemBuf As IO.MemoryStream = Nothing
                        Dim idxChoice As Integer = (FilteredImagePath.Count - 1) * idx / (SamplingCount + 1)
                        Dim EntryPath As String = FilteredImagePath(idxChoice) ' exclude min and max side
                        Try
                            If p.Extract(MemBuf, EntryPath, Path.ToString) = RESULT.OK Then
                                Dim Streamed As Logic.Graphics.StreamedImage = Logic.Graphics.StreamedImage.TryInstance(MemBuf)
                                If Streamed IsNot Nothing Then
                                    ExtractedWidthPerHeight.Add(CDbl(Streamed.Image.Width) / CDbl(Streamed.Image.Height))
#If DEBUG Then
                                    AppBase.Echoing.Log.Echo(String.Format("{0}({1}x{2})", EntryPath, Streamed.Image.Width, Streamed.Image.Height))
#End If
                                    If AppBase.ImagingConfig.IsDisplayProgress = False Then
                                        Streamed.Dispose()
                                        Streamed = Nothing
                                    End If
                                End If
                                AppBase.Echoing.ArchiveItemCoverLoad.Echo(Path.ToString, EntryPath, Streamed, idx, SamplingCount)
                            End If
                        Catch ex As Exception
                            If MemBuf IsNot Nothing Then MemBuf.Close()
#If DEBUG Then
                            Throw
#End If
                        End Try
                    Next
                    If ExtractedWidthPerHeight.Count <= 0 Then Return

                    ' get statistics average /////////////////////////////////////////////////////////////////////////////////////////////////

                    Dim WidthPerHeightHistgram As New Logic.Math.Statistics.AutoHistogram(Of Double)(ExtractedWidthPerHeight)
                    Dim AvrWidthPerHeight As Double = WidthPerHeightHistgram.ModeBins.Average
                    Dim IsWideCheck As Boolean = AppBase.ImagingConfig.IsPermitWideOnNarrow And AvrWidthPerHeight <= 1.1
                    ' cover match loop ///////////////////////////////////////////////////////////////////////////////////////////////////////

                    For Each EntryPath As String In FilteredImagePath
                        Dim MemBuf As IO.MemoryStream = Nothing
                        Try
                            If p.Extract(MemBuf, EntryPath, Path.ToString) = RESULT.OK Then
                                Dim Streamed As Logic.Graphics.StreamedImage = Logic.Graphics.StreamedImage.TryInstance(MemBuf)
                                If Streamed IsNot Nothing Then
                                    Dim ExpectWidth As Double = Streamed.Image.Height * AvrWidthPerHeight
                                    Dim PermitDistance As Double = Math.Abs(ExpectWidth * AppBase.ImagingConfig.PermitPercent / 100.0)
                                    If (Math.Abs(Streamed.Image.Width - ExpectWidth) <= PermitDistance) OrElse _
                                        (IsWideCheck And (Math.Abs(Streamed.Image.Width - ExpectWidth * 2) <= (PermitDistance * 2))) Then
                                        AppBase.Echoing.ArchiveItemCoverLoad.Echo(Path.ToString, EntryPath, Streamed, 0, SamplingCount)
                                        Exit For ' macth complete
                                    Else
                                        Streamed.Dispose()
                                    End If
                                End If
                            End If
                        Catch ex As Exception
                            If MemBuf IsNot Nothing Then MemBuf.Close()
#If DEBUG Then
                            Throw
#End If
                        End Try
                    Next

                End Sub

            End Class

        End Class

    End Class

End Class

