﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class AppBase
    Partial Public Class Archive
        Partial Public Class Threading

            Public Class MainTask

                Public Sub New(ByVal AppBase As AppBase)
                    Me.AppBase = AppBase
                End Sub

                Public ReadOnly Property IsWorkOut As Boolean
                    Get
                        SyncLock Payload
                            IsWorkOut = Payload.IsWorkOut
                        End SyncLock
                    End Get
                End Property

                Public Function ArchiveTask(ByVal ArgsCollection As Collections.ObjectModel.ReadOnlyCollection(Of ArchiveItemScanArgs)) As Boolean
                    ArchiveTask = False
                    SyncLock Payload
                        If Payload.IsWorkOut Then
                            Payload.Enqueue(New AppBase.Archive.Threading.ArchiveTask(AppBase, ArgsCollection))
                            ArchiveTask = True
                        End If
                    End SyncLock
                End Function

                Public Function CrcCheck(ByVal ArchivePathCollection As Collections.ObjectModel.ReadOnlyCollection(Of String)) As Boolean
                    CrcCheck = False
                    SyncLock Payload
                        If Payload.IsWorkOut Then
                            Payload.Enqueue(New AppBase.Archive.Threading.CrcCheckTask(AppBase, ArchivePathCollection))
                            CrcCheck = True
                        End If
                    End SyncLock
                End Function

                Public Function EnumEntry(ByVal ArchivePath As String) As Boolean
                    EnumEntry = False
                    SyncLock Payload
                        If Payload.IsWorkOut Then
                            Payload.Enqueue(New AppBase.Archive.Threading.EnumEntryTask(AppBase, ArchivePath))
                            EnumEntry = True
                        End If
                    End SyncLock
                End Function

                Public Function Scan(ByVal ArchivePathCollection As Collections.ObjectModel.ReadOnlyCollection(Of String)) As Boolean
                    Scan = False
                    SyncLock Payload
                        If Payload.IsWorkOut Then
                            Payload.Enqueue(New AppBase.Archive.Threading.ScanTask(AppBase, ArchivePathCollection))
                            Scan = True
                        End If
                    End SyncLock
                End Function

                Public Function StopRequest(Optional ByVal isWaitForExit As Boolean = False) As Boolean
                    SyncLock Payload
                        StopRequest = Payload.StopRequest(isWaitForExit)
                    End SyncLock
                End Function

                Private AppBase As AppBase
                Private Payload As New Logic.Threading.TaskQueueingThread
            End Class

        End Class
    End Class
End Class
