﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Public Class ConfigRootPanel
    Implements IAppBase
    Implements IReadOnly

    ' public properties //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Private m_AppBase As AppBase
    Public Property AppBase As AppBase Implements IAppBase.AppBase
        Get
            Return m_AppBase
        End Get
        Set(ByVal value As AppBase)
            m_AppBase = Nothing ' change apply mode = off
            If IsDisposed = False And Disposing = False Then
                If value Is Nothing Then
                    RarExePath.Text = Nothing
                    WorkFolder.Text = Nothing
                    DefaultConfigSetting.Text = Nothing
                    OpenImageCmd.Text = Nothing
                    OpenSoundCmd.Text = Nothing
                Else
                    RarExePath.Text = AppBase.Archive.RarOptionConfig.RarPath
                    WorkFolder.Text = value.Config.Locations.WorkFolder.Path.ToString
                    DefaultConfigSetting.Text = value.DefaultCompressSetting.SelectedExt.TextInformation
                    OpenImageCmd.Text = value.Config.OpenCmdAsImage
                    OpenSoundCmd.Text = value.Config.OpenCmdAsSound
                End If
            End If
            m_AppBase = value
        End Set
    End Property

    Private m_ReadOnly As Boolean = False
    <System.ComponentModel.DefaultValue(False)> _
    Public Property [ReadOnly] As Boolean Implements IReadOnly.ReadOnly
        Get
            Return m_ReadOnly
        End Get
        Set(ByVal value As Boolean)
            RarExePath.ReadOnly = m_ReadOnly
            RarExePathOpenButton.Enabled = Not m_ReadOnly
            WorkFolder.ReadOnly = m_ReadOnly
            WorkFolderOpenButton.Enabled = Not m_ReadOnly
            DefaultCompressSettingButton.Enabled = Not m_ReadOnly
            OpenImageCmd.ReadOnly = m_ReadOnly
            OpenImageCmdInsertContextButton.Enabled = Not m_ReadOnly
            OpenSoundCmd.ReadOnly = m_ReadOnly
            OpenSoundCmdInsertContextButton.Enabled = Not m_ReadOnly
        End Set
    End Property

    ' private implements ////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    Private ReadOnly InsertContext As New CustomContextMenu.InsertTextInOpenAsContextMenu

    Protected Overrides Sub OnVisibleChanged(ByVal e As System.EventArgs)
        MyBase.OnVisibleChanged(e)
        If Visible = False Then AppBase = Nothing
    End Sub

    Private Sub RarExePathOpenButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RarExePathOpenButton.Click

        Dim ofd As New OpenFileDialog

        ofd.FileName = "Rar.exe"
        If String.IsNullOrWhiteSpace(RarExePath.Text) Then
            ofd.InitialDirectory = System.Environment.GetFolderPath(Environment.SpecialFolder.ProgramFiles)
        Else
            Try
                ofd.InitialDirectory = System.IO.Path.GetDirectoryName(RarExePath.Text)
            Catch ex As Exception
                ofd.InitialDirectory = System.Environment.GetFolderPath(Environment.SpecialFolder.ProgramFiles)
            End Try
        End If
        ofd.Filter = "実行ファイル (*.exe)|*.exe|すべてのファイル (*.*)|*.*"
        ofd.FilterIndex = 0
        ofd.Title = "Rar.exeを選択してください"

        ofd.RestoreDirectory = True
        ofd.CheckFileExists = True
        ofd.CheckPathExists = True

        If ofd.ShowDialog() = DialogResult.OK Then
            RarExePath.Text = ofd.FileName
            RarExePath_Validated(Nothing, Nothing)
        End If

    End Sub

    Private Sub WorkFolderOpenButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles WorkFolderOpenButton.Click
        Dim fbd As New FolderBrowserDialog
        fbd.Description = "作業フォルダを指定してください"
        If fbd.ShowDialog = DialogResult.OK Then
            WorkFolder.Text = fbd.SelectedPath
            WorkFolder_Validated(Nothing, Nothing)
        End If
    End Sub

    Private Sub WorkFolder_Validated(ByVal sender As Object, ByVal e As System.EventArgs) Handles WorkFolder.Validated
        If AppBase Is Nothing Then Return
        Dim Path As New Logic.FileSystem.Path(WorkFolder.Text)
        If Path.CompareTo(AppBase.Config.Locations.WorkFolder.Path) <> 0 Then
            If IO.Directory.Exists(WorkFolder.Text) = False Then
                If MsgBox("フォルダを作成しますか？" & vbCrLf & WorkFolder.Text, MsgBoxStyle.OkCancel) = vbOK Then
                    Try
                        IO.Directory.CreateDirectory(WorkFolder.Text)
                        AppBase.Config.Locations.WorkFolder.Path = WorkFolder.Text
                    Catch ex As Exception
                        MsgBox("フォルダの作成に失敗しました。")
                        AppBase.Config.Locations.WorkFolder.Path = Nothing
                    End Try
                End If
            ElseIf MsgBox("作業フォルダの変更を適用しますか？", MsgBoxStyle.OkCancel) = vbOK Then
                AppBase.Config.Locations.WorkFolder.Path = WorkFolder.Text
            End If
        End If
    End Sub

    Private Sub OpenImageCmd_Validated(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OpenImageCmd.Validated
        If AppBase Is Nothing Then Return
        AppBase.Config.OpenCmdAsImage = OpenImageCmd.Text
    End Sub

    Private Sub OpenSoundCmd_Validated(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OpenSoundCmd.Validated
        If AppBase Is Nothing Then Return
        AppBase.Config.OpenCmdAsSound = OpenSoundCmd.Text
    End Sub

    Private Sub RarExePath_Validated(ByVal sender As Object, ByVal e As System.EventArgs) Handles RarExePath.Validated
        If AppBase Is Nothing Then Return
        AppBase.Archive.RarOptionConfig.RarPath = RarExePath.Text
    End Sub

    Private Sub DefaultCompressSettingButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles DefaultCompressSettingButton.Click
        Dim dlg As New ExtConfigDialog
        dlg.Text = "Default Compress Settings"
        dlg.CompressSetting = AppBase.DefaultCompressSetting
        If dlg.ShowDialog() = Windows.Forms.DialogResult.OK Then
            AppBase.Config.ExportableGroup.DefaultCompressSetting = dlg.CompressSetting
            DefaultConfigSetting.Text = dlg.CompressSetting.SelectedExt.TextInformation
        End If
    End Sub

    Private Sub OpenImageCmdInsertContextButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OpenImageCmdInsertContextButton.Click
        InsertContext.Show(OpenImageCmdInsertContextButton, OpenImageCmd, AddressOf OpenImageCmd_Validated)
    End Sub

    Private Sub OpenSoundCmdInsertContextButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OpenSoundCmdInsertContextButton.Click
        InsertContext.Show(OpenSoundCmdInsertContextButton, OpenSoundCmd, AddressOf OpenSoundCmd_Validated)
    End Sub

End Class

