﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class Logic
    Partial Public Class CommandlineParser

        Public Class ParseResult

            Public Sub New(Optional ByVal Cmd As String = Nothing)
                Me.Cmd = Cmd
            End Sub

            ' properties ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            Private m_Cmd As String = Nothing
            Public Property Cmd As String
                Get
                    Return New String(m_Cmd)
                End Get
                Set(ByVal value As String)
                    If value Is Nothing Then
                        m_Cmd = Nothing
                        m_Arguments = Nothing
                        m_Process = Nothing
                        Return
                    End If
                    m_Cmd = New String(value)
                    Dim Match As System.Text.RegularExpressions.Match = System.Text.RegularExpressions.Regex.Match(Cmd, "(""([^""]*?)""|[^\s""]+)\s*(.*)")
                    Dim Proc As String = Match.Groups(IIf(String.IsNullOrEmpty(Match.Groups(2).Value), 1, 2)).Value
                    If Not String.IsNullOrWhiteSpace(Proc) Then m_Process = Proc
                    If Not String.IsNullOrWhiteSpace(Match.Groups(3).Value) Then m_Arguments = Match.Groups(3).Value
                End Set
            End Property

            Private m_Process As String
            Public ReadOnly Property Process As String
                Get
                    Return m_Process
                End Get
            End Property

            Public m_Arguments As String
            Public ReadOnly Property Arguments As String
                Get
                    Return m_Arguments
                End Get
            End Property

            ' methods ///////////////////////////////////////////////////////////////////
            Public Overrides Function ToString() As String
                Return Cmd
            End Function

            Public Shared Widening Operator CType(ByVal val As String) As ParseResult
                Return New ParseResult(val)
            End Operator

        End Class

    End Class
End Class