﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class Logic
    Partial Public Class FileSystem

        Public Class PathBase(Of TStringValidater As {FileSystem.PathStringValidater, New})
            Inherits PathBase

            Public Class CollectionBase(Of TPathBased As {PathBase(Of TStringValidater), New})
                Implements Xml.Serialization.IXmlSerializable
                Implements System.Collections.IEnumerable

                Public Class StringValidater
                    Inherits FileSystem.PathStringValidater
                    Public Sub New()
                        Dim codes As New System.Collections.Generic.List(Of Char)(PathBase(Of TStringValidater).Validater.InvalidChars)
                        codes.Add(SplitSign)
                        m_InvalidChars = codes.ToArray
                    End Sub
                    Private ReadOnly m_InvalidChars As Char()
                    Public Overrides ReadOnly Property InvalidChars As Char()
                        Get
                            Return m_InvalidChars
                        End Get
                    End Property
                End Class

                ' construct ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                Public Sub New()
                    Clear()
                End Sub

                Public Sub New(ByVal s As String)
                    Me.New()
                    Add(s)
                End Sub

                Public Sub New(ByVal s As System.Collections.Generic.IEnumerable(Of String))
                    Me.New()
                    Add(s)
                End Sub

                ' public properties ///////////////////////////////////////////////////////////////////////////////////////////////////////////////

                Public Const SplitSign As Char = ";"c
                Public Shared ReadOnly Validater As New CollectionBase(Of TPathBased).StringValidater

                ' public methods //////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                Public Sub Add(ByVal s As String)
                    If String.IsNullOrWhiteSpace(s) Then Return
                    For Each item As String In s.Split(Validater.InvalidChars, StringSplitOptions.RemoveEmptyEntries)
                        Dim add_item As New TPathBased
                        add_item.Payload = item
                        Dim ref_item As PathBase = add_item
                        If add_item.IsNullOrWhiteSpace = False And Contains(ref_item) = False Then Payload.Add(add_item)
                    Next
                End Sub

                Public Sub Add(ByVal s As System.Collections.Generic.IEnumerable(Of String))
                    If s Is Nothing Then Return
                    For Each item As String In s
                        Add(item)
                    Next
                End Sub

                Public Sub Add(ByVal item As TPathBased)
                    If (item IsNot Nothing) AndAlso item.IsNullOrWhiteSpace = False Then Payload.Add(item)
                End Sub

                Public Sub Add(ByVal items As System.Collections.Generic.IEnumerable(Of TPathBased))
                    If items Is Nothing Then Return
                    For Each item As TPathBased In items
                        Add(item)
                    Next
                End Sub

                Public Sub Clear()
                    Payload.Clear()
                End Sub

                Public Function Contains(ByVal p As TPathBased) As Boolean
                    Dim ref As PathBase = p
                    Dim ret As Boolean = Payload.Contains(ref)
                    For Each item As TPathBased In Payload
                        If item = p Then Return True
                    Next
                    Return False
                End Function

                Public Function Count() As Integer
                    Return Payload.Count
                End Function

                Public Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
                    Return Payload.GetEnumerator
                End Function

                Public Function GetSchema() As System.Xml.Schema.XmlSchema Implements System.Xml.Serialization.IXmlSerializable.GetSchema
                    Return Nothing
                End Function

                Public Sub ReadXml(ByVal reader As System.Xml.XmlReader) Implements System.Xml.Serialization.IXmlSerializable.ReadXml
                    Clear()
                    Add(reader.ReadElementContentAsString())
                End Sub

                Public Sub Remove(ByVal s As String)
                    If String.IsNullOrWhiteSpace(s) Or Payload.Count <= 0 Then Return
                    For Each item As String In s.Split(Validater.InvalidChars, StringSplitOptions.RemoveEmptyEntries)
                        Dim remove_item As New TPathBased
                        remove_item.Payload = item
                        If remove_item.IsNullOrWhiteSpace Then Return
                        For idx As Integer = 0 To Payload.Count - 1
                            If Payload(idx) = remove_item Then
                                Payload.RemoveAt(idx)
                                Return
                            End If
                        Next
                    Next
                End Sub

                Public Function ToArray() As String()
                    If Payload.Count <= 0 Then Return Nothing
                    Dim Ret(Payload.Count - 1) As String
                    For idx As Integer = 0 To Payload.Count - 1
                        Ret(idx) = Payload(idx).ToString
                    Next
                    Return Ret
                End Function

                Public Overrides Function ToString() As String
                    If Payload.Count <= 0 Then Return Nothing
                    Return String.Join(SplitSign, Payload)
                End Function

                Public Sub WriteXml(ByVal writer As System.Xml.XmlWriter) Implements System.Xml.Serialization.IXmlSerializable.WriteXml
                    writer.WriteString(Me.ToString)
                End Sub

                ' private implements
                Private ReadOnly Payload As New System.Collections.Generic.List(Of TPathBased)

            End Class

            ' construct ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            Public Sub New()
                Me.New(Nothing)
            End Sub

            Public Sub New(ByVal s As String)
                Payload = s
            End Sub

            ' public properties ////////////////////////////////////////////////////////////////////////////////////////////////////////////

            Protected Shadows Property Payload As String
                Set(ByVal value As String)
                    MyBase.Payload = GetValidater(value)
                End Set
                Get
                    Return MyBase.Payload
                End Get
            End Property

            Public Shared Shadows ReadOnly Validater As New TStringValidater
            Public Overrides ReadOnly Property GetValidater As FileSystem.PathStringValidater
                Get
                    Return Validater
                End Get
            End Property

        End Class

    End Class
End Class

