﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class AppBase
    Partial Public Class Archive

        <Serializable()> _
        Public Class ZipOptionConfig
            Inherits ArchiveOptionConfig

            Public Const EXT As String = "zip"

            Public Shared ReadOnly CompressionLevelText As New Collections.Generic.Dictionary(Of ZipCompressionLv, String) From {
                {ZipCompressionLv.Level0, "0(無圧縮)"},
                {ZipCompressionLv.Level1, "1"},
                {ZipCompressionLv.Level2, "2"},
                {ZipCompressionLv.Level3, "3"},
                {ZipCompressionLv.Level4, "4"},
                {ZipCompressionLv.Level5, "5"},
                {ZipCompressionLv.Level6, "6"},
                {ZipCompressionLv.Level7, "7"},
                {ZipCompressionLv.Level8, "8"},
                {ZipCompressionLv.Level9, "9(高圧縮)"}
            }
            Public Shared Function GetCompressionLevel(ByRef str As String) As ZipCompressionLv
                For Each Key As ZipCompressionLv In CompressionLevelText.Keys
                    Dim Value As String = CompressionLevelText(Key)
                    If String.Equals(str, Value) Then Return Key
                Next
                Return ZipCompressionLv.Normal
            End Function

            Private _nLv As ZipCompressionLv
            Private _IgnoreExt As String
            Private _StoreExt As String

            Public Sub New()
                MyClass.New(Nothing)
            End Sub

            Public Sub New(ByRef src As ZipOptionConfig)
                _nLv = ZipCompressionLv.Normal
                _IgnoreExt = Nothing
                _StoreExt = Nothing
                If src Is Nothing Then Return
                _nLv = src._nLv
                If String.IsNullOrWhiteSpace(src._IgnoreExt) = False Then _IgnoreExt = String.Copy(src._IgnoreExt)
                If String.IsNullOrWhiteSpace(src._StoreExt) = False Then _StoreExt = String.Copy(src._StoreExt)
            End Sub

            Public Property nLv As ZipCompressionLv
                Get
                    nLv = _nLv
                End Get
                Set(ByVal value As ZipCompressionLv)
                    _nLv = Math.Min(Math.Max(value, ZipCompressionLv.None), ZipCompressionLv.BestCompress)
                End Set
            End Property

            Public Property IgnoreExt As String
                Get
                    IgnoreExt = _IgnoreExt
                End Get
                Set(ByVal value As String)
                    _IgnoreExt = Nothing
                    If Not value Is Nothing Then _IgnoreExt = New Logic.FileSystem.Extention.Collection(value).ToString
                End Set
            End Property

            Public Property StoreExt As String
                Get
                    StoreExt = _StoreExt
                End Get
                Set(ByVal value As String)
                    _StoreExt = New Logic.FileSystem.Extention.Collection(value).ToString
                End Set
            End Property


            Public ReadOnly Property SelectionCompress As String
                Get
                    Dim IgnoreExtentions() As String = New Logic.FileSystem.Extention.Collection(_IgnoreExt).ToArray
                    Dim IgnoreSelection As String = Nothing
                    If Not IgnoreExtentions Is Nothing Then IgnoreSelection = "(" & ExtJoin(IgnoreExtentions, "name != *.", " AND ") & ")"

                    Dim StoreExtentions() As String = New Logic.FileSystem.Extention.Collection(_StoreExt).ToArray
                    Dim StoreSelection As String = Nothing
                    If Not StoreSelection Is Nothing Then StoreSelection = "(" & ExtJoin(StoreExtentions, "name != *.", " AND ") & ")"

                    SelectionCompress = IgnoreSelection & IIf((IgnoreSelection Is Nothing) Or (StoreSelection Is Nothing), "", " AND ") & StoreSelection
                    If String.IsNullOrWhiteSpace(SelectionCompress) Then SelectionCompress = "*"
                End Get
            End Property

            Public ReadOnly Property SelectionStore As String
                Get
                    Dim IgnoreExtentions() As String = New Logic.FileSystem.Extention.Collection(_IgnoreExt).ToArray
                    Dim IgnoreSelection As String = Nothing
                    If Not IgnoreExtentions Is Nothing Then IgnoreSelection = "(" & ExtJoin(IgnoreExtentions, "name != *.", " AND ") & ")"

                    Dim StoreExtentions() As String = New Logic.FileSystem.Extention.Collection(_StoreExt).ToArray
                    Dim StoreSelection As String = Nothing
                    If Not StoreSelection Is Nothing Then StoreSelection = "(" & ExtJoin(StoreExtentions, "name = *.", " OR ") & ")"

                    SelectionStore = IgnoreSelection & IIf((IgnoreSelection Is Nothing) Or (StoreSelection Is Nothing), "", " AND ") & StoreSelection
                    If String.IsNullOrWhiteSpace(SelectionCompress) Then SelectionStore = "*"
                End Get
            End Property

            Public Overrides Function Extention() As Logic.FileSystem.Extention
                Return EXT
            End Function

            Public Overrides Function TextInformation() As String
                Dim AppendIgnoreExt As String = ""
                Dim AppendStoreExt As String = ""
                If String.IsNullOrWhiteSpace(_IgnoreExt) = False Then AppendIgnoreExt = " IgnoreExt=" & _IgnoreExt
                If String.IsNullOrWhiteSpace(_StoreExt) = False Then AppendStoreExt = " StoreExt=" & _StoreExt
                Return String.Format("ZIP CompressLv={0}{1}{2}", CompressionLevelText(_nLv), AppendIgnoreExt, AppendStoreExt)
            End Function

            Public Overrides Function Clone() As Object
                Return New ZipOptionConfig(Me)
            End Function

            Public Overrides Function CreateProcess(Optional ByVal AppBase As AppBase = Nothing, Optional ByVal IsStopReq As Logic.Threading.SignalHandler = Nothing) As ArchiveProcess
                Return New ZipProcess(Me, AppBase, IsStopReq)
            End Function
        End Class

    End Class
End Class

