package net.tk_factory.sample.apache.commons.lang;

import org.apache.commons.lang.StringUtils;

import junit.framework.TestCase;
import junitx.framework.ArrayAssert;

/**
 * Apache Commons LangѤץץǤ<br/>
 *
 * @author Takafumi Kondo (TK Factory)
 * @see org.apache.commons.lang.StringUtils
 */
public class TestStringUtils extends TestCase
{

    /* ====================================================================== */
    /**
     *  @see org.apache.commons.lang.StringUtils#isEmpty(String)
     */
    public void testIsEmpty()
    {
        assertTrue(
                StringUtils.isEmpty(null));
        assertTrue(
                StringUtils.isEmpty(""));
        assertFalse(
                StringUtils.isEmpty(" "));
        assertFalse(
                StringUtils.isEmpty("bob"));
        assertFalse(
                StringUtils.isEmpty("  bob  "));
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#isNotEmpty(String)
     */
    public void testIsNotEmpty()
    {
        assertFalse(
                StringUtils.isNotEmpty(null));
        assertFalse(
                StringUtils.isNotEmpty(""));
        assertTrue(
                StringUtils.isNotEmpty(" "));
        assertTrue(
                StringUtils.isNotEmpty("bob"));
        assertTrue(
                StringUtils.isNotEmpty("  bob  "));
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#isBlank(String)
     */
    public void testIsBlank()
    {
        assertTrue(
                StringUtils.isBlank(null));
        assertTrue(
                StringUtils.isBlank(""));
        assertTrue(
                StringUtils.isBlank(" "));
        assertFalse(
                StringUtils.isBlank("bob"));
        assertFalse(
                StringUtils.isBlank("  bob  "));
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#isNotBlank(String)
     */
    public void testIsNotBlank()
    {
        assertFalse(
                StringUtils.isNotBlank(null));
        assertFalse(
                StringUtils.isNotBlank(""));
        assertFalse(
                StringUtils.isNotBlank(" "));
        assertTrue(
                StringUtils.isNotBlank("bob"));
        assertTrue(
                StringUtils.isNotBlank("  bob  "));
    }

    /* ====================================================================== */
    /**
     *  @see org.apache.commons.lang.StringUtils#trim(String)
     */
    public void testTrim()
    {
        assertEquals(
                StringUtils.trim(null),
                null);
        assertEquals(
                StringUtils.trim(""),
                "");
        assertEquals(
                StringUtils.trim("     "),
                "");
        assertEquals(
                StringUtils.trim("abc"),
                "abc");
        assertEquals(
                StringUtils.trim("    abc    "),
                "abc");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#trimToNull(String)
     */
    public void testTrimToNull()
    {
        assertEquals(
                StringUtils.trimToNull(null),
                null);
        assertEquals(
                StringUtils.trimToNull(""),
                null);
        assertEquals(
                StringUtils.trimToNull("     "),
                null);
        assertEquals(
                StringUtils.trimToNull("abc"),
                "abc");
        assertEquals(
                StringUtils.trimToNull("    abc    "),
                "abc");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#trimToEmpty(String)
     */
    public void testTrimToEmpty()
    {
        assertEquals(
                StringUtils.trimToEmpty(null),
                "");
        assertEquals(
                StringUtils.trimToEmpty(""),
                "");
        assertEquals(
                StringUtils.trimToEmpty("     "),
                "");
        assertEquals(
                StringUtils.trimToEmpty("abc"),
                "abc");
        assertEquals(
                StringUtils.trimToEmpty("    abc    "),
                "abc");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#strip(String)
     */
    public void testStrip1()
    {
        assertEquals(
                StringUtils.strip(null),
                null);
        assertEquals(
                StringUtils.strip(""),
                "");
        assertEquals(
                StringUtils.strip("   "),
                "");
        assertEquals(
                StringUtils.strip("abc"),
                "abc");
        assertEquals(
                StringUtils.strip("  abc"),
                "abc");
        assertEquals(
                StringUtils.strip("abc  "),
                "abc");
        assertEquals(
                StringUtils.strip(" abc "),
                "abc");
        assertEquals(
                StringUtils.strip(" ab c "),
                "ab c");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#stripToNull(String)
     */
    public void testStripToNull()
    {
        assertEquals(
                StringUtils.stripToNull(null),
                null);
        assertEquals(
                StringUtils.stripToNull(""),
                null);
        assertEquals(
                StringUtils.stripToNull("   "),
                null);
        assertEquals(
                StringUtils.stripToNull("abc"),
                "abc");
        assertEquals(
                StringUtils.stripToNull("  abc"),
                "abc");
        assertEquals(
                StringUtils.stripToNull("abc  "),
                "abc");
        assertEquals(
                StringUtils.stripToNull(" abc "),
                "abc");
        assertEquals(
                StringUtils.stripToNull(" ab c "),
                "ab c");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#stripToEmpty(String)
     */
    public void testStripToEmpty()
    {
        assertEquals(
                StringUtils.stripToEmpty(null),
                "");
        assertEquals(
                StringUtils.stripToEmpty(""),
                "");
        assertEquals(
                StringUtils.stripToEmpty("   "),
                "");
        assertEquals(
                StringUtils.stripToEmpty("abc"),
                "abc");
        assertEquals(
                StringUtils.stripToEmpty("  abc"),
                "abc");
        assertEquals(
                StringUtils.stripToEmpty("abc  "),
                "abc");
        assertEquals(
                StringUtils.stripToEmpty(" abc "),
                "abc");
        assertEquals(
                StringUtils.stripToEmpty(" ab c "),
                "ab c");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#strip(String, String)
     */
    public void testStrip2()
    {
        assertEquals(
                StringUtils.strip(null, "xyz"),
                null);
        assertEquals(
                StringUtils.strip("", "xyz"),
                "");
        assertEquals(
                StringUtils.strip("abc", null),
                "abc");
        assertEquals(
                StringUtils.strip("  abc", null),
                "abc");
        assertEquals(
                StringUtils.strip("abc  ", null),
                "abc");
        assertEquals(
                StringUtils.strip(" abc ", null),
                "abc");
        assertEquals(
                StringUtils.strip("  abcyx", "xyz"),
                "  abc");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#stripStart(String, String)
     */
    public void testStripStart()
    {
        assertEquals(
                StringUtils.stripStart(null, "xyz"),
                null);
        assertEquals(
                StringUtils.stripStart("", "xyz"),
                "");
        assertEquals(
                StringUtils.stripStart("abc", ""),
                "abc");
        assertEquals(
                StringUtils.stripStart("abc", null),
                "abc");
        assertEquals(
                StringUtils.stripStart("  abc", null),
                "abc");
        assertEquals(
                StringUtils.stripStart("abc  ", null),
                "abc  ");
        assertEquals(
                StringUtils.stripStart(" abc ", null),
                "abc ");
        assertEquals(
                StringUtils.stripStart("yxabc  ", "xyz"),
                "abc  ");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#stripEnd(String, String)
     */
    public void testStripEnd()
    {
        assertEquals(
                StringUtils.stripEnd(null, "xyz"),
                null);
        assertEquals(
                StringUtils.stripEnd("", "xyz"),
                "");
        assertEquals(
                StringUtils.stripEnd("abc", ""),
                "abc");
        assertEquals(
                StringUtils.stripEnd("abc", null),
                "abc");
        assertEquals(
                StringUtils.stripEnd("  abc", null),
                "  abc");
        assertEquals(
                StringUtils.stripEnd("abc  ", null),
                "abc");
        assertEquals(
                StringUtils.stripEnd(" abc ", null),
                " abc");
        assertEquals(
                StringUtils.stripEnd("  abcyx", "xyz"),
                "  abc");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#stripAll(String[])
     */
    public void testStripAll1()
    {
        final String[] strs = null;
        ArrayAssert.assertEquals(
                StringUtils.stripAll(strs),
                null);
        ArrayAssert.assertEquals(
                StringUtils.stripAll(new String[]{}),
                new String[]{});
        ArrayAssert.assertEquals(
                StringUtils.stripAll(new String[]{"abc", "  abc"}),
                new String[]{"abc", "abc"});
        ArrayAssert.assertEquals(
                StringUtils.stripAll(new String[]{"abc  ", null}),
                new String[]{"abc", null});
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#stripAll(String[], String)
     */
    public void testStripAll2()
    {
        final String[] strs = null;
        ArrayAssert.assertEquals(
                StringUtils.stripAll(strs, "abc"),
                null);
        ArrayAssert.assertEquals(
                StringUtils.stripAll(new String[]{}, "abc"),
                new String[]{});
        ArrayAssert.assertEquals(
                StringUtils.stripAll(new String[]{"abc", "  abc"}, null),
                new String[]{"abc", "abc"});
        ArrayAssert.assertEquals(
                StringUtils.stripAll(new String[]{"abc  ", null}, null),
                new String[]{"abc", null});
        ArrayAssert.assertEquals(
                StringUtils.stripAll(new String[]{"abc  ", null}, "yz"),
                new String[]{"abc  ", null});
        ArrayAssert.assertEquals(
                StringUtils.stripAll(new String[]{"yabcz", null}, "yz"),
                new String[]{"abc", null});
    }

    /* ====================================================================== */
    /**
     *  @see org.apache.commons.lang.StringUtils#equals(String, String)
     */
    public void testEquals()
    {
        assertTrue(
                StringUtils.equals(null, null));
        assertFalse(
                StringUtils.equals(null, "abc"));
        assertFalse(
                StringUtils.equals("abc", null));
        assertTrue(
                StringUtils.equals("abc", "abc"));
        assertFalse(
                StringUtils.equals("abc", "ABC"));
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#equalsIgnoreCase(String, String)
     */
    public void testEqualsIgnoreCase()
    {
        assertTrue(
                StringUtils.equalsIgnoreCase(null, null));
        assertFalse(
                StringUtils.equalsIgnoreCase(null, "abc"));
        assertFalse(
                StringUtils.equalsIgnoreCase("abc", null));
        assertTrue(
                StringUtils.equalsIgnoreCase("abc", "abc"));
        assertTrue(
                StringUtils.equalsIgnoreCase("abc", "ABC"));
    }

    /* ====================================================================== */
    /**
     *  @see org.apache.commons.lang.StringUtils#startsWith(String, String)
     */
    public void testStartsWith()
    {
        assertTrue(
                StringUtils.startsWith(null, null));
        assertFalse(
                StringUtils.startsWith(null, "abc"));
        assertFalse(
                StringUtils.startsWith("abcdef", null));
        assertTrue(
                StringUtils.startsWith("abcdef", "abc"));
        assertFalse(
                StringUtils.startsWith("ABCDEF", "abc"));
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#startsWithIgnoreCase(String, String)
     */
    public void testStartsWithIgnoreCase()
    {
        assertTrue(
                StringUtils.startsWithIgnoreCase(null, null));
        assertFalse(
                StringUtils.startsWithIgnoreCase(null, "abc"));
        assertFalse(
                StringUtils.startsWithIgnoreCase("abcdef", null));
        assertTrue(
                StringUtils.startsWithIgnoreCase("abcdef", "abc"));
        assertTrue(
                StringUtils.startsWithIgnoreCase("ABCDEF", "abc"));
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#endsWith(String, String)
     */
    public void testEndsWith()
    {
        assertTrue(
                StringUtils.endsWith(null, null));
        assertFalse(
                StringUtils.endsWith(null, "def"));
        assertFalse(
                StringUtils.endsWith("abcdef", null));
        assertTrue(
                StringUtils.endsWith("abcdef", "def"));
        assertFalse(
                StringUtils.endsWith("ABCDEF", "def"));
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#endsWithIgnoreCase(String, String)
     */
    public void testEndsWithIgnoreCase()
    {
        assertTrue(
                StringUtils.endsWithIgnoreCase(null, null));
        assertFalse(
                StringUtils.endsWithIgnoreCase(null, "def"));
        assertFalse(
                StringUtils.endsWithIgnoreCase("abcdef", null));
        assertTrue(
                StringUtils.endsWithIgnoreCase("abcdef", "def"));
        assertTrue(
                StringUtils.endsWithIgnoreCase("ABCDEF", "def"));
    }

    /* ====================================================================== */
    /**
     *  @see org.apache.commons.lang.StringUtils#indexOf(String, char)
     */
    public void testIndexOf1()
    {
        assertEquals(
                StringUtils.indexOf(null, 'a'),
                -1);
        assertEquals(
                StringUtils.indexOf("", 'a'),
                -1);
        assertEquals(
                StringUtils.indexOf("aabaabaa", 'a'),
                0);
        assertEquals(
                StringUtils.indexOf("aabaabaa", 'b'),
                2);
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#indexOf(String, char, int)
     */
    public void testIndexOf2()
    {
        assertEquals(
                StringUtils.indexOf(null, 'b', 0),
                -1);
        assertEquals(
                StringUtils.indexOf("", 'b', 0),
                -1);
        assertEquals(
                StringUtils.indexOf("aabaabaa", 'b', 0),
                2);
        assertEquals(
                StringUtils.indexOf("aabaabaa", 'b', 3),
                5);
        assertEquals(
                StringUtils.indexOf("aabaabaa", 'b', 9),
                -1);
        assertEquals(
                StringUtils.indexOf("aabaabaa", 'b', -1),
                2);
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#indexOf(String, String)
     */
    public void testIndexOf3()
    {
        assertEquals(
                StringUtils.indexOf(null, "a"),
                -1);
        assertEquals(
                StringUtils.indexOf("aabaabaa", null),
                -1);
        assertEquals(
                StringUtils.indexOf("", ""),
                0);
        assertEquals(
                StringUtils.indexOf("aabaabaa", "a"),
                0);
        assertEquals(
                StringUtils.indexOf("aabaabaa", "b"),
                2);
        assertEquals(
                StringUtils.indexOf("aabaabaa", "ab"),
                1);
        assertEquals(
                StringUtils.indexOf("aabaabaa", ""),
                0);
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#indexOf(String, String, int)
     */
    public void testIndexOf4()
    {
        assertEquals(
                StringUtils.indexOf(null, "a", 0),
                -1);
        assertEquals(
                StringUtils.indexOf("aabaabaa", null, 0),
                -1);
        assertEquals(
                StringUtils.indexOf("", "", 0),
                0);
        assertEquals(
                StringUtils.indexOf("aabaabaa", "a", 0),
                0);
        assertEquals(
                StringUtils.indexOf("aabaabaa", "b", 0),
                2);
        assertEquals(
                StringUtils.indexOf("aabaabaa", "ab", 0),
                1);
        assertEquals(
                StringUtils.indexOf("aabaabaa", "b", 3),
                5);
        assertEquals(
                StringUtils.indexOf("aabaabaa", "b", 9),
                -1);
        assertEquals(
                StringUtils.indexOf("aabaabaa", "b", -1),
                2);
        assertEquals(
                StringUtils.indexOf("aabaabaa", "", 2),
                2);
        assertEquals(
                StringUtils.indexOf("abc", "", 9),
                3);
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#lastIndexOf(String, char)
     */
    public void testLastIndexOf1()
    {
        assertEquals(
                StringUtils.lastIndexOf(null, 'a'),
                -1);
        assertEquals(
                StringUtils.lastIndexOf("", 'a'),
                -1);
        assertEquals(
                StringUtils.lastIndexOf("aabaabaa", 'a'),
                7);
        assertEquals(
                StringUtils.lastIndexOf("aabaabaa", 'b'),
                5);
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#lastIndexOf(String, char, int)
     */
    public void testLastIndexOf2()
    {
        assertEquals(
                StringUtils.lastIndexOf(null, 'b', 0),
                -1);
        assertEquals(
                StringUtils.lastIndexOf("", 'b',  0),
                -1);
        assertEquals(
                StringUtils.lastIndexOf("aabaabaa", 'b', 8 ),
                5);
        assertEquals(
                StringUtils.lastIndexOf("aabaabaa", 'b', 4),
                2);
        assertEquals(
                StringUtils.lastIndexOf("aabaabaa", 'b', 0),
                -1);
        assertEquals(
                StringUtils.lastIndexOf("aabaabaa", 'b', 9),
                5);
        assertEquals(
                StringUtils.lastIndexOf("aabaabaa", 'b', -1),
                -1);
        assertEquals(
                StringUtils.lastIndexOf("aabaabaa", 'a', 0),
                0);
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#lastIndexOf(String, String)
     */
    public void testLastIndexOf3()
    {
        assertEquals(
                StringUtils.lastIndexOf(null, "a"),
                -1);
        assertEquals(
                StringUtils.lastIndexOf("aabaabaa", null),
                -1);
        assertEquals(
                StringUtils.lastIndexOf("", ""),
                0);
        assertEquals(
                StringUtils.lastIndexOf("aabaabaa", "a"),
                7);
        assertEquals(
                StringUtils.lastIndexOf("aabaabaa", "b"),
                5);
        assertEquals(
                StringUtils.lastIndexOf("aabaabaa", "ab"),
                4);
        assertEquals(
                StringUtils.lastIndexOf("aabaabaa", ""),
                8);
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#lastIndexOf(String, String, int)
     */
    public void testLastIndexOf4()
    {
        assertEquals(
                StringUtils.lastIndexOf(null, "a", 0),
                -1);
        assertEquals(
                StringUtils.lastIndexOf("aabaabaa", null, 0),
                -1);
        assertEquals(
                StringUtils.lastIndexOf("aabaabaa", "a", 8 ),
                7);
        assertEquals(
                StringUtils.lastIndexOf("aabaabaa", "b", 8 ),
                5);
        assertEquals(
                StringUtils.lastIndexOf("aabaabaa", "ab", 8 ),
                4);
        assertEquals(
                StringUtils.lastIndexOf("aabaabaa", "b", 9),
                5);
        assertEquals(
                StringUtils.lastIndexOf("aabaabaa", "b", -1),
                -1);
        assertEquals(
                StringUtils.lastIndexOf("aabaabaa", "a", 0),
                0);
        assertEquals(
                StringUtils.lastIndexOf("aabaabaa", "b", 0),
                -1);
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#contains(String, char)
     */
    public void testContains1()
    {
        assertFalse(
                StringUtils.contains(null, 'a'));
        assertFalse(
                StringUtils.contains("", 'a'));
        assertTrue(
                StringUtils.contains("abc", 'a'));
        assertFalse(
                StringUtils.contains("abc", 'z'));
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#contains(String, String)
     */
    public void testContains2()
    {
        assertFalse(
                StringUtils.contains(null, "a"));
        assertFalse(
                StringUtils.contains("abc", null));
        assertTrue(
                StringUtils.contains("", ""));
        assertTrue(
                StringUtils.contains("abc", ""));
        assertTrue(
                StringUtils.contains("abc", "a"));
        assertFalse(
                StringUtils.contains("abc", "z"));
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#containsIgnoreCase(String, String)
     */
    public void testContainsIgnoreCase()
    {
        assertFalse(
                StringUtils.containsIgnoreCase(null, "a"));
        assertFalse(
                StringUtils.containsIgnoreCase("abc", null));
        assertTrue(
                StringUtils.containsIgnoreCase("", ""));
        assertTrue(
                StringUtils.containsIgnoreCase("abc", ""));
        assertTrue(
                StringUtils.containsIgnoreCase("abc", "a"));
        assertFalse(
                StringUtils.containsIgnoreCase("abc", "z"));
        assertTrue(
                StringUtils.containsIgnoreCase("abc", "A"));
        assertFalse(
                StringUtils.containsIgnoreCase("abc", "Z"));
    }

    /* ====================================================================== */
    /**
     *  @see org.apache.commons.lang.StringUtils#indexOfAny(String, char[])
     */
    public void testIndexOfAny1()
    {
        assertEquals(
                StringUtils.indexOfAny(null, new char[]{'z', 'a'}),
                -1);
        assertEquals(
                StringUtils.indexOfAny("", new char[]{'z', 'a'}),
                -1);
        final char[] searchChars = null;
        assertEquals(
                StringUtils.indexOfAny("zzabyycdxx", searchChars),
                -1);
        assertEquals(
                StringUtils.indexOfAny("zzabyycdxx", new char[]{}),
                -1);
        assertEquals(
                StringUtils.indexOfAny("zzabyycdxx", new char[]{'z', 'a'}),
                0);
        assertEquals(
                StringUtils.indexOfAny("zzabyycdxx", new char[]{'b', 'y'}),
                3);
        assertEquals(
                StringUtils.indexOfAny("aba", new char[]{'z'}),
                -1);
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#indexOfAny(String, String)
     */
    public void testIndexOfAny2()
    {
        assertEquals(
                StringUtils.indexOfAny(null, "ab"),
                -1);
        assertEquals(
                StringUtils.indexOfAny("", "ab"),
                -1);
        assertEquals(
                StringUtils.indexOfAny("zzabyycdxx", (String) null),
                -1);
        assertEquals(
                StringUtils.indexOfAny("zzabyycdxx", ""),
                -1);
        assertEquals(
                StringUtils.indexOfAny("zzabyycdxx", "za"),
                0);
        assertEquals(
                StringUtils.indexOfAny("zzabyycdxx", "by"),
                3);
        assertEquals(
                StringUtils.indexOfAny("aba", "z"),
                -1);
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#indexOfAny(String, String[])
     */
    public void testIndexOfAny3()
    {
        assertEquals(
                StringUtils.indexOfAny(null, new String[]{"ab", "cd"}),
                -1);
        final String[] searchChars = null;
        assertEquals(
                StringUtils.indexOfAny("zzabyycdxx", searchChars),
                -1);
        assertEquals(
                StringUtils.indexOfAny("zzabyycdxx", new String[]{}),
                -1);
        assertEquals(
                StringUtils.indexOfAny("zzabyycdxx", new String[]{"ab", "cd"}),
                2);
        assertEquals(
                StringUtils.indexOfAny("zzabyycdxx", new String[]{"cd", "ab"}),
                2);
        assertEquals(
                StringUtils.indexOfAny("zzabyycdxx", new String[]{"mn", "op"}),
                -1);
        assertEquals(
                StringUtils.indexOfAny("zzabyycdxx", new String[]{"zab", "aby"}),
                1);
        assertEquals(
                StringUtils.indexOfAny("zzabyycdxx", new String[]{""}),
                0);
        assertEquals(
                StringUtils.indexOfAny("", new String[]{""}),
                0);
        assertEquals(
                StringUtils.indexOfAny("", new String[]{"a"}),
                -1);
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#indexOfAnyBut(String, char[])
     */
    public void testIndexOfAnyBut1()
    {
        assertEquals(
                StringUtils.indexOfAnyBut(null, new char[]{'z', 'a'}),
                -1);
        assertEquals(
                StringUtils.indexOfAnyBut("", new char[]{'z', 'a'}),
                -1);
        final char[] searchChars = null;
        assertEquals(
                StringUtils.indexOfAnyBut("zzabyycdxx", searchChars),
                -1);
        assertEquals(
                StringUtils.indexOfAnyBut("zzabyycdxx", new char[]{}),
                -1);
        assertEquals(
                StringUtils.indexOfAnyBut("zzabyycdxx", new char[]{'z', 'a'}),
                3);
        assertEquals(
                StringUtils.indexOfAnyBut("zzabyycdxx", new char[]{' '}),
                0);
        assertEquals(
                StringUtils.indexOfAnyBut("aba", new char[]{'a', 'b'}),
                -1);
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#indexOfAnyBut(String, String)
     */
    public void testIndexOfAnyBut2()
    {
        assertEquals(
                StringUtils.indexOfAnyBut(null, "ab"),
                -1);
        assertEquals(
                StringUtils.indexOfAnyBut("", "ab"),
                -1);
        assertEquals(
                StringUtils.indexOfAnyBut("zzabyycdxx", (String)null),
                -1);
        assertEquals(
                StringUtils.indexOfAnyBut("zzabyycdxx", ""),
                -1);
        assertEquals(
                StringUtils.indexOfAnyBut("zzabyycdxx", "za"),
                3);
        assertEquals(
                StringUtils.indexOfAnyBut("aba", "ab"),
                -1);
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#lastIndexOfAny(String, String[])
     */
    public void testLastIndexOfAny()
    {
        assertEquals(
                StringUtils.lastIndexOfAny(null, new String[]{"ab", "cd"}),
                -1);
        final String[] searchChars = null;
        assertEquals(
                StringUtils.lastIndexOfAny("zzabyycdxx", searchChars),
                -1);
        assertEquals(
                StringUtils.lastIndexOfAny("zzabyycdxx", new String[]{}),
                -1);
        assertEquals(
                StringUtils.lastIndexOfAny("zzabyycdxx", new String[]{null}),
                -1);
        assertEquals(
                StringUtils.lastIndexOfAny("zzabyycdxx", new String[]{"ab", "cd"}),
                6);
        assertEquals(
                StringUtils.lastIndexOfAny("zzabyycdxx", new String[]{"cd", "ab"}),
                6);
        assertEquals(
                StringUtils.lastIndexOfAny("zzabyycdxx", new String[]{"mn", "op"}),
                -1);
        assertEquals(
                StringUtils.lastIndexOfAny("zzabyycdxx", new String[]{"mn", ""}),
                10);
    }

    /* ====================================================================== */
    /**
     *  @see org.apache.commons.lang.StringUtils#containsOnly(String, char[])
     */
    public void testContainsOnly1()
    {
        assertFalse(
                StringUtils.containsOnly(null, new char[]{'a', 'b'}));
        final char[] validChars = null;
        assertFalse(
                StringUtils.containsOnly("ab", validChars));
        assertTrue(
                StringUtils.containsOnly("", new char[]{'a', 'b'}));
        assertFalse(
                StringUtils.containsOnly("ab", new char[]{}));
        assertTrue(
                StringUtils.containsOnly("abab", new char[]{'a', 'b'}));
        assertFalse(
                StringUtils.containsOnly("ab1", new char[]{'a', 'b', 'c'}));
        assertFalse(
                StringUtils.containsOnly("abz", new char[]{'a', 'b', 'c'}));
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#containsOnly(String, String)
     */
    public void testContainsOnly2()
    {
        assertFalse(
                StringUtils.containsOnly(null, "ab"));
        assertFalse(
                StringUtils.containsOnly("ab", (String) null));
        assertTrue(
                StringUtils.containsOnly("", "ab"));
        assertFalse(
                StringUtils.containsOnly("ab", ""));
        assertTrue(
                StringUtils.containsOnly("abab", "ab"));
        assertFalse(
                StringUtils.containsOnly("ab1", "abc"));
        assertFalse(
                StringUtils.containsOnly("abz", "abc"));
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#containsNone(String, char[])
     */
    public void testContainsNone1()
    {
        assertTrue(
                StringUtils.containsNone(null, new char[]{'x', 'y'}));
        final char[] invalidChars = null;
        assertTrue(
                StringUtils.containsNone("xy", invalidChars));
        assertTrue(
                StringUtils.containsNone("", new char[]{'x', 'y'}));
        assertTrue(
                StringUtils.containsNone("ab", new char[]{}));
        assertTrue(
                StringUtils.containsNone("abab", new char[]{'x', 'y', 'z'}));
        assertTrue(
                StringUtils.containsNone("ab1", new char[]{'x', 'y', 'z'}));
        assertFalse(
                StringUtils.containsNone("xyz", new char[]{'x', 'y', 'z'}));
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#containsNone(String, String)
     */
    public void testContainsNone2()
    {
        assertTrue(
                StringUtils.containsNone(null, "xy"));
        assertTrue(
                StringUtils.containsNone("ab", (String) null));
        assertTrue(
                StringUtils.containsNone("", "xy"));
        assertTrue(
                StringUtils.containsNone("ab", ""));
        assertTrue(
                StringUtils.containsNone("abab", "xyz"));
        assertTrue(
                StringUtils.containsNone("ab1", "xyz"));
        assertFalse(
                StringUtils.containsNone("abz", "xyz"));
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#containsAny(String, char[])
     */
    public void testContainsAny1()
    {
        assertFalse(
                StringUtils.containsAny(null, new char[]{'a', 'b'}));
        assertFalse(
                StringUtils.containsAny("", new char[]{'a', 'b'}));
        final char[] searchChars = null;
        assertFalse(
                StringUtils.containsAny("zzabyycdxx", searchChars));
        assertFalse(
                StringUtils.containsAny("zzabyycdxx", new char[]{}));
        assertTrue(
                StringUtils.containsAny("zzabyycdxx", new char[]{'z', 'a'}));
        assertTrue(
                StringUtils.containsAny("zzabyycdxx", new char[]{'b', 'y'}));
        assertFalse(
                StringUtils.containsAny("aba", new char[]{'z'}));
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#containsAny(String, String)
     */
    public void testContainsAny2()
    {
        assertFalse(
                StringUtils.containsAny(null, "ab"));
        assertFalse(
                StringUtils.containsAny("", "ab"));
        assertFalse(
                StringUtils.containsAny("zzabyycdxx", (String) null));
        assertFalse(
                StringUtils.containsAny("zzabyycdxx", ""));
        assertTrue(
                StringUtils.containsAny("zzabyycdxx", "za"));
        assertTrue(
                StringUtils.containsAny("zzabyycdxx", "by"));
        assertFalse(
                StringUtils.containsAny("aba", "z"));
    }

    /* ====================================================================== */
    /**
     *  @see org.apache.commons.lang.StringUtils#length(String)
     */
    public void testLength ()
    {
        assertEquals(
                StringUtils.length(null),
                0);
        assertEquals(
                StringUtils.length(""),
                0);
        assertEquals(
                StringUtils.length("abc"),
                3);
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#substring(String, int)
     */
    public void testSubstring1()
    {
        assertEquals(
                StringUtils.substring(null, 0),
                null);
        assertEquals(
                StringUtils.substring("", 0),
                "");
        assertEquals(
                StringUtils.substring("abc", 0),
                "abc");
        assertEquals(
                StringUtils.substring("abc", 2),
                "c");
        assertEquals(
                StringUtils.substring("abc", 4),
                "");
        assertEquals(
                StringUtils.substring("abc", -2),
                "bc");
        assertEquals(
                StringUtils.substring("abc", -4),
                "abc");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#substring(String, int, int)
     */
    public void testSubstring2()
    {
        assertEquals(
                StringUtils.substring(null, 0, 1),
                null);
        assertEquals(
                StringUtils.substring("", 0 ,  1),
                "");
        assertEquals(
                StringUtils.substring("abc", 0, 2),
                "ab");
        assertEquals(
                StringUtils.substring("abc", 2, 0),
                "");
        assertEquals(
                StringUtils.substring("abc", 2, 4),
                "c");
        assertEquals(
                StringUtils.substring("abc", 4, 6),
                "");
        assertEquals(
                StringUtils.substring("abc", 2, 2),
                "");
        assertEquals(
                StringUtils.substring("abc", -2, -1),
                "b");
        assertEquals(
                StringUtils.substring("abc", -4, 2),
                "ab");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#left(String, int)
     */
    public void testLeft()
    {
        assertEquals(
                StringUtils.left(null, 0),
                null);
        assertEquals(
                StringUtils.left("abc", -10),
                "");
        assertEquals(
                StringUtils.left("", 1),
                "");
        assertEquals(
                StringUtils.left("abc", 0),
                "");
        assertEquals(
                StringUtils.left("abc", 2),
                "ab");
        assertEquals(
                StringUtils.left("abc", 4),
                "abc");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#right(String, int)
     */
    public void testRight()
    {
        assertEquals(
                StringUtils.right(null, 0),
                null);
        assertEquals(
                StringUtils.right("abc", -10),
                "");
        assertEquals(
                StringUtils.right("", 1),
                "");
        assertEquals(
                StringUtils.right("abc", 0),
                "");
        assertEquals(
                StringUtils.right("abc", 2),
                "bc");
        assertEquals(
                StringUtils.right("abc", 4),
                "abc");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#mid(String, int, int)
     */
    public void testMid()
    {
        assertEquals(
                StringUtils.mid(null, 0, 2),
                null);
        assertEquals(
                StringUtils.mid("abc", 0, -10),
                "");
        assertEquals(
                StringUtils.mid("", 0, 2),
                "");
        assertEquals(
                StringUtils.mid("abc", 0, 2),
                "ab");
        assertEquals(
                StringUtils.mid("abc", 0, 4),
                "abc");
        assertEquals(
                StringUtils.mid("abc", 2, 4),
                "c");
        assertEquals(
                StringUtils.mid("abc", 4, 2),
                "");
        assertEquals(
                StringUtils.mid("abc", -2, 2),
                "ab");
    }

    /* ====================================================================== */
    /**
     *  @see org.apache.commons.lang.StringUtils#substringBefore(String, String)
     */
    public void testSubstringBefore()
    {
        assertEquals(
                StringUtils.substringBefore(null, "a"),
                null);
        assertEquals(
                StringUtils.substringBefore("", "a"),
                "");
        assertEquals(
                StringUtils.substringBefore("abc", "a"),
                "");
        assertEquals(
                StringUtils.substringBefore("abcba", "b"),
                "a");
        assertEquals(
                StringUtils.substringBefore("abc", "c"),
                "ab");
        assertEquals(
                StringUtils.substringBefore("abc", "d"),
                "abc");
        assertEquals(
                StringUtils.substringBefore("abc", ""),
                "");
        assertEquals(
                StringUtils.substringBefore("abc", null),
                "abc");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#substringAfter(String, String)
     */
    public void testSubstringAfter()
    {
        assertEquals(
                StringUtils.substringAfter(null, "a"),
                null);
        assertEquals(
                StringUtils.substringAfter("", "a"),
                "");
        assertEquals(
                StringUtils.substringAfter("abc", "a"),
                "bc");
        assertEquals(
                StringUtils.substringAfter("abcba", "b"),
                "cba");
        assertEquals(
                StringUtils.substringAfter("abc", "c"),
                "");
        assertEquals(
                StringUtils.substringAfter("abc", "d"),
                "");
        assertEquals(
                StringUtils.substringAfter("abc", ""),
                "abc");
        assertEquals(
                StringUtils.substringAfter("abc", null),
                "");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#substringBeforeLast(String, String)
     */
    public void testSubstringBeforeLast()
    {
        assertEquals(
                StringUtils.substringBeforeLast(null, "a"),
                null);
        assertEquals(
                StringUtils.substringBeforeLast("", "a"),
                "");
        assertEquals(
                StringUtils.substringBeforeLast("abcba", "b"),
                "abc");
        assertEquals(
                StringUtils.substringBeforeLast("abc", "c"),
                "ab");
        assertEquals(
                StringUtils.substringBeforeLast("a", "a"),
                "");
        assertEquals(
                StringUtils.substringBeforeLast("a", "z"),
                "a");
        assertEquals(
                StringUtils.substringBeforeLast("a", ""),
                "a");
        assertEquals(
                StringUtils.substringBeforeLast("a", null),
                "a");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#substringAfterLast(String, String)
     */
    public void testSubstringAfterLast()
    {
        assertEquals(
                StringUtils.substringAfterLast(null, "a"),
                null);
        assertEquals(
                StringUtils.substringAfterLast("", "a"),
                "");
        assertEquals(
                StringUtils.substringAfterLast("abc", "a"),
                "bc");
        assertEquals(
                StringUtils.substringAfterLast("abcba", "b"),
                "a");
        assertEquals(
                StringUtils.substringAfterLast("abc", "c"),
                "");
        assertEquals(
                StringUtils.substringAfterLast("a", "a"),
                "");
        assertEquals(
                StringUtils.substringAfterLast("a", "z"),
                "");
        assertEquals(
                StringUtils.substringAfterLast("a", ""),
                "");
        assertEquals(
                StringUtils.substringAfterLast("a", null),
                "");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#substringBetween(String, String)
     */
    public void testSubstringBetween1()
    {
        assertEquals(
                StringUtils.substringBetween(null, "tag"),
                null);
        assertEquals(
                StringUtils.substringBetween("", ""),
                "");
        assertEquals(
                StringUtils.substringBetween("", "tag"),
                null);
        assertEquals(
                StringUtils.substringBetween("tagabctag", null),
                null);
        assertEquals(
                StringUtils.substringBetween("tagabctag", ""),
                "");
        assertEquals(
                StringUtils.substringBetween("tagabctag", "tag"),
                "abc");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#substringBetween(String, String, String)
     */
    public void testSubstringBetween2()
    {
        assertEquals(
                StringUtils.substringBetween("wx[b]yz", "[", "]"),
                "b");
        assertEquals(
                StringUtils.substringBetween(null, "y", "z"),
                null);
        assertEquals(
                StringUtils.substringBetween("wx[b]yz", null, "]"),
                null);
        assertEquals(
                StringUtils.substringBetween("wx[b]yz", "[", null),
                null);
        assertEquals(
                StringUtils.substringBetween("", "", ""),
                "");
        assertEquals(
                StringUtils.substringBetween("", "", "]"),
                null);
        assertEquals(
                StringUtils.substringBetween("", "[", "]"),
                null);
        assertEquals(
                StringUtils.substringBetween("yabcz", "", ""),
                "");
        assertEquals(
                StringUtils.substringBetween("yabcz", "y", "z"),
                "abc");
        assertEquals(
                StringUtils.substringBetween("yabczyabcz", "y", "z"),
                "abc");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#substringsBetween(String, String, String)
     */
    public void testSubstringsBetween()
    {
        ArrayAssert.assertEquals(
                StringUtils.substringsBetween("[a][b][c]", "[", "]"),
                new String[]{"a", "b", "c"});
        ArrayAssert.assertEquals(
                StringUtils.substringsBetween(null, "[", "]"),
                null);
        ArrayAssert.assertEquals(
                StringUtils.substringsBetween("[a][b][c]", null, "]"),
                null);
        ArrayAssert.assertEquals(
                StringUtils.substringsBetween("[a][b][c]", "[", null),
                null);
        ArrayAssert.assertEquals(
                StringUtils.substringsBetween("", "[", "]"),
                new String[]{});
        ArrayAssert.assertEquals(
                StringUtils.substringsBetween("[a][b][c]", "", "]"),
                null);
        ArrayAssert.assertEquals(
                StringUtils.substringsBetween("[a][b][c]", "[", ""),
                null);
    }

    /* ====================================================================== */
    /**
     *  @see org.apache.commons.lang.StringUtils#split(String)
     */
    public void testSplit1()
    {
        ArrayAssert.assertEquals(
                StringUtils.split(null),
                null);
        ArrayAssert.assertEquals(
                StringUtils.split(""),
                new String[]{});
        ArrayAssert.assertEquals(
                StringUtils.split("abc def"),
                new String[]{"abc", "def"});
        ArrayAssert.assertEquals(
                StringUtils.split("abc  def"),
                new String[]{"abc", "def"});
        ArrayAssert.assertEquals(
                StringUtils.split(" abc "),
                new String[]{"abc"});
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#split(String, char)
     */
    public void testSplit2()
    {
        ArrayAssert.assertEquals(
                StringUtils.split(null, ','),
                null);
        ArrayAssert.assertEquals(
                StringUtils.split("", ','),
                new String[]{});
        ArrayAssert.assertEquals(
                StringUtils.split("a.b.c", '.'),
                new String[]{"a", "b", "c"});
        ArrayAssert.assertEquals(
                StringUtils.split("a..b.c", '.'),
                new String[]{"a", "b", "c"});
        ArrayAssert.assertEquals(
                StringUtils.split("a:b:c", '.'),
                new String[]{"a:b:c"});
        ArrayAssert.assertEquals(
                StringUtils.split("a b c", ' '),
                new String[]{"a", "b", "c"});
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#split(String, String)
     */
    public void testSplit3()
    {
        ArrayAssert.assertEquals(
                StringUtils.split(null, ","),
                null);
        ArrayAssert.assertEquals(
                StringUtils.split("", ","),
                new String[]{});
        ArrayAssert.assertEquals(
                StringUtils.split("abc def", null),
                new String[]{"abc", "def"});
        ArrayAssert.assertEquals(
                StringUtils.split("abc def", " "),
                new String[]{"abc", "def"});
        ArrayAssert.assertEquals(
                StringUtils.split("abc  def", " "),
                new String[]{"abc", "def"});
        ArrayAssert.assertEquals(
                StringUtils.split("ab:cd:ef", ":"),
                new String[]{"ab", "cd", "ef"});
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#split(String, String, int)
     */
    public void testSplit4()
    {
        ArrayAssert.assertEquals(
                StringUtils.split(null, ",", 10),
                null);
        ArrayAssert.assertEquals(
                StringUtils.split("", ",", 10),
                new String[]{});
        ArrayAssert.assertEquals(
                StringUtils.split("ab cd ef", null, 0),
                new String[]{"ab", "cd", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.split("ab   cd ef", null, 0),
                new String[]{"ab", "cd", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.split("ab:cd:ef", ":", 0),
                new String[]{"ab", "cd", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.split("ab:cd:ef", ":", 2),
                new String[]{"ab", "cd:ef"});
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#splitByWholeSeparator(String, String)
     */
    public void testSplitByWholeSeparator1()
    {
        ArrayAssert.assertEquals(
                StringUtils.splitByWholeSeparator(null, ","),
                null);
        ArrayAssert.assertEquals(
                StringUtils.splitByWholeSeparator("", ","),
                new String[]{});
        ArrayAssert.assertEquals(
                StringUtils.splitByWholeSeparator("ab cd ef", null),
                new String[]{"ab", "cd", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitByWholeSeparator("ab   cd ef", null),
                new String[]{"ab", "cd", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitByWholeSeparator("ab:cd:ef", ":"),
                new String[]{"ab", "cd", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitByWholeSeparator("ab-!-cd-!-ef", "-!-"),
                new String[]{"ab", "cd", "ef"});
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#splitByWholeSeparator(String, String, int)
     */
    public void testSplitByWholeSeparator2()
    {
        ArrayAssert.assertEquals(
                StringUtils.splitByWholeSeparator(null, ",", 10),
                null);
        ArrayAssert.assertEquals(
                StringUtils.splitByWholeSeparator("", ",", 10),
                new String[]{});
        ArrayAssert.assertEquals(
                StringUtils.splitByWholeSeparator("ab cd ef", null, 0),
                new String[]{"ab", "cd", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitByWholeSeparator("ab   cd ef", null, 0),
                new String[]{"ab", "cd", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitByWholeSeparator("ab:cd:ef", ":", 2),
                new String[]{"ab", "cd:ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitByWholeSeparator("ab-!-cd-!-ef", "-!-", 5),
                new String[]{"ab", "cd", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitByWholeSeparator("ab-!-cd-!-ef", "-!-", 2),
                new String[]{"ab", "cd-!-ef"});
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#splitByWholeSeparatorPreserveAllTokens(String, String)
     */
    public void testSplitByWholeSeparatorPreserveAllTokens1()
    {
        ArrayAssert.assertEquals(
                StringUtils.splitByWholeSeparatorPreserveAllTokens(null, ","),
                null);
        ArrayAssert.assertEquals(
                StringUtils.splitByWholeSeparatorPreserveAllTokens("", ","),
                new String[]{});
        ArrayAssert.assertEquals(
                StringUtils.splitByWholeSeparatorPreserveAllTokens("ab cd ef", null),
                new String[]{"ab", "cd", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitByWholeSeparatorPreserveAllTokens("ab   cd ef", null),
                new String[]{"ab", "", "", "cd", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitByWholeSeparatorPreserveAllTokens("ab:cd:ef", ":"),
                new String[]{"ab", "cd", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitByWholeSeparatorPreserveAllTokens("ab-!-cd-!-ef", "-!-"),
                new String[]{"ab", "cd", "ef"});
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#splitByWholeSeparatorPreserveAllTokens(String, String, int)
     */
    public void testSplitByWholeSeparatorPreserveAllTokens2()
    {
        ArrayAssert.assertEquals(
                StringUtils.splitByWholeSeparatorPreserveAllTokens(null, ",", 10),
                null);
        ArrayAssert.assertEquals(
                StringUtils.splitByWholeSeparatorPreserveAllTokens("", ",", 10),
                new String[]{});
        ArrayAssert.assertEquals(
                StringUtils.splitByWholeSeparatorPreserveAllTokens("ab cd ef", null, 0),
                new String[]{"ab", "cd", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitByWholeSeparatorPreserveAllTokens("ab   cd ef", null, 0),
                new String[]{"ab", "", "", "cd", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitByWholeSeparatorPreserveAllTokens("ab:cd:ef", ":", 2),
                new String[]{"ab", "cd:ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitByWholeSeparatorPreserveAllTokens("ab-!-cd-!-ef", "-!-", 5),
                new String[]{"ab", "cd", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitByWholeSeparatorPreserveAllTokens("ab-!-cd-!-ef", "-!-", 2),
                new String[]{"ab", "cd-!-ef"});
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#splitPreserveAllTokens(String)
     */
    public void testSplitPreserveAllTokens1()
    {
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens(null),
                null);
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens(""),
                new String[]{});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("abc def"),
                new String[]{"abc", "def"});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("abc  def"),
                new String[]{"abc", "", "def"});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens(" abc "),
                new String[]{"", "abc", ""});
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#splitPreserveAllTokens(String, char)
     */
    public void testSplitPreserveAllTokens2()
    {
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens(null, ','),
                null);
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("", ','),
                new String[]{});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("a.b.c", '.'),
                new String[]{"a", "b", "c"});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("a..b.c", '.'),
                new String[]{"a", "", "b", "c"});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("a:b:c", '.'),
                new String[]{"a:b:c"});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("a\tb\nc", null),
                new String[]{"a", "b", "c"});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("a b c", ' '),
                new String[]{"a", "b", "c"});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("a b c ", ' '),
                new String[]{"a", "b", "c", ""});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("a b c  ", ' '),
                new String[]{"a", "b", "c", "", ""});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens(" a b c", ' '),
                new String[]{"", "a", "b", "c"});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("  a b c", ' '),
                new String[]{"", "", "a", "b", "c"});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens(" a b c ", ' '),
                new String[]{"", "a", "b", "c", ""});
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#splitPreserveAllTokens(String, String)
     */
    public void testSplitPreserveAllTokens3()
    {
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens(null, ","),
                null);
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("", ","),
                new String[]{});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("abc def", null),
                new String[]{"abc", "def"});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("abc def", " "),
                new String[]{"abc", "def"});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("abc  def", " "),
                new String[]{"abc", "", "def"});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("ab:cd:ef", ":"),
                new String[]{"ab", "cd", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("ab:cd:ef:", ":"),
                new String[]{"ab", "cd", "ef", ""});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("ab:cd:ef::", ":"),
                new String[]{"ab", "cd", "ef", "", ""});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("ab::cd:ef", ":"),
                new String[]{"ab", "", "cd", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens(":cd:ef", ":"),
                new String[]{"", "cd", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("::cd:ef", ":"),
                new String[]{"", "", "cd", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens(":cd:ef:", ":"),
                new String[]{"", "cd", "ef", ""});
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#splitPreserveAllTokens(String, String, int)
     */
    public void testSplitPreserveAllTokens4()
    {
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens(null, ",", 10),
                null);
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("", ",", 10),
                new String[]{});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("ab cd ef", null, 0),
                new String[]{"ab", "cd", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("ab   cd ef", null, 0),
                new String[]{"ab", "", "", "cd", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("ab:cd:ef", ":", 0),
                new String[]{"ab", "cd", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("ab:cd:ef", ":", 2),
                new String[]{"ab", "cd:ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("ab   cd ef", null, 2),
                new String[]{"ab", "  cd ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("ab   cd ef", null, 3),
                new String[]{"ab", "", " cd ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitPreserveAllTokens("ab   cd ef", null, 4),
                new String[]{"ab", "", "", "cd ef"});
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#splitByCharacterType(String)
     */
    public void testSplitByCharacterType()
    {
        ArrayAssert.assertEquals(
                StringUtils.splitByCharacterType(null),
                null);
        ArrayAssert.assertEquals(
                StringUtils.splitByCharacterType(""),
                new String[]{});
        ArrayAssert.assertEquals(
                StringUtils.splitByCharacterType("ab cd ef"),
                new String[]{"ab", " ", "cd", " ", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitByCharacterType("ab   cd ef"),
                new String[]{"ab", "   ", "cd", " ", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitByCharacterType("ab:cd:ef"),
                new String[]{"ab", ":", "cd", ":", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitByCharacterType("number5"),
                new String[]{"number", "5"});
        ArrayAssert.assertEquals(
                StringUtils.splitByCharacterType("fooBar"),
                new String[]{"foo", "B", "ar"});
        ArrayAssert.assertEquals(
                StringUtils.splitByCharacterType("foo200Bar"),
                new String[]{"foo", "200", "B", "ar"});
        ArrayAssert.assertEquals(
                StringUtils.splitByCharacterType("ASFRules"),
                new String[]{"ASFR", "ules"});
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#splitByCharacterTypeCamelCase(String)
     */
    public void testSplitByCharacterTypeCamelCase()
    {
        ArrayAssert.assertEquals(
                StringUtils.splitByCharacterTypeCamelCase(null),
                null);
        ArrayAssert.assertEquals(
                StringUtils.splitByCharacterTypeCamelCase(""),
                new String[]{});
        ArrayAssert.assertEquals(
                StringUtils.splitByCharacterTypeCamelCase("ab cd ef"),
                new String[]{"ab", " ", "cd", " ", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitByCharacterTypeCamelCase("ab   cd ef"),
                new String[]{"ab", "   ", "cd", " ", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitByCharacterTypeCamelCase("ab:cd:ef"),
                new String[]{"ab", ":", "cd", ":", "ef"});
        ArrayAssert.assertEquals(
                StringUtils.splitByCharacterTypeCamelCase("number5"),
                new String[]{"number", "5"});
        ArrayAssert.assertEquals(
                StringUtils.splitByCharacterTypeCamelCase("fooBar"),
                new String[]{"foo", "Bar"});
        ArrayAssert.assertEquals(
                StringUtils.splitByCharacterTypeCamelCase("foo200Bar"),
                new String[]{"foo", "200", "Bar"});
        ArrayAssert.assertEquals(
                StringUtils.splitByCharacterTypeCamelCase("ASFRules"),
                new String[]{"ASF", "Rules"});
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#join(Object[])
     */
    public void testJoin1()
    {
        assertEquals(
                StringUtils.join(null),
                null);
        assertEquals(
                StringUtils.join(new String[]{}),
                "");
        assertEquals(
                StringUtils.join(new String[]{null})
                , "");
        assertEquals(
                StringUtils.join(new String[]{"a", "b", "c"}),
                "abc");
        assertEquals(
                StringUtils.join(new String[]{null, "", "a"}),
                "a");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#join(Object[], char)
     */
    public void testJoin2()
    {
        Object[] array = null;
        assertEquals(
                StringUtils.join(array, ','),
                null);
        assertEquals(
                StringUtils.join(new String[]{}, ','),
                "");
        assertEquals(
                StringUtils.join(new String[]{null}, ','),
                "");
        assertEquals(
                StringUtils.join(new String[]{"a", "b", "c"}, ';'),
                "a;b;c");
        assertEquals(
                StringUtils.join(new String[]{"a", "b", "c"}, null),
                "abc");
        assertEquals(
                StringUtils.join(new String[]{null, "", "a"}, ';'),
                ";;a");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#join(Object[], char, int, int)
     */
    public void testJoin3()
    {
        Object[] array = null;
        assertEquals(
                StringUtils.join(array, ',', 0, 0),
                null);
        assertEquals(
                StringUtils.join(new String[]{}, ',', 0, 0),
                "");
        assertEquals(
                StringUtils.join(new String[]{null}, ',', 0, 1),
                "");
        assertEquals(
                StringUtils.join(new String[]{"a", "b", "c"}, ';', 0, 0),
                "");
        assertEquals(
                StringUtils.join(new String[]{"a", "b", "c"}, ';', 0, 1),
                "a");
        assertEquals(
                StringUtils.join(new String[]{"a", "b", "c"}, ';', 0, 2),
                "a;b");
        assertEquals(
                StringUtils.join(new String[]{"a", "b", "c"}, ';', 0, 3),
                "a;b;c");
        assertEquals(
                StringUtils.join(new String[]{"a", "b", "c"}, null, 0, 0),
                "");
        assertEquals(
                StringUtils.join(new String[]{"a", "b", "c"}, null, 0, 1),
                "a");
        assertEquals(
                StringUtils.join(new String[]{"a", "b", "c"}, null, 0, 2),
                "ab");
        assertEquals(
                StringUtils.join(new String[]{"a", "b", "c"}, null, 0, 3),
                "abc");
        assertEquals(
                StringUtils.join(new String[]{null, "", "a"}, ';', 3, 3),
                "");
        assertEquals(
                StringUtils.join(new String[]{null, "", "a"}, ';', 2, 3),
                "a");
        assertEquals(
                StringUtils.join(new String[]{null, "", "a"}, ';', 1, 3),
                ";a");
        assertEquals(
                StringUtils.join(new String[]{null, "", "a"}, ';', 0, 3),
                ";;a");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#join(Object[], String)
     */
    public void testJoin4()
    {
        Object[] array = null;
        assertEquals(
                StringUtils.join(array, ","),
                null);
        assertEquals(
                StringUtils.join(new String[]{}, ","),
                "");
        assertEquals(
                StringUtils.join(new String[]{null}, ","),
                "");
        assertEquals(
                StringUtils.join(new String[]{"a", "b", "c"}, ";"),
                "a;b;c");
        assertEquals(
                StringUtils.join(new String[]{"a", "b", "c"}, null),
                "abc");
        assertEquals(
                StringUtils.join(new String[]{null, "", "a"}, ";"),
                ";;a");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#join(Object[], String, int, int)
     */
    public void testJoin5()
    {
        Object[] array = null;
        assertEquals(
                StringUtils.join(array, ",", 0, 0),
                null);
        assertEquals(
                StringUtils.join(new String[]{}, ",", 0, 0),
                "");
        assertEquals(
                StringUtils.join(new String[]{null}, ",", 0, 1),
                "");
        assertEquals(
                StringUtils.join(new String[]{"a", "b", "c"}, ";", 0, 0),
                "");
        assertEquals(
                StringUtils.join(new String[]{"a", "b", "c"}, ";", 0, 1),
                "a");
        assertEquals(
                StringUtils.join(new String[]{"a", "b", "c"}, ";", 0, 2),
                "a;b");
        assertEquals(
                StringUtils.join(new String[]{"a", "b", "c"}, ";", 0, 3),
                "a;b;c");
        assertEquals(
                StringUtils.join(new String[]{"a", "b", "c"}, null, 0, 0),
                "");
        assertEquals(
                StringUtils.join(new String[]{"a", "b", "c"}, null, 0, 1),
                "a");
        assertEquals(
                StringUtils.join(new String[]{"a", "b", "c"}, null, 0, 2),
                "ab");
        assertEquals(
                StringUtils.join(new String[]{"a", "b", "c"}, null, 0, 3),
                "abc");
        assertEquals(
                StringUtils.join(new String[]{null, "", "a"}, ";", 3, 3),
                "");
        assertEquals(
                StringUtils.join(new String[]{null, "", "a"}, ";", 2, 3),
                "a");
        assertEquals(
                StringUtils.join(new String[]{null, "", "a"}, ";", 1, 3),
                ";a");
        assertEquals(
                StringUtils.join(new String[]{null, "", "a"}, ";", 0, 3),
                ";;a");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#join(java.util.Collection, char)
     */
    public void testJoin6()
    {
        //ά
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#join(java.util.Collection, String)
     */
    public void testJoin7()
    {
        //ά
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#join(java.util.Iterator, char)
     */
    public void testJoin8()
    {
        //ά
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#join(java.util.Iterator, String)
     */
    public void testJoin9()
    {
        //ά
    }

    /* ====================================================================== */
    /**
     *  @see org.apache.commons.lang.StringUtils#deleteWhitespace(String)
     */
    public void testDeleteWhitespace()
    {
        assertEquals(
                StringUtils.deleteWhitespace(null),
                null);
        assertEquals(
            StringUtils.deleteWhitespace(""),
            "");
        assertEquals(
                StringUtils.deleteWhitespace("abc"),
                "abc");
        assertEquals(
                StringUtils.deleteWhitespace("   ab  c  "),
                "abc");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#removeStart(String, String)
     */
    public void testRemoveStart()
    {
        assertEquals(
                StringUtils.removeStart(null, "www"),
                null);
        assertEquals(
                StringUtils.removeStart("", "www"),
                "");
        assertEquals(
                StringUtils.removeStart("www.domain.com", null),
                "www.domain.com");
        assertEquals(
                StringUtils.removeStart("www.domain.com", "www."),
                "domain.com");
        assertEquals(
                StringUtils.removeStart("domain.com", "www."),
                "domain.com");
        assertEquals(
                StringUtils.removeStart("www.domain.com", "domain"),
                "www.domain.com");
        assertEquals(
                StringUtils.removeStart("abc", ""),
                "abc");
        assertEquals(
                StringUtils.removeStart("abcabc", "a"),
                "bcabc");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#removeStartIgnoreCase(String, String)
     */
    public void testRemoveStartIgnoreCase()
    {
        assertEquals(
                StringUtils.removeStartIgnoreCase(null, "www"),
                null);
        assertEquals(
                StringUtils.removeStartIgnoreCase("", "www"),
                "");
        assertEquals(
                StringUtils.removeStartIgnoreCase("www.domain.com", null),
                "www.domain.com");
        assertEquals(
                StringUtils.removeStartIgnoreCase("www.domain.com", "www."),
                "domain.com");
        assertEquals(
                StringUtils.removeStartIgnoreCase("domain.com", "www."),
                "domain.com");
        assertEquals(
                StringUtils.removeStartIgnoreCase("www.domain.com", "domain"),
                "www.domain.com");
        assertEquals(
                StringUtils.removeStartIgnoreCase("abc", ""),
                "abc");
        assertEquals(
                StringUtils.removeStartIgnoreCase("abcabc", "a"),
                "bcabc");
        assertEquals(
                StringUtils.removeStartIgnoreCase("abcabc", "A"),
                "bcabc");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#removeEnd(String, String)
     */
    public void testRemoveEnd()
    {
        assertEquals(
                StringUtils.removeEnd(null, ".com"),
                null);
        assertEquals(
                StringUtils.removeEnd("", ".com"),
                "");
        assertEquals(
                StringUtils.removeEnd("www.domain.com", null),
                "www.domain.com");
        assertEquals(
                StringUtils.removeEnd("www.domain.com", ".com."),
                "www.domain.com");
        assertEquals(
                StringUtils.removeEnd("www.domain.com", ".com"),
                "www.domain");
        assertEquals(
                StringUtils.removeEnd("www.domain.com", "domain"),
                "www.domain.com");
        assertEquals(
                StringUtils.removeEnd("abc", ""),
                "abc");
        assertEquals(
                StringUtils.removeEnd("abcabc", "c"),
                "abcab");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#remove(String, String)
     */
    public void testRemove1()
    {
        assertEquals(
                StringUtils.remove(null, "abc"),
                null);
        assertEquals(
                StringUtils.remove("", "abc"),
                "");
        assertEquals(
                StringUtils.remove("abc", null),
                "abc");
        assertEquals(
                StringUtils.remove("abc", ""),
                "abc");
        assertEquals(
                StringUtils.remove("queued", "ue"),
                "qd");
        assertEquals(
                StringUtils.remove("queued", "zz"),
                "queued");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#remove(String, char)
     */
    public void testRemove2()
    {
        assertEquals(
                StringUtils.remove(null, 'a'),
                null);
        assertEquals(
                StringUtils.remove("", 'a'),
                "");
        assertEquals(
                StringUtils.remove("queued", 'u'),
                "qeed");
        assertEquals(
                StringUtils.remove("queued", 'z'),
                "queued");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#replace(String, String, String)
     */
    public void testReplace1()
    {
        assertEquals(
                StringUtils.replace(null, "a", "z"),
                null);
        assertEquals(
                StringUtils.replace("", "a", "z"),
                "");
        assertEquals(
                StringUtils.replace("any", null, "z"),
                "any");
        assertEquals(
                StringUtils.replace("any", "a", null),
                "any");
        assertEquals(
                StringUtils.replace("any", "", "z"),
                "any");
        assertEquals(
                StringUtils.replace("aba", "a", null),
                "aba");
        assertEquals(
                StringUtils.replace("aba", "a", ""),
                "b");
        assertEquals(
                StringUtils.replace("aba", "a", "z"),
                "zbz");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#replace(String, String, String, int)
     */
    public void testReplace2()
    {
        assertEquals(
                StringUtils.replace(null, "a", "z", 0),
                null);
        assertEquals(
                StringUtils.replace("", "a", "z", 0),
                "");
        assertEquals(
                StringUtils.replace("any", null, "z", 0),
                "any");
        assertEquals(
                StringUtils.replace("any", "a", null, 0),
                "any");
        assertEquals(
                StringUtils.replace("any", "", "z", 0),
                "any");
        assertEquals(
                StringUtils.replace("any", "b", "z", 0),
                "any");
        assertEquals(
                StringUtils.replace("abaa", "a", null, -1),
                "abaa");
        assertEquals(
                StringUtils.replace("abaa", "a", "", -1),
                "b");
        assertEquals(
                StringUtils.replace("abaa", "a", "z", 0),
                "abaa");
        assertEquals(
                StringUtils.replace("abaa", "a", "z", 1),
                "zbaa");
        assertEquals(
                StringUtils.replace("abaa", "a", "z", 2),
                "zbza");
        assertEquals(
                StringUtils.replace("abaa", "a", "z", -1),
                "zbzz");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#replaceOnce(String, String, String)
     */
    public void testReplaceOnce()
    {
        assertEquals(
                StringUtils.replaceOnce(null, "a", "z"),
                null);
        assertEquals(
                StringUtils.replaceOnce("", "a", "z"),
                "");
        assertEquals(
                StringUtils.replaceOnce("any", null, "z"),
                "any");
        assertEquals(
                StringUtils.replaceOnce("any", "a", null),
                "any");
        assertEquals(
                StringUtils.replaceOnce("any", "", "z"),
                "any");
        assertEquals(
                StringUtils.replaceOnce("aba", "a", null),
                "aba");
        assertEquals(
                StringUtils.replaceOnce("aba", "a", ""),
                "ba");
        assertEquals(
                StringUtils.replaceOnce("aba", "a", "z"),
                "zba");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#replaceEach(String, String[], String[])
     */
    public void testReplaceEach()
    {
        assertEquals(
                StringUtils.replaceEach(null, new String[]{"a", "b"}, new String[]{"y", "z"}),
                null);
        assertEquals(
                StringUtils.replaceEach("", new String[]{"a", "b"}, new String[]{"y", "z"}),
                "");
        assertEquals(
                StringUtils.replaceEach("aba", null, null),
                "aba");
        assertEquals(
                StringUtils.replaceEach("aba", new String[0], null),
                "aba");
        assertEquals(
                StringUtils.replaceEach("aba", null, new String[0]),
                "aba");
        assertEquals(
                StringUtils.replaceEach("aba", new String[]{"a"}, null),
                "aba");
        assertEquals(
                StringUtils.replaceEach("aba", new String[]{"a"}, new String[]{""}),
                "b");
        assertEquals(
                StringUtils.replaceEach("aba", new String[]{null}, new String[]{"a"}),
                "aba");
        assertEquals(
                StringUtils.replaceEach("abcde", new String[]{"ab", "d"}, new String[]{"w", "t"}),
                "wcte");
        assertEquals(
                StringUtils.replaceEach("abcde", new String[]{"ab", "d"}, new String[]{"d", "t"}),
                "dcte");
        try
        {
            StringUtils.replaceEach("abcde", new String[]{"ab", "d"}, new String[]{"w"});
            fail();
        }
        catch (IllegalArgumentException e)
        {
            //IllegalArgumentExceptionϤ
        }
    }


//    /**
//     *  @see org.apache.commons.lang.StringUtils#replaceEachRepeatedly(String, String[], String[])
//     */
//    public void testReplaceEachRepeatedly()
//    {
//    }

    /**
     *  @see org.apache.commons.lang.StringUtils#replaceChars(String, char, char)
     */
    public void testReplaceChars1()
    {
        assertEquals(
                StringUtils.replaceChars(null, 'a', 'b'),
                null);
        assertEquals(
                StringUtils.replaceChars("", 'a', 'b'),
                "");
        assertEquals(
                StringUtils.replaceChars("abcba", 'b', 'y'),
                "aycya");
        assertEquals(
                StringUtils.replaceChars("abcba", 'z', 'y'),
                "abcba");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#replaceChars(String, String, String)
     */
    public void testReplaceChars2()
    {
        assertEquals(
                StringUtils.replaceChars(null, "a", "b"),
                null);
        assertEquals(
                StringUtils.replaceChars("", "a", "b"),
                "");
        assertEquals(
                StringUtils.replaceChars("abc", null, "b"),
                "abc");
        assertEquals(
                StringUtils.replaceChars("abc", "", "b"),
                "abc");
        assertEquals(
                StringUtils.replaceChars("abc", "b", null),
                "ac");
        assertEquals(
                StringUtils.replaceChars("abc", "b", ""),
                "ac");
        assertEquals(
                StringUtils.replaceChars("abcba", "bc", "yz"),
                "ayzya");
        assertEquals(
                StringUtils.replaceChars("abcba", "bc", "y"),
                "ayya");
        assertEquals(
                StringUtils.replaceChars("abcba", "bc", "yzx"),
                "ayzya");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#overlay(String, String, int, int)
     */
    public void testOverlay()
    {
        assertEquals(
                StringUtils.overlay(null, "abc", 0, 0),
                null);
        assertEquals(
                StringUtils.overlay("", "abc", 0, 0),
                "abc");
        assertEquals(
                StringUtils.overlay("abcdef", null, 2, 4),
                "abef");
        assertEquals(
                StringUtils.overlay("abcdef", "", 2, 4),
                "abef");
        assertEquals(
                StringUtils.overlay("abcdef", "", 4, 2),
                "abef");
        assertEquals(
                StringUtils.overlay("abcdef", "zzzz", 2, 4),
                "abzzzzef");
        assertEquals(
                StringUtils.overlay("abcdef", "zzzz", 4, 2),
                "abzzzzef");
        assertEquals(
                StringUtils.overlay("abcdef", "zzzz", -1, 4),
                "zzzzef");
        assertEquals(
                StringUtils.overlay("abcdef", "zzzz", 2, 8),
                "abzzzz");
        assertEquals(
                StringUtils.overlay("abcdef", "zzzz", -2, -3),
                "zzzzabcdef");
        assertEquals(
                StringUtils.overlay("abcdef", "zzzz", 8, 10),
                "abcdefzzzz");
    }

    /* ====================================================================== */
    /**
     *  @see org.apache.commons.lang.StringUtils#chomp(String)
     */
    public void testChomp1()
    {
        assertEquals(
                StringUtils.chomp(null),
                null);
        assertEquals(
                StringUtils.chomp(""),
                "");
        assertEquals(
                StringUtils.chomp("abc \r"),
                "abc ");
        assertEquals(
                StringUtils.chomp("abc\n"),
                "abc");
        assertEquals(
                StringUtils.chomp("abc\r\n"),
                "abc");
        assertEquals(
                StringUtils.chomp("abc\r\n\r\n"),
                "abc\r\n");
        assertEquals(
                StringUtils.chomp("abc\n\r"),
                "abc\n");
        assertEquals(
                StringUtils.chomp("abc\n\rabc"),
                "abc\n\rabc");
        assertEquals(
                StringUtils.chomp("\r"),
                "");
        assertEquals(
                StringUtils.chomp("\n"),
                "");
        assertEquals(
                StringUtils.chomp("\r\n"),
                "");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#chomp(String, String)
     */
    public void testChomp2()
    {
        assertEquals(
                StringUtils.chomp(null, "bar"),
                null);
        assertEquals(
                StringUtils.chomp("", "bar"),
                "");
        assertEquals(
                StringUtils.chomp("foobar", "bar"),
                "foo");
        assertEquals(
                StringUtils.chomp("foobar", "baz"),
                "foobar");
        assertEquals(
                StringUtils.chomp("foo", "foo"),
                "");
        assertEquals(
                StringUtils.chomp("foo ", "foo"),
                "foo ");
        assertEquals(
                StringUtils.chomp(" foo", "foo"),
                " ");
        assertEquals(
                StringUtils.chomp("foo", "foooo"),
                "foo");
        assertEquals(
                StringUtils.chomp("foo", ""),
                "foo");
        assertEquals(
                StringUtils.chomp("foo", null),
                "foo");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#chom(String)
     */
    public void testChop()
    {
        assertEquals(
                StringUtils.chop(null),
                null);
        assertEquals(
                StringUtils.chop(""),
                "");
        assertEquals(
                StringUtils.chop("abc \r"),
                "abc ");
        assertEquals(
                StringUtils.chop("abc\n"),
                "abc");
        assertEquals(
                StringUtils.chop("abc\r\n"),
                "abc");
        assertEquals(
                StringUtils.chop("abc"),
                "ab");
        assertEquals(
                StringUtils.chop("abc\nabc"),
                "abc\nab");
        assertEquals(
                StringUtils.chop("a"),
                "");
        assertEquals(
                StringUtils.chop("\r"),
                "");
        assertEquals(
                StringUtils.chop("\n"),
                "");
        assertEquals(
                StringUtils.chop("\r\n"),
                "");
    }

    /* ====================================================================== */
    /**
     *  @see org.apache.commons.lang.StringUtils#repeat(String, int)
     */
    public void testRepeat()
    {
        assertEquals(
                StringUtils.repeat(null, 2),
                null);
        assertEquals(
                StringUtils.repeat("", 0),
                "");
        assertEquals(
                StringUtils.repeat("", 2),
                "");
        assertEquals(
                StringUtils.repeat("a", 3),
                "aaa");
        assertEquals(
                StringUtils.repeat("ab", 2),
                "abab");
        assertEquals(
                StringUtils.repeat("a", -2),
                "");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#rightPad(String, int)
     */
    public void testRightPad1()
    {
        assertEquals(
                StringUtils.rightPad(null, 3),
                null);
        assertEquals(
                StringUtils.rightPad("", 3),
                "   ");
        assertEquals(
                StringUtils.rightPad("bat", 3),
                "bat");
        assertEquals(
                StringUtils.rightPad("bat", 5),
                "bat  ");
        assertEquals(
                StringUtils.rightPad("bat", 1),
                "bat");
        assertEquals(
                StringUtils.rightPad("bat", -1),
                "bat");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#rightPad(String, int, char)
     */
    public void testRightPad2()
    {
        assertEquals(
                StringUtils.rightPad(null, 3, 'z'),
                null);
        assertEquals(
                StringUtils.rightPad("", 3, 'z'),
                "zzz");
        assertEquals(
                StringUtils.rightPad("bat", 3, 'z'),
                "bat");
        assertEquals(
                StringUtils.rightPad("bat", 5, 'z'),
                "batzz");
        assertEquals(
                StringUtils.rightPad("bat", 1, 'z'),
                "bat");
        assertEquals(
                StringUtils.rightPad("bat", -1, 'z'),
                "bat");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#rightPad(String, int, String)
     */
    public void testRightPad3()
    {
        assertEquals(
                StringUtils.rightPad(null, 3, "z"),
                null);
        assertEquals(
                StringUtils.rightPad("", 3, "z"),
                "zzz");
        assertEquals(
                StringUtils.rightPad("bat", 3, "yz"),
                "bat");
        assertEquals(
                StringUtils.rightPad("bat", 5, "yz"),
                "batyz");
        assertEquals(
                StringUtils.rightPad("bat", 8, "yz"),
                "batyzyzy");
        assertEquals(
                StringUtils.rightPad("bat", 1, "yz"),
                "bat");
        assertEquals(
                StringUtils.rightPad("bat", -1, "yz"),
                "bat");
        assertEquals(
                StringUtils.rightPad("bat", 5, null),
                "bat  ");
        assertEquals(
                StringUtils.rightPad("bat", 5, ""),
                "bat  ");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#leftPad(String, int)
     */
    public void testLeftPad1()
    {
        assertEquals(
                StringUtils.leftPad(null, 3),
                null);
        assertEquals(
                StringUtils.leftPad("", 3),
                "   ");
        assertEquals(
                StringUtils.leftPad("bat", 3),
                "bat");
        assertEquals(
                StringUtils.leftPad("bat", 5),
                "  bat");
        assertEquals(
                StringUtils.leftPad("bat", 1),
                "bat");
        assertEquals(
                StringUtils.leftPad("bat", -1),
                "bat");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#leftPad(String, int, char)
     */
    public void testLeftPad2()
    {
        assertEquals(
                StringUtils.leftPad(null, 3, 'z'),
                null);
        assertEquals(
                StringUtils.leftPad("", 3, 'z'),
                "zzz");
        assertEquals(
                StringUtils.leftPad("bat", 3, 'z'),
                "bat");
        assertEquals(
                StringUtils.leftPad("bat", 5, 'z'),
                "zzbat");
        assertEquals(
                StringUtils.leftPad("bat", 1, 'z'),
                "bat");
        assertEquals(
                StringUtils.leftPad("bat", -1, 'z'),
                "bat");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#leftPad(String, int, String)
     */
    public void testLeftPad3()
    {
        assertEquals(
                StringUtils.leftPad(null, 3, "z"),
                null);
        assertEquals(
                StringUtils.leftPad("", 3, "z"),
                "zzz");
        assertEquals(
                StringUtils.leftPad("bat", 3, "yz"),
                "bat");
        assertEquals(
                StringUtils.leftPad("bat", 5, "yz"),
                "yzbat");
        assertEquals(
                StringUtils.leftPad("bat", 8, "yz"),
                "yzyzybat");
        assertEquals(
                StringUtils.leftPad("bat", 1, "yz"),
                "bat");
        assertEquals(
                StringUtils.leftPad("bat", -1, "yz"),
                "bat");
        assertEquals(
                StringUtils.leftPad("bat", 5, null),
                "  bat");
        assertEquals(
                StringUtils.leftPad("bat", 5, ""),
                "  bat");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#center(String, int)
     */
    public void testCenter1()
    {
        assertEquals(
                StringUtils.center(null, 4),
                null);
        assertEquals(
                StringUtils.center("", 4),
                "    ");
        assertEquals(
                StringUtils.center("ab", -1),
                "ab");
        assertEquals(
                StringUtils.center("ab", 4),
                " ab ");
        assertEquals(
                StringUtils.center("abcd", 2),
                "abcd");
        assertEquals(
                StringUtils.center("a", 4),
                " a  ");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#center(String, int, char)
     */
    public void testCenter2()
    {
        assertEquals(
                StringUtils.center(null, 4, ' '),
                null);
        assertEquals(
                StringUtils.center("", 4, ' '),
                "    ");
        assertEquals(
                StringUtils.center("ab", -1, ' '),
                "ab");
        assertEquals(
                StringUtils.center("ab", 4, ' '),
                " ab ");
        assertEquals(
                StringUtils.center("abcd", 2, ' '),
                "abcd");
        assertEquals(
                StringUtils.center("a", 4, ' '),
                " a  ");
        assertEquals(
                StringUtils.center("a", 4, 'y'),
                "yayy");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#center(String, int, String)
     */
    public void testCenter3()
    {
        assertEquals(
                StringUtils.center(null, 4, " "),
                null);
        assertEquals(
                StringUtils.center("", 4, " "),
                "    ");
        assertEquals(
                StringUtils.center("ab", -1, " "),
                "ab");
        assertEquals(
                StringUtils.center("ab", 4, " "),
                " ab ");
        assertEquals(
                StringUtils.center("abcd", 2, " "),
                "abcd");
        assertEquals(
                StringUtils.center("a", 4, " "),
                " a  ");
        assertEquals(
                StringUtils.center("a", 4, "yz"),
                "yayz");
        assertEquals(
                StringUtils.center("abc", 7, null),
                "  abc  ");
        assertEquals(
                StringUtils.center("abc", 7, ""),
                "  abc  ");
    }

    /* ====================================================================== */
    /**
     *  @see org.apache.commons.lang.StringUtils#upperCase(String)
     */
    public void testUpperCase()
    {
        assertEquals(
                StringUtils.upperCase(null),
                null);
        assertEquals(
                StringUtils.upperCase(""),
                "");
        assertEquals(
                StringUtils.upperCase("aBc"),
                "ABC");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#lowerCase(String)
     */
    public void testLowerCase()
    {
        assertEquals(
                StringUtils.lowerCase(null),
                null);
        assertEquals(
                StringUtils.lowerCase(""),
                "");
        assertEquals(
                StringUtils.lowerCase("aBc"),
                "abc");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#capitalize(String)
     */
    public void testCapitalize()
    {
        assertEquals(
                StringUtils.capitalize(null),
                null);
        assertEquals(
                StringUtils.capitalize(""),
                "");
        assertEquals(
                StringUtils.capitalize("cat"),
                "Cat");
        assertEquals(
                StringUtils.capitalize("cAt"),
                "CAt");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#uncapitalize(String)
     */
    public void testUncapitalize()
    {
        assertEquals(
                StringUtils.uncapitalize(null),
                null);
        assertEquals(
                StringUtils.uncapitalize(""),
                "");
        assertEquals(
                StringUtils.uncapitalize("Cat"),
                "cat");
        assertEquals(
                StringUtils.uncapitalize("CAT"),
                "cAT");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#swapCase(String)
     */
    public void testSwapCase()
    {
        assertEquals(
                StringUtils.swapCase(null),
                null);
        assertEquals(
                StringUtils.swapCase(""),
                "");
        assertEquals(
                StringUtils.swapCase("The dog has a BONE"),
                "tHE DOG HAS A bone");
    }

    /* ====================================================================== */
    /**
     *  @see org.apache.commons.lang.StringUtils#countMatches(String, String)
     */
    public void testCountMatches()
    {
        assertEquals(
                StringUtils.countMatches(null, "a"),
                0);
        assertEquals(
                StringUtils.countMatches("", "a"),
                0);
        assertEquals(
                StringUtils.countMatches("abba", null),
                0);
        assertEquals(
                StringUtils.countMatches("abba", ""),
                0);
        assertEquals(
                StringUtils.countMatches("abba", "a"),
                2);
        assertEquals(
                StringUtils.countMatches("abba", "ab"),
                1);
        assertEquals(
                StringUtils.countMatches("abba", "xxx"),
                0);
    }

    /* ====================================================================== */
    /**
     *  @see org.apache.commons.lang.StringUtils#isAlpha(String)
     */
    public void testIsAlpha()
    {
        assertFalse(
                StringUtils.isAlpha(null));
        assertTrue(
                StringUtils.isAlpha(""));
        assertFalse(
                StringUtils.isAlpha("  "));
        assertTrue(
                StringUtils.isAlpha("abc"));
        assertFalse(
                StringUtils.isAlpha("ab2c"));
        assertFalse(
                StringUtils.isAlpha("ab-c"));
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#isAlphaSpace(String)
     */
    public void testIsAlphaSpace()
    {
        assertFalse(
                StringUtils.isAlphaSpace(null));
        assertTrue(
                StringUtils.isAlphaSpace(""));
        assertTrue(
                StringUtils.isAlphaSpace("  "));
        assertTrue(
                StringUtils.isAlphaSpace("abc"));
        assertTrue(
                StringUtils.isAlphaSpace("ab c"));
        assertFalse(
                StringUtils.isAlphaSpace("ab2c"));
        assertFalse(
                StringUtils.isAlphaSpace("ab-c"));
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#isAlphanumeric(String)
     */
    public void testIsAlphanumeric()
    {
        assertFalse(
                StringUtils.isAlphanumeric(null));
        assertTrue(
                StringUtils.isAlphanumeric(""));
        assertFalse(
                StringUtils.isAlphanumeric("  "));
        assertTrue(
                StringUtils.isAlphanumeric("abc"));
        assertFalse(
                StringUtils.isAlphanumeric("ab c"));
        assertTrue(
                StringUtils.isAlphanumeric("ab2c"));
        assertFalse(
                StringUtils.isAlphanumeric("ab-c"));
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#isAlphanumericSpace(String)
     */
    public void testIsAlphanumericSpace()
    {
        assertFalse(
                StringUtils.isAlphanumericSpace(null));
        assertTrue(
                StringUtils.isAlphanumericSpace(""));
        assertTrue(
                StringUtils.isAlphanumericSpace("  "));
        assertTrue(
                StringUtils.isAlphanumericSpace("abc"));
        assertTrue(
                StringUtils.isAlphanumericSpace("ab c"));
        assertTrue(
                StringUtils.isAlphanumericSpace("ab2c"));
        assertFalse(
                StringUtils.isAlphanumericSpace("ab-c"));
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#isAsciiPrintable(String)
     */
    public void testIsAsciiPrintable()
    {
        assertFalse(
                StringUtils.isAsciiPrintable(null));
        assertTrue(
                StringUtils.isAsciiPrintable(""));
        assertTrue(
                StringUtils.isAsciiPrintable(" "));
        assertTrue(
                StringUtils.isAsciiPrintable("Ceki"));
        assertTrue(
                StringUtils.isAsciiPrintable("ab2c"));
        assertTrue(
                StringUtils.isAsciiPrintable("!ab-c~"));
        assertTrue(
                StringUtils.isAsciiPrintable(" "));
        assertTrue(
                StringUtils.isAsciiPrintable("!"));
        assertTrue(
                StringUtils.isAsciiPrintable("~"));
        assertFalse(
                StringUtils.isAsciiPrintable(""));
        assertFalse(
                StringUtils.isAsciiPrintable("Ceki Glc"));
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#isNumeric(String)
     */
    public void testIsNumeric()
    {
        assertFalse(
                StringUtils.isNumeric(null));
        assertTrue(
                StringUtils.isNumeric(""));
        assertFalse(
                StringUtils.isNumeric("  "));
        assertTrue(
                StringUtils.isNumeric("123"));
        assertFalse(
                StringUtils.isNumeric("12 3"));
        assertFalse(
                StringUtils.isNumeric("ab2c"));
        assertFalse(
                StringUtils.isNumeric("12-3"));
        assertFalse(
                StringUtils.isNumeric("12.3"));
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#isNumericSpace(String)
     */
    public void testIsNumericSpace()
    {
        assertFalse(
                StringUtils.isNumericSpace(null));
        assertTrue(
                StringUtils.isNumericSpace(""));
        assertTrue(
                StringUtils.isNumericSpace("  "));
        assertTrue(
                StringUtils.isNumericSpace("123"));
        assertTrue(
                StringUtils.isNumericSpace("12 3"));
        assertFalse(
                StringUtils.isNumericSpace("ab2c"));
        assertFalse(
                StringUtils.isNumericSpace("12-3"));
        assertFalse(
                StringUtils.isNumericSpace("12.3"));
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#isWhitespace(String)
     */
    public void testIsWhitespace()
    {
        assertFalse(
                StringUtils.isWhitespace(null));
        assertTrue(
                StringUtils.isWhitespace(""));
        assertTrue(
                StringUtils.isWhitespace("  "));
        assertFalse(
                StringUtils.isWhitespace("abc"));
        assertFalse(
                StringUtils.isWhitespace("ab2c"));
        assertFalse(
                StringUtils.isWhitespace("ab-c"));
    }

    /* ====================================================================== */
    /**
     *  @see org.apache.commons.lang.StringUtils#defaultString(String)
     */
    public void testDefaultString1()
    {
        assertEquals(
                StringUtils.defaultString(null),
                "");
        assertEquals(
                StringUtils.defaultString(""),
                "");
        assertEquals(
                StringUtils.defaultString("bat"),
                "bat");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#defaultString(String, String)
     */
    public void testDefaultString2()
    {
        assertEquals(
                StringUtils.defaultString(null, "NULL"),
                "NULL");
        assertEquals(
                StringUtils.defaultString("", "NULL"),
                "");
        assertEquals(
                StringUtils.defaultString("bat", "NULL"),
                "bat");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#defaultIfEmpty(String, String)
     */
    public void testDefaultIfEmpty()
    {
        assertEquals(
                StringUtils.defaultIfEmpty(null, "NULL"),
                "NULL");
        assertEquals(
                StringUtils.defaultIfEmpty("", "NULL"),
                "NULL");
        assertEquals(
                StringUtils.defaultIfEmpty("bat", "NULL"),
                "bat");
    }

    /* ====================================================================== */
    /**
     *  @see org.apache.commons.lang.StringUtils#reverse(String)
     */
    public void testReverse()
    {
        assertEquals(
                StringUtils.reverse(null),
                null);
        assertEquals(
                StringUtils.reverse(""),
                "");
        assertEquals(
                StringUtils.reverse("bat"),
                "tab");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#reverseDelimited(String, char)
     */
    public void testReverseDelimited()
    {
        assertEquals(
                StringUtils.reverseDelimited(null, '.'),
                null);
        assertEquals(
                StringUtils.reverseDelimited("", '.'),
                "");
        assertEquals(
                StringUtils.reverseDelimited("a.b.c", 'x'),
                "a.b.c");
        assertEquals(
                StringUtils.reverseDelimited("a.b.c", '.'),
                "c.b.a");
    }

    /* ====================================================================== */
    /**
     *  @see org.apache.commons.lang.StringUtils#abbreviate(String, int)
     */
    public void testAbbreviate1()
    {
        assertEquals(
                StringUtils.abbreviate(null, 4),
                null);
        assertEquals(
                StringUtils.abbreviate("", 4),
                "");
        assertEquals(
                StringUtils.abbreviate("abcdefg", 6),
                "abc...");
        assertEquals(
                StringUtils.abbreviate("abcdefg", 7),
                "abcdefg");
        assertEquals(
                StringUtils.abbreviate("abcdefg", 8),
                "abcdefg");
        assertEquals(
                StringUtils.abbreviate("abcdefg", 4),
                "a...");
        try
        {
            StringUtils.abbreviate("abcdefg", 3);
            fail();
        }
        catch (IllegalArgumentException e)
        {
            //IllegalArgumentExceptionϤ
        }
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#abbreviate(String, int, int)
     */
    public void testAbbreviate2()
    {
        assertEquals(
                StringUtils.abbreviate(null, 0, 4),
                null);
        assertEquals(
                StringUtils.abbreviate("", 0, 4),
                "");
        assertEquals(
                StringUtils.abbreviate("abcdefghijklmno", -1, 10),
                "abcdefg...");
        assertEquals(
                StringUtils.abbreviate("abcdefghijklmno", 0, 10),
                "abcdefg...");
        assertEquals(
                StringUtils.abbreviate("abcdefghijklmno", 1, 10),
                "abcdefg...");
        assertEquals(
                StringUtils.abbreviate("abcdefghijklmno", 4, 10),
                "abcdefg...");
        assertEquals(
                StringUtils.abbreviate("abcdefghijklmno", 5, 10),
                "...fghi...");
        assertEquals(
                StringUtils.abbreviate("abcdefghijklmno", 6, 10),
                "...ghij...");
        assertEquals(
                StringUtils.abbreviate("abcdefghijklmno", 8, 10),
                "...ijklmno");
        assertEquals(
                StringUtils.abbreviate("abcdefghijklmno", 10, 10),
                "...ijklmno");
        assertEquals(
                StringUtils.abbreviate("abcdefghijklmno", 12, 10),
                "...ijklmno");
        try
        {
            StringUtils.abbreviate("abcdefghij", 0, 3);
            fail();
        }
        catch (IllegalArgumentException e)
        {
            //IllegalArgumentExceptionϤ
        }
        try
        {
            StringUtils.abbreviate("abcdefghij", 5, 6);
            fail();
        }
        catch (IllegalArgumentException e)
        {
            //IllegalArgumentExceptionϤ
        }
    }

    /* ====================================================================== */
    /**
     *  @see org.apache.commons.lang.StringUtils#difference(String, String)
     */
    public void testDifference()
    {
        assertEquals(
                StringUtils.difference(null, null),
                null);
        assertEquals(
                StringUtils.difference("", ""),
                "");
        assertEquals(
                StringUtils.difference("", "abc"),
                "abc");
        assertEquals(
                StringUtils.difference("abc", ""),
                "");
        assertEquals(
                StringUtils.difference("abc", "abc"),
                "");
        assertEquals(
                StringUtils.difference("ab", "abxyz"),
                "xyz");
        assertEquals(
                StringUtils.difference("abcde", "abxyz"),
                "xyz");
        assertEquals(
                StringUtils.difference("abcde", "xyz"),
                "xyz");
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#indexOfDifference(String, String)
     */
    public void testIndexOfDifference1()
    {
        assertEquals(
                StringUtils.indexOfDifference(null, null),
                -1);
        assertEquals(
                StringUtils.indexOfDifference("", ""),
                -1);
        assertEquals(
                StringUtils.indexOfDifference("", "abc"),
                0);
        assertEquals(
                StringUtils.indexOfDifference("abc", ""),
                0);
        assertEquals(
                StringUtils.indexOfDifference("abc", "abc"),
                -1);
        assertEquals(
                StringUtils.indexOfDifference("ab", "abxyz"),
                2);
        assertEquals(
                StringUtils.indexOfDifference("abcde", "abxyz"),
                2);
        assertEquals(
                StringUtils.indexOfDifference("abcde", "xyz"),
                0);
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#indexOfDifference(String[])
     */
    public void testIndexOfDifference2()
    {
        assertEquals(
                StringUtils.indexOfDifference(null),
                -1);
        assertEquals(
                StringUtils.indexOfDifference(new String[]{}),
                -1);
        assertEquals(
                StringUtils.indexOfDifference(new String[]{"abc"}),
                -1);
        assertEquals(
                StringUtils.indexOfDifference(new String[]{null, null}),
                -1);
        assertEquals(
                StringUtils.indexOfDifference(new String[]{"", ""}),
                -1);
        assertEquals(
                StringUtils.indexOfDifference(new String[]{"", null}),
                0);
        assertEquals(
                StringUtils.indexOfDifference(new String[]{"abc", null, null}),
                0);
        assertEquals(
                StringUtils.indexOfDifference(new String[]{null, null, "abc"}),
                0);
        assertEquals(
                StringUtils.indexOfDifference(new String[]{"", "abc"}),
                0);
        assertEquals(
                StringUtils.indexOfDifference(new String[]{"abc", ""}),
                0);
        assertEquals(
                StringUtils.indexOfDifference(new String[]{"abc", "abc"}),
                -1);
        assertEquals(
                StringUtils.indexOfDifference(new String[]{"abc", "a"}),
                1);
        assertEquals(
                StringUtils.indexOfDifference(new String[]{"ab", "abxyz"}),
                2);
        assertEquals(
                StringUtils.indexOfDifference(new String[]{"abcde", "abxyz"}),
                2);
        assertEquals(
                StringUtils.indexOfDifference(new String[]{"abcde", "xyz"}),
                0);
        assertEquals(
                StringUtils.indexOfDifference(new String[]{"xyz", "abcde"}),
                0);
    }

    /**
     *  @see org.apache.commons.lang.StringUtils#getCommonPrefix(String[])
     */
    public void testGetCommonPrefix()
    {
        assertEquals(
                StringUtils.getCommonPrefix(null),
                "");
        assertEquals(
                StringUtils.getCommonPrefix(new String[]{}),
                "");
        assertEquals(
                StringUtils.getCommonPrefix(new String[]{"abc"}),
                "abc");
        assertEquals(
                StringUtils.getCommonPrefix(new String[]{null, null}),
                "");
        assertEquals(
                StringUtils.getCommonPrefix(new String[]{"", ""}),
                "");
        assertEquals(
                StringUtils.getCommonPrefix(new String[]{"", null}),
                "");
        assertEquals(
                StringUtils.getCommonPrefix(new String[]{"abc", null, null}),
                "");
        assertEquals(
                StringUtils.getCommonPrefix(new String[]{null, null, "abc"}),
                "");
        assertEquals(
                StringUtils.getCommonPrefix(new String[]{"", "abc"}),
                "");
        assertEquals(
                StringUtils.getCommonPrefix(new String[]{"abc", ""}),
                "");
        assertEquals(
                StringUtils.getCommonPrefix(new String[]{"abc", "abc"}),
                "abc");
        assertEquals(
                StringUtils.getCommonPrefix(new String[]{"abc", "a"}),
                "a");
        assertEquals(
                StringUtils.getCommonPrefix(new String[]{"ab", "abxyz"}),
                "ab");
        assertEquals(
                StringUtils.getCommonPrefix(new String[]{"abcde", "abxyz"}),
                "ab");
        assertEquals(
                StringUtils.getCommonPrefix(new String[]{"abcde", "xyz"}),
                "");
        assertEquals(
                StringUtils.getCommonPrefix(new String[]{"xyz", "abcde"}),
                "");
    }

    /* ====================================================================== */
    /**
     *  @see org.apache.commons.lang.StringUtils#getLevenshteinDistance(String, String)
     */
    public void testGetLevenshteinDistance()
    {
        try
        {
            StringUtils.getLevenshteinDistance(null, "");
            fail();
        }
        catch (IllegalArgumentException e)
        {
            //IllegalArgumentExceptionϤ
        }
        try
        {
            StringUtils.getLevenshteinDistance("", null);
            fail();
        }
        catch (IllegalArgumentException e)
        {
            //IllegalArgumentExceptionϤ
        }
        assertEquals(
                StringUtils.getLevenshteinDistance("", ""),
                0);
        assertEquals(
                StringUtils.getLevenshteinDistance("", "a"),
                1);
        assertEquals(
                StringUtils.getLevenshteinDistance("aaapppp", ""),
                7);
        assertEquals(
                StringUtils.getLevenshteinDistance("frog", "fog"),
                1);
        assertEquals(
                StringUtils.getLevenshteinDistance("fly", "ant"),
                3);
        assertEquals(
                StringUtils.getLevenshteinDistance("elephant", "hippo"),
                7);
        assertEquals(
                StringUtils.getLevenshteinDistance("hippo", "elephant"),
                7);
        assertEquals(
                StringUtils.getLevenshteinDistance("hippo", "zzzzzzzz"),
                8);
        assertEquals(
                StringUtils.getLevenshteinDistance("hello", "hallo"),
                1);
    }

}
