package net.tk_factory.sample.apache.poi.cell;

import java.io.FileOutputStream;
import java.io.IOException;
import net.tk_factory.sample.AbstractSample;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

/**
 * Apache POI-HSSFѤץץǤ<br/>
 * <br/>
 * <b></b>
 * <ol type="1">
 * <li>HSSFRow饹removeCell᥽åɤѤơޤ</li>
 * </ol>
 * @author Takafumi Kondo (TK Factory)
 * @see org.apache.poi.hssf.usermodel.HSSFRow#removeCell(org.apache.poi.ss.usermodel.Cell)
 */
public class SampleRemoveCell extends AbstractSample
{
    /** 饹̾ */
    private static final String CLASS_NAME =
        SampleRemoveCell.class.getSimpleName();

    /**  */
    private static final Logger LOGGER =
        Logger.getLogger(SampleRemoveCell.class.getName());

    /** ϥե̾ */
    private static final String OUT_FILE_NAME =
        SAMPLE_FILE_DIRECTORY + CLASS_NAME + "Out.xls";

    /**
     * SampleRemoveCell֥Ȥۤȡ
     * UnsupportedOperationExceptionޤ<br/>
     */
    protected SampleRemoveCell()
    {
        throw new UnsupportedOperationException();
    }

    /**
     * main᥽åɤǤ<br/>
     *
     * @param args 
     */
    public static void main(String[] args)
    {
        LOGGER.info("[START]" + CLASS_NAME);

        FileOutputStream out = null;

        try
        {
            //Ǥ˽ϥե뤬¸ߤƤϺ
            deleteExistsFile(OUT_FILE_NAME);

            //֥å
            HSSFWorkbook workbook = new HSSFWorkbook();
            LOGGER.debug(workbook.toString());

            //Ȥɲä
            HSSFSheet sheet = workbook.createSheet();
            LOGGER.debug(sheet.toString());

            //Ԥɲäʣܡ
            HSSFRow row = sheet.createRow(0);
            LOGGER.debug(row.toString());

            //ɲäʣܣܡ
            HSSFCell cell1 = row.createCell(0);
            LOGGER.debug(cell1.toString());
            //ɲäʣܣܡ
            HSSFCell cell2 = row.createCell(1);
            LOGGER.debug(cell2.toString());

            //ʣܣܡ
            row.removeCell(cell1);

            //ե¸
            out = new FileOutputStream(OUT_FILE_NAME);
            workbook.write(out);
        }
        catch (IOException ioex)
        {
            LOGGER.error(getStackTrace(ioex));
        }
        finally
        {
            try
            {
                if (out != null)
                {
                    out.close();
                }
            }
            catch (IOException ioex)
            {
                LOGGER.error(getStackTrace(ioex));
            }

            LOGGER.info("[E N D]" + CLASS_NAME);
        }
    }
}
