package net.tk_factory.sample.apache.poi.column;

import java.io.FileOutputStream;
import java.io.IOException;
import net.tk_factory.sample.AbstractSample;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

/**
 * Apache POI-HSSFѤץץǤ<br/>
 * <br/>
 * <b></b>
 * <ol type="1">
 * <li>HSSFSheet饹setColumnWidth᥽åɤѤơꤷޤ</li>
 * </ol>
 * @author Takafumi Kondo (TK Factory)
 * @see org.apache.poi.hssf.usermodel.HSSFSheet#setColumnWidth(int, int)
 */
public class SampleSetColumnWidth extends AbstractSample
{
    /** 饹̾ */
    private static final String CLASS_NAME =
        SampleSetColumnWidth.class.getSimpleName();

    /**  */
    private static final Logger LOGGER =
        Logger.getLogger(SampleSetColumnWidth.class.getName());

    /** ϥե̾ */
    private static final String OUT_FILE_NAME =
        SAMPLE_FILE_DIRECTORY + CLASS_NAME + "Out.xls";

    /**
     * SampleSetColumnWidth֥Ȥۤȡ
     * UnsupportedOperationExceptionޤ<br/>
     */
    protected SampleSetColumnWidth()
    {
        throw new UnsupportedOperationException();
    }

    /**
     * main᥽åɤǤ<br/>
     *
     * @param args 
     */
    public static void main(String[] args)
    {
        FileOutputStream out = null;

        try
        {
            //Ǥ˽ϥե뤬¸ߤƤϺ
            deleteExistsFile(OUT_FILE_NAME);

            //֥å
            HSSFWorkbook workbook = new HSSFWorkbook();

            //Ȥɲä
            HSSFSheet sheet = workbook.createSheet();
            LOGGER.debug(sheet.toString());

            //1ꤹ1ʸ1/256Υˤʤ
            //1ܤ1ʸʬꤹ
            sheet.setColumnWidth(0, 1 * 256);
            //2ܤ2ʸʬꤹ
            sheet.setColumnWidth(1, 2 * 256);
            //3ܤ10ʸʬꤹ
            sheet.setColumnWidth(2, 10 * 256);

            //ե¸
            out = new FileOutputStream(OUT_FILE_NAME);
            workbook.write(out);
        }
        catch (IOException ioex)
        {
            LOGGER.error(getStackTrace(ioex));
        }
        finally
        {
            try
            {
                if (out != null)
                {
                    out.close();
                }
            }
            catch (IOException ioex)
            {
                LOGGER.error(getStackTrace(ioex));
            }
        }
    }
}
