package net.tk_factory.sample.apache.poi.row;

import java.io.FileOutputStream;
import java.io.IOException;
import net.tk_factory.sample.AbstractSample;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

/**
 * Apache POI-HSSFѤץץǤ<br/>
 * <br/>
 * <b></b>
 * <ol type="1">
 * <li>HSSFSheet饹shiftRows᥽åɤѤơԤưޤ</li>
 * </ol>
 * @author Takafumi Kondo (TK Factory)
 * @see org.apache.poi.hssf.usermodel.HSSFSheet#shiftRows(int, int, int)
 * @see org.apache.poi.hssf.usermodel.HSSFSheet#shiftRows(int, int, int, boolean, boolean)
 */
public class SampleShiftRows extends AbstractSample
{
    /** 饹̾ */
    private static final String CLASS_NAME =
        SampleShiftRows.class.getSimpleName();

    /**  */
    private static final Logger LOGGER =
        Logger.getLogger(SampleShiftRows.class.getName());

    /** ϥե̾ */
    private static final String OUT_FILE_NAME =
        SAMPLE_FILE_DIRECTORY + CLASS_NAME + "Out.xls";

    /**
     * SampleShiftRows֥Ȥۤȡ
     * UnsupportedOperationExceptionޤ<br/>
     */
    protected SampleShiftRows()
    {
        throw new UnsupportedOperationException();
    }

    /**
     * main᥽åɤǤ<br/>
     *
     * @param args 
     */
    public static void main(String[] args)
    {
        FileOutputStream out = null;

        try
        {
            //Ǥ˽ϥե뤬¸ߤƤϺ
            deleteExistsFile(OUT_FILE_NAME);

            //֥å
            HSSFWorkbook workbook = new HSSFWorkbook();

            //Ȥɲä
            HSSFSheet sheet = workbook.createSheet();
            LOGGER.debug(sheet.toString());

            //Ԥɲä
            for (int i = 0; i < 10; i++)
            {
                HSSFRow row = sheet.createRow(i);
                HSSFCell cell = row.createCell(0);
                cell.setCellValue(i + 1);
            }

            //Ԥưʣܤ飲ܤޤǤ򲼤ˣ԰ư
            sheet.shiftRows(0, 1, 5);

            //Ԥưʣܤ飴ܤޤǤˣ԰ư
            //˰ưϥޥʥͤꤹ
            sheet.shiftRows(2, 3, -1);

            //ե¸
            out = new FileOutputStream(OUT_FILE_NAME);
            workbook.write(out);
        }
        catch (IOException ioex)
        {
            LOGGER.error(getStackTrace(ioex));
        }
        finally
        {
            try
            {
                if (out != null)
                {
                    out.close();
                }
            }
            catch (IOException ioex)
            {
                LOGGER.error(getStackTrace(ioex));
            }
        }
    }
}
