package net.tk_factory.sample.apache.poi.sheet;

import java.io.FileOutputStream;
import java.io.IOException;
import net.tk_factory.sample.AbstractSample;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

/**
 * Apache POI-HSSFѤץץǤ<br/>
 * <br/>
 * <b></b>
 * <ol type="1">
 * <li>HSSFWorkbook饹setSheetName᥽åɤѤơ̾ꤷޤ</li>
 * </ol>
 * @author Takafumi Kondo (TK Factory)
 * @see org.apache.poi.hssf.usermodel.HSSFWorkbook#setSheetName(int, String)
 */
public class SampleSetSheetName extends AbstractSample
{
    /** 饹̾ */
    private static final String CLASS_NAME =
        SampleSetSheetName.class.getSimpleName();

    /**  */
    private static final Logger LOGGER =
        Logger.getLogger(SampleSetSheetName.class.getName());

    /** ϥե̾ */
    private static final String OUT_FILE_NAME =
        SAMPLE_FILE_DIRECTORY + CLASS_NAME + "Out.xls";

    /**
     * SampleSetSheetName֥Ȥۤȡ
     * UnsupportedOperationExceptionޤ<br/>
     */
    protected SampleSetSheetName()
    {
        throw new UnsupportedOperationException();
    }

    /**
     * main᥽åɤǤ<br/>
     *
     * @param args 
     */
    public static void main(String[] args)
    {
        LOGGER.info("[START]" + CLASS_NAME);

        FileOutputStream out = null;

        try
        {
            //Ǥ˽ϥե뤬¸ߤƤϺ
            deleteExistsFile(OUT_FILE_NAME);

            //֥å
            HSSFWorkbook workbook = new HSSFWorkbook();
            LOGGER.debug(workbook.toString());

            //Ȥɲä
            HSSFSheet sheet1 = workbook.createSheet();
            LOGGER.debug(sheet1.toString());
            HSSFSheet sheet2 = workbook.createSheet();
            LOGGER.debug(sheet2.toString());

            //̾ꤹ
            workbook.setSheetName(0, "test");
            LOGGER.debug(workbook.getSheetName(0));
            workbook.setSheetName(1, "ƥ");
            LOGGER.debug(workbook.getSheetName(1));

            //ե¸
            out = new FileOutputStream(OUT_FILE_NAME);
            workbook.write(out);
        }
        catch (IOException ioex)
        {
            LOGGER.error(getStackTrace(ioex));
        }
        finally
        {
            try
            {
                if (out != null)
                {
                    out.close();
                }
            }
            catch (IOException ioex)
            {
                LOGGER.error(getStackTrace(ioex));
            }

            LOGGER.info("[E N D]" + CLASS_NAME);
        }
    }
}
