package net.tk_factory.sample.jfreechart;

import java.io.FileOutputStream;
import java.io.IOException;

import net.tk_factory.sample.AbstractSample;

import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

/**
 * JFreeChartѤץץǤ<br/>
 * <br/>
 * <b></b>
 * <ol type="1">
 * <li>ե㡼Ȥޤ</li>
 * <li>ChartUtilities饹ѤơPNGǲϤޤ</li>
 * </ol>
 *
 * @author Takafumi Kondo (TK Factory)
 *
 * @see org.jfree.chart.ChartFactory#createWaterfallChart
 * @see org.jfree.chart.StandardChartTheme#createLegacyTheme
 */
public class SampleCreateWaterfallChart extends AbstractSample
{
    /** 饹̾ */
    private static final String CLASS_NAME =
        SampleCreateWaterfallChart.class.getSimpleName();

    /**  */
    private static final Logger LOGGER =
        Logger.getLogger(SampleCreateWaterfallChart.class.getName());

    /** ϥե̾PNG */
    private static final String OUT_FILE_NAME_PNG =
        SAMPLE_FILE_DIRECTORY +  CLASS_NAME + ".png";

    /**
     * SampleCreateWaterfallChart֥Ȥۤȡ
     * UnsupportedOperationExceptionޤ<br/>
     */
    protected SampleCreateWaterfallChart()
    {
        throw new UnsupportedOperationException();
    }

    /**
     * main᥽åɤǤ<br/>
     *
     * @param args 
     */
    public static void main(String[] args)
    {
        LOGGER.info("[START]" + CLASS_NAME);

        FileOutputStream png = null;

        try
        {
            //Ǥ˽ϥե뤬¸ߤƤϺ
            deleteExistsFile(OUT_FILE_NAME_PNG);

            //쥬ơޤꤹ
            ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());

            //ե㡼ȤΥǡꤹ
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            dataset.addValue(400.0, "", "ǯ夲");
            dataset.addValue(300.0, "", "");
            dataset.addValue(200.0, "", "»");
            dataset.addValue(100.0, "", "û");
            dataset.addValue(1000.0, "", "");

            //ե㡼Ȥ
            JFreeChart chart = ChartFactory.createWaterfallChart(
                    //եȥ
                    "",
                    //ƥ꼴٥
                    "",
                    //ͼ٥
                    "",
                    //ǡå
                    dataset,
                    //դν
                    PlotOrientation.VERTICAL,
                    //Ƚɽ̵ͭ
                    true,
                    //ġåפɽ̵ͭ
                    false,
                    //URLưŪ̵ͭ
                    false);

            //PNGǥե¸
            png = new FileOutputStream(OUT_FILE_NAME_PNG);
            ChartUtilities.writeChartAsPNG(png, chart, 600, 400);
        }
        catch (IOException ioex)
        {
            LOGGER.error(getStackTrace(ioex));
        }
        finally
        {
            try
            {
                if (png != null)
                {
                    png.close();
                }
            }
            catch (IOException ioex)
            {
                LOGGER.error(getStackTrace(ioex));
            }

            LOGGER.info("[E N D]" + CLASS_NAME);
        }
    }
}
