package net.tk_factory.sample.jfreechart.chart;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import net.tk_factory.sample.AbstractSample;

import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.general.DefaultPieDataset;

/**
 * JFreeChartѤץץǤ<br/>
 * <br/>
 * <b></b>
 * <ol type="1">
 * <li>դΥ֥ȥꤷޤ</li>
 * </ol>
 *
 * @author Takafumi Kondo (TK Factory)
 */
public class SampleSetSubtitles extends AbstractSample
{
    /** 饹̾ */
    private static final String CLASS_NAME =
        SampleSetSubtitles.class.getSimpleName();

    /**  */
    private static final Logger LOGGER =
        Logger.getLogger(SampleSetSubtitles.class.getName());

    /** ϥե̾PNG */
    private static final String OUT_FILE_NAME_PNG =
        SAMPLE_FILE_DIRECTORY +  CLASS_NAME + ".png";

    /**
     * SampleSetSubtitles֥Ȥۤȡ
     * UnsupportedOperationExceptionޤ<br/>
     */
    protected SampleSetSubtitles()
    {
        throw new UnsupportedOperationException();
    }

    /**
     * main᥽åɤǤ<br/>
     *
     * @param args 
     */
    public static void main(String[] args)
    {
        LOGGER.info("[START]" + CLASS_NAME);

        FileOutputStream png = null;

        try
        {
            //Ǥ˽ϥե뤬¸ߤƤϺ
            deleteExistsFile(OUT_FILE_NAME_PNG);

            //쥬ơޤꤹ
            ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());

            //ߥդΥǡꤹ
            DefaultPieDataset dataset = new DefaultPieDataset();
            dataset.setValue("ٻ", 14.3);
            dataset.setValue("ɤǤʤ", 70.1);
            dataset.setValue("ٻʤ", 15.6);

            //ߥդ
            JFreeChart chart = ChartFactory.createPieChart(
                    //եȥ
                    "ջٻΨ",
                    //ǡå
                    dataset,
                    //ɽ̵ͭ
                    true,
                    //ġåפɽ̵ͭ
                    false,
                    //URLưŪ̵ͭ
                    false);

            //դΥ֥ȥꤹ
            List<Title> subtitles = new ArrayList<Title>();
            for (int i = 0; i < 5; i++)
            {
                Title subtitle = new TextTitle("֥ȥ( " + i + " )");
                subtitles.add(subtitle);
            }
            chart.setSubtitles(subtitles);

            //PNGǥե¸
            png = new FileOutputStream(OUT_FILE_NAME_PNG);
            ChartUtilities.writeChartAsPNG(png, chart, 600, 400);
        }
        catch (IOException ioex)
        {
            LOGGER.error(getStackTrace(ioex));
        }
        finally
        {
            try
            {
                if (png != null)
                {
                    png.close();
                }
            }
            catch (IOException ioex)
            {
                LOGGER.error(getStackTrace(ioex));
            }

            LOGGER.info("[E N D]" + CLASS_NAME);
        }
    }
}
