#include <CoreFoundation/CoreFoundation.h>
#include <CoreServices/CoreServices.h>
#include <QuickLook/QuickLook.h>

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>

/* -----------------------------------------------------------------------------
    Generate a thumbnail for file

   This function's job is to create thumbnail for designated file as fast as possible
   ----------------------------------------------------------------------------- */

OSStatus GenerateThumbnailForURL(void *thisInterface, QLThumbnailRequestRef thumbnail, CFURLRef url, CFStringRef contentTypeUTI, CFDictionaryRef options, CGSize maxSize)
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	
#ifdef ENABLES_THUMBNAIL
	if (CFEqual(contentTypeUTI, kUTTypeWebArchive))
	{
		NSData *contents = [NSData dataWithContentsOfURL:(NSURL *)url];
		WebArchive *archive = [[[WebArchive alloc] initWithData:contents] autorelease];
		
		NSRect frame = NSMakeRect(0.0f, 0.0f, 512.0f, 512.0f);
		maxSize = CGSizeMake(512.0f, 512.0f);
//		NSRect frame;
//		frame.origin = NSZeroPoint;
//		frame.size.width = maxSize.width;
//		frame.size.height = maxSize.height;
		
		WebView *webView = [[[WebView alloc] initWithFrame:frame] autorelease];
		[[webView mainFrame] loadArchive:archive];
		while ([webView isLoading])
		{
			CFRunLoopRunInMode(kCFRunLoopDefaultMode, 0, true);
		}
		
		CGContextRef cgContext = QLThumbnailRequestCreateContext(thumbnail, maxSize, false, NULL);
		if(cgContext)
		{
			NSGraphicsContext* context = [NSGraphicsContext graphicsContextWithGraphicsPort:(void *)cgContext flipped:[webView isFlipped]];
			[webView displayRectIgnoringOpacity:[webView bounds] inContext:context];
			QLThumbnailRequestFlushContext(thumbnail, cgContext);
		}
		CFRelease(cgContext);
	}
#endif
	[pool drain];
	
    return noErr;
}

void CancelThumbnailGeneration(void* thisInterface, QLThumbnailRequestRef thumbnail)
{
    // implement only if supported
}
