goog.provide('FlappDisplay');

goog.scope(function () {

/**
 * @constructor
 */
FlappDisplay = function() {
    this.objs = {};
};

FlappDisplay.prototype = {
    set: function(depth, obj, place) {
        this.objs[depth] = obj;
        obj.matrix = place.matrix;
        obj.colorTransform = place.colorTransform;
        obj.clipDepth = place.clipDepth;
        console.log('this.objs');
        console.log(this.objs);
    },
    move: function(depth, place) 
    {
        var obj = this.objs[depth];
        if (place.matrix) {
            obj.setMatrix(place.matrix);
        }
        if (place.colorTransform) {
            obj.colorTransform = place.colorTransform;
        }
    },
    get: function(depth) {
//        console.debug("get: depth:"+depth);
//        console.debug(this.objs);
        return this.objs[depth];
    },
    del: function(depth) {
        this.objs[depth].destroy();
        delete this.objs[depth];
    },
    ascSortedDepth: function() {
        var keys = Object.keys(this.objs);
        return keys.sort(
            function(a,b) { return (a<b)?-1:((a>b)?1:0); }
        );
    }
};

});
