goog.provide('FlappLoader');
goog.require('FlappIBit');
goog.require('FlappSWFHeader')
goog.require('FlappSWFTag')
goog.require('FlappBitmap')

goog.scope(function() {

/**
 * @constructor
 */
FlappLoader = function(flapp) {
    this.flapp = flapp;
};

FlappLoader.prototype = {
    fromURL: function(url, dict, movieClip) {
        console.debug("FlappLoader.prototype.fromURL("+url+",flapp,dict,movieClip");
        var xhr = new XMLHttpRequest();
        var ibit = new FlappIBit();
        var loader = this;
        this.header = null;
        xhr.onreadystatechange = function() {
            if (xhr.readyState > 1) {
                if (xhr.status == 200) {
                    if (xhr.responseText) {
                        ibit.input(xhr.responseText);
                        loader.parse(ibit, dict, movieClip);
                    }
                }
            }
        };
        xhr.open('GET', url);
        // xhr.responseType = 'arraybuffer';
        xhr.overrideMimeType('text/plain; charset=x-user-defined');
        xhr.send(null);
    },
    parse: function(ibit, dict, movieClip) {
        // console.debug("FlappLoader.prototype.parse");
        if (ibit.len() < 20) { // 20 is minumum size for swf header, maybe.
            return ;
        }
        if (this.header === null) {
            this.header = FlappSWFHeader.load(ibit);
            console.debug(this.header);
            this.flapp.setHeader(this.header);
        }
        var jpegTables = null;
        while (ibit.a(), ibit.hasNext(2)) {
            var headPos = ibit.getBytePos();
            var tag_and_length = ibit.ui16(); // tag and length
            var code = tag_and_length >>> 6;
            var length = tag_and_length & 0x3f;
            if (length === 0x3f) {
                if (ibit.hasNext(4) === false) {
                    ibit.setPos(headPos, 0);
                    break;
                }
                length = ibit.ui32();
            }
            if (ibit.hasNext(length) === false) {
                ibit.setPos(headPos, 0);
                break;
            }
            var startOfContent = ibit.getBytePos();
            var tag = FlappSWFTag.load(code, length, ibit);
//                console.debug(tag);
            switch (code) {
            case 1: // ShowFrame
                movieClip.appendControlTag(tag);
                break;
            case 2: // DefineShape
            case 22: // DefineShape2
            case 32: // DefineShape3
                dict.set(tag.id, tag);
                break;
            case 4:  // PlaceObject
            case 26: // PlaceObject2
            case 5:  // RemoveObject
            case 28: // RemoveObject2
                movieClip.appendControlTag(tag);
                break;
            case 6: // DefineBits(JPEG)
            case 21: // DefineBitsJPEG2
            case 35: // DefineBitsJPEG3
                var jpeg = FlappBitmap.toJpeg(tag.jpegData, jpegTables);
                var image = new Image();
                image.src = "data:image/jpeg;base64," + goog.global.btoa(jpeg);
                tag['image'] = tag.image = image; // for closure compilre
                dict.set(tag.id, tag);
                break;
            case 8: // JPEGTables
                jpegTables = tag;
                break;
            case 9: // SetBackgroundColor
                this.flapp.setBackground(tag.red, tag.green, tag.blue);
                break;
            case 12: // DoAction
                movieClip.appendControlTag(tag);
                break;
            case 39: // DefineSprite
                dict.set(tag.id, tag);
                break;
            case 777: // swftools ?
                // skip
                break;
            default:
                console.warn("Unknown swf tag code:"+code);
                break;
            }
            ibit.setPos(startOfContent + length, 0);
        }
    }
};

});
