goog.provide('Flapp');
goog.require('FlappLoader');
goog.require('FlappDict');
goog.require('FlappCanvas');
goog.require('FlappMovieClip');

goog.scope(function() {

/**
 * @constructor
 */
Flapp = function(url, canvas_id) {
    console.debug("Flapp("+url+","+canvas_id+")");
    this.url = url;
    this.canvas_id = canvas_id;
    this.canvas = document.getElementById(canvas_id);
    goog.global.flapp = this; // debug
    this.header = null
    this.frameTick = 1000 / 50; // default 0.05[sec]
    this.matrix = null;
    this.timerId = null;
};
Flapp.prototype = {
    play: function() {
        console.debug("Flapp.prototype.play");
        var flapp = this;
        var loader = new FlappLoader(flapp); // file loader
        this.dict = new FlappDict(); // content dictionary
        this.matrix = FlappSWFMatrix.multiplyScalar(FlappSWFMatrix.identity(), (1/20));
        this.movieClip = new FlappMovieClip(null, this.matrix, null); // root MC
        this.movieClip.name = "_root";
        loader.fromURL(this.url, this.dict, this.movieClip);
        this.canvas = new FlappCanvas(this.canvas);
        this.run(this.dict, this.movieClip, this.canvas);
    },
    setHeader: function(header) {
        this.frameTick = 1000 / header.framerate;
//        this.frameTick = 1000; // for debug
        this.movieClip.totalframes = header.framecount;
        var canvas_width = this.canvas.width;
        var factorX = this.canvas.canvas.width / (header.framesize.xmax / 20);
        var factorY = this.canvas.canvas.height / (header.framesize.ymax / 20);
        if (factorX < factorY) {
            this.matrix[0] *= factorX;
            this.matrix[3] *= factorX;
            this.matrix[5] += (header.framesize.xmax * factorX - header.framesize.ymax * factorX) / 40;
        } else {
            this.matrix[0] *= factorY;
            this.matrix[3] *= factorY;
            this.matrix[4] += (header.framesize.ymax * factorY - header.framesize.xmax * factorY) / 40;
        }
        this.movieClip.absoluteMatrix = null;
        this.movieClip.setMatrix(this.matrix);
        if (typeof this.timerId === 'number') {
            clearInterval(this.timerId);
            this.ticks();
        }
    },
    setBackground: function(red, green, blue) {
        this.canvas.canvas.style.backgroundColor = 'rgb('+red+','+green+','+blue+')';
    },
    run: function(dict, movieClip, canvas) {
        console.debug("Flapp::run");
        var flapp = this;
        this.canvas = canvas;
        this.ticks();
    },
    ticks: function() {
        var flapp = this;
        var dict = this.dict;
        var movieClip = this.movieClip;
        var canvas = this.canvas;
        console.debug("Flapp::ticks "+movieClip.currentFrame);
        this.timerId = setInterval(function() {
            if (movieClip.control(dict)) {
                movieClip.action();
                canvas.clear();
                movieClip.render(canvas, dict);
                movieClip.increment();
            }
        }, flapp.frameTick);
    }
};

goog.exportSymbol('Flapp', Flapp);
goog.exportSymbol('Flapp.prototype.play', Flapp.prototype.play);

});
