goog.provide('FlappSWFGradient');
goog.require('FlappSWFRGBA');

goog.scope(function() {

/**
 * @constructor
 */
FlappSWFGradient = function(ibit) {
    ;
};

FlappSWFGradient.load = function(ibit, hasAlpha) {
    ibit.a();
    var spread = ibit.ub(2);
    var interpolation = ibit.ub(2);
    var numGradients = ibit.ub(4);
    var gradientRecords = [];
    for (var i = 0 ; i < numGradients ; i++) {
        var ratio = ibit.ui8();
        var color = FlappSWFRGBA.load(ibit, hasAlpha);
        gradientRecords.push({ratio:ratio, color:color});
    }
    return {
        spreadMode: spread,
        interpolationMode: interpolation,
        gradientRecords: gradientRecords
    };
};

});
