goog.provide('FlappSWFLineStyles');
goog.require('FlappSWFRGBA');

goog.scope(function() {

/**
 * @constructor
 */
FlappSWFLineStyles = function(ibit) {
    ;
};

FlappSWFLineStyles.load = function(code, ibit) {
    ibit.a();
    var count = ibit.ui8();
    if ((code > 2) && (count === 0xff)) {
        count = ibit.ui16();
    }
    var lineStyles = new Array(count);
    var hasAlpha = !(code < 32);
    for (var i = 0 ; i < count ;  i++) {
        lineStyles[i] = FlappSWFLineStyles.loadStyle(ibit, hasAlpha);
    }
    return lineStyles;
};

FlappSWFLineStyles.loadStyle = function(ibit, hasAlpha) {
    var width = ibit.ui16();
    var color = FlappSWFRGBA.load(ibit, hasAlpha);
    return {width:width, color:color};
}

});
