/*
  PlaceObject parser
*/
goog.provide('FlappSWFTagPlaceObject');
goog.require('FlappSWFMatrix');
goog.require('FlappSWFCXForm');

goog.scope(function() {

/**
 * @constructor
 */
FlappSWFTagPlaceObject = function(code, length, ibit) {
//        console.log("FlappSWFTagPlaceObject(code:"+code+", length:"+length+", ibit)");
    this.code = code;
    this.length = length;
    //
    if (code === 26) { // PlaceObject2
        var placeFlag = ibit.ui8();
        var placeFlagHasClipActions    = (placeFlag & 0x80);
        var placeFlagHasClipDepth      = (placeFlag & 0x40);
        var placeFlagHasName           = (placeFlag & 0x20);
        var placeFlagHasRatio          = (placeFlag & 0x10);
        var placeFlagHasColorTransform = (placeFlag & 0x08);
        var placeFlagHasMatrix         = (placeFlag & 0x04);
        var placeFlagHasCharacter      = (placeFlag & 0x02);
        var placeFlagMove              = (placeFlag & 0x01);
        this.move = placeFlagMove;
        this.depth = ibit.ui16();
        this.id = (placeFlagHasCharacter)?ibit.ui16():null;
        this.matrix = (placeFlagHasMatrix)?FlappSWFMatrix.load(ibit):null;
        this.colorTransform = (placeFlagHasColorTransform)?FlappSWFCXForm.load(ibit, true):null;
        this.ratio = (placeFlagHasRatio)?ibit.ui16():null;
        this.name = (placeFlagHasName)?ibit.str():null;
        this.clipDepth = (placeFlagHasClipDepth)?ibit.ui16():null;
        // ClipActions swf5 later
    } else if (code === 4) { // PlaceObject
        this.id = ibit.ui16();
        this.depth = ibit.ui16();
        this.matrix = FlappSWFMatrix.load(ibit);
        ibit.a();
        this.colorTransform = (ibit.hasNext(1))?FlappSWFCXForm.load(ibit, false):null;
    }
};

});
