﻿/*
 * Copyright (C) 2013 FooProject
 * * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using FooEditEngine;
using Windows.UI.Core;
using Windows.Foundation;
using Windows.Graphics.Printing;

namespace FooEditEngine.Metro
{
    /// <summary>
    /// 印刷を行うクラス
    /// </summary>
    public class FooPrintText
    {
        /// <summary>
        /// コンストラクター
        /// </summary>
        public FooPrintText()
        {
            this.PrintStart += (s, e) => { };
            this.PrintComplete += (s, e) => { };
            this.ParseHF = (s, e) => { return e.Original; };
        }

        DocumentSource source;
        /// <summary>
        /// ヘッダーやフッターを処理する
        /// </summary>
        public ParseCommandHandler ParseHF;

        /// <summary>
        /// ヘッダー
        /// </summary>
        public string Header;

        /// <summary>
        /// フッター
        /// </summary>
        public string Fotter;

        /// <summary>
        /// 印刷が開始したことを表す
        /// </summary>
        public event EventHandler PrintStart;

        /// <summary>
        /// 印刷が完了したことを表す
        /// </summary>
        public event EventHandler PrintComplete;

        /// <summary>
        /// 印刷する
        /// </summary>
        /// <param name="req">PrintTaskRequestオブジェクト</param>
        /// <param name="title">タイトル</param>
        /// <param name="textbox">印刷対象のテキストボックス</param>
        public void Print(PrintTaskRequest req,string title,FooTextBox textbox)
        {
            IAsyncAction async = textbox.Dispatcher.RunAsync(CoreDispatcherPriority.Normal, () =>
            {
                this.PrintStart(this, null);
                source = new DocumentSource(textbox);
                source.ParseHF = ParseHF;
                source.Header = Header;
                source.Fotter = Fotter;

                PrintTask task = req.CreatePrintTask(title, (e) =>
                {
                    e.SetSource(source);
                });
                task.Completed += async (sender, e) => {
                    source.Dispose();
                    await textbox.Dispatcher.RunAsync(CoreDispatcherPriority.Normal, () => {
                        this.PrintComplete(this, null);
                    });
                };
            });
            Task t = WindowsRuntimeSystemExtensions.AsTask(async);
            t.Wait();
        }
    }
}
