package jp.sourceforge.freegantt.swing;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;

public class HolidayTable extends JTable {
	private static final long serialVersionUID = -4264344738836855169L;

	Color borderColor = new Color(0xC0, 0xC0, 0xC0);

	Application app;
	
	public HolidayTable(Application app, TableModel dm) {
		super(dm);
		this.app = app;
		setFillsViewportHeight(true);
		setColumnSelectionAllowed(false);
		setGridColor(borderColor);
		getTableHeader().setResizingAllowed(false);
		getTableHeader().setReorderingAllowed(false);
		registerKeyboardAction(new RemoveAction(), KeyStroke.getKeyStroke(KeyEvent.VK_DELETE, 0), JComponent.WHEN_FOCUSED);
		
		getColumnModel().getColumn(0).setCellRenderer(getTableHeader().getDefaultRenderer());
		columnModel.getColumn(0).setPreferredWidth(32);
		columnModel.getColumn(0).setMaxWidth(32);
		columnModel.getColumn(0).setMinWidth(32);
	}
	
	class RemoveAction extends AbstractAction {
		private static final long serialVersionUID = -7312387923027032759L;

		@Override
		public void actionPerformed(ActionEvent e) {
			int deleted = 0;
			int[] rows = getSelectedRows();
			for (int row: rows) {
				app.getProject().removeAdditionalHoliday(row - deleted);
				deleted ++;
			}
		}
	}

}
