package jp.sourceforge.freegantt.swing;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.locale.Resource;
import jp.sourceforge.freegantt.util.CalendarUtil;

public class HolidayTableModel implements TableModel {
	
	String[] columnNames = {"", "日付"};

	Project project;
	List<TableModelListener> tableModelListeners = new ArrayList<TableModelListener>();

	public HolidayTableModel(Project project) {
		this.project = project;
	}
	
	@Override
	public int getRowCount() {
		return project.getAdditionalHolidays().size() + 1;
	}

	@Override
	public int getColumnCount() {
		return columnNames.length;
	}

	@Override
	public String getColumnName(int columnIndex) {
		if (columnIndex >= columnNames.length) return "";
		return columnNames[columnIndex];
	}

	@Override
	public Class<?> getColumnClass(int columnIndex) {
		return String.class;
	}

	@Override
	public boolean isCellEditable(int rowIndex, int columnIndex) {
		return columnIndex > 0;
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		if (columnIndex == 0) return rowIndex + 1;
		if (rowIndex >= project.getAdditionalHolidays().size()) return null;
		Calendar calendar = project.getAdditionalHolidays().get(rowIndex);
		SimpleDateFormat format = new SimpleDateFormat(Resource.get("dateFormat"));
		return format.format(calendar.getTime());
	}

	@Override
	public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
		if (rowIndex > project.getAdditionalHolidays().size()) return;
		if (columnIndex != 1) return;
		if (aValue == null || ((String)aValue).isEmpty()) return;
		
		Calendar newCalendar = CalendarUtil.parseDate((String)aValue);
		if (newCalendar == null) return;
		
		if (rowIndex == project.getAdditionalHolidays().size()) {
			project.getAdditionalHolidays().add(newCalendar);
		} else {
			project.getAdditionalHolidays().get(rowIndex).setTime(newCalendar.getTime());
		}
		
		for (TableModelListener listener: tableModelListeners) {
			TableModelEvent e = new TableModelEvent(this, rowIndex, rowIndex, columnIndex, TableModelEvent.UPDATE);
			listener.tableChanged(e);
		}
	}

	@Override
	public void addTableModelListener(TableModelListener l) {
		tableModelListeners.add(l);
	}

	@Override
	public void removeTableModelListener(TableModelListener l) {
		tableModelListeners.remove(l);
	}
	
	public void fireTableChanged() {
		for (TableModelListener listener: tableModelListeners) {
			TableModelEvent e = new TableModelEvent(this, 0, 0, 0, TableModelEvent.UPDATE);
			listener.tableChanged(e);
		}
	}

}
