package jp.sourceforge.freegantt.swing;

import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.JTableHeader;

public class TaskListRootPane extends JPanel {
	private static final long serialVersionUID = 1618049203954194983L;

	Application app;
	
	TaskListScrollPane taskListScrollPane;
	TaskListTable taskListPane;

	public TaskListRootPane(Application app) {
		super();
		this.app = app;
		setLayout(null);
		
		taskListPane = new TaskListTable(app);
		taskListPane.setBounds(0, 0, 300, 400);
		taskListPane.setFillsViewportHeight(true);
		taskListPane.setPreferredScrollableViewportSize(new Dimension(1000, 1000));
		
		JTableHeader header = taskListPane.getTableHeader();
		Dimension dim = header.getPreferredSize();
		header.setPreferredSize(new Dimension(1, 32));

		taskListScrollPane = new TaskListScrollPane(taskListPane);
		taskListScrollPane.setBounds(0, 0, 300, 200);
		taskListScrollPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
		Border border = BorderFactory.createEmptyBorder();
		taskListScrollPane.setBorder(border);
		add(taskListScrollPane);
		
		// タスクリストテーブルのスクロールにあわせてチャートペインのスクロールを調整する。
		// これによって、ひとつのスクロールバーで２つの画面をスクロールさせる
		taskListScrollPane.getViewport().addChangeListener(new ChangeListener() {
			@Override
			public void stateChanged(ChangeEvent e) {
				// チャートペインのビューポート位置をタスクリストテーブルのビューポート位置と同じに設定し、再描画させる
				JViewport dataViewport = TaskListRootPane.this.app.getDataViewport();
				Point newViewPosition = taskListScrollPane.getViewport().getViewPosition();
				Point currentViewPosition = dataViewport.getViewPosition();
				dataViewport.setViewPosition(new Point(currentViewPosition.x, newViewPosition.y));
			}
		});
	}

	public TaskListTable getTaskListPane() {
		return taskListPane;
	}
	
	public TaskListScrollPane getTaskListScrollPane() {
		return taskListScrollPane;
	}

	@Override
	public void doLayout() {
		super.doLayout();
		
		taskListScrollPane.setSize(getSize());
	}
	
	
}
