package jp.sourceforge.freegantt.data;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class Task {
	/** 行番号　*/
	Integer index;
	/** タスク名 */
	String Name;
	/** 開始日 */
	Calendar startDate;
	/** 工期(日数を小数値で表す) */
	Integer period;
	/** 達成度 */
	int completion;
	/** 担当者 */
	Member member;
	/** 階層 */
	int level;
	/** 制約条件 */
	List<Task> restrictions = new ArrayList<Task>();
	
	// 以下自動計算されるもの
	/** 実質工期(休日を考慮した工期) */
	Integer realPeriod;
	
	public String getName() {
		return Name;
	}
	public void setName(String name) {
		Name = name;
	}
	public Integer getPeriod() {
		return period;
	}
	public void setPeriod(Integer period) {
		this.period = period;
	}
	public Member getMember() {
		return member;
	}
	public void setMember(Member member) {
		this.member = member;
	}
	public List<Task> getRestrictions() {
		return restrictions;
	}
	public void setRestrictions(List<Task> restrictions) {
		this.restrictions = restrictions;
	}
	public Integer getRealPeriod() {
		return realPeriod;
	}
	public void setRealPeriod(Integer realPeriod) {
		this.realPeriod = realPeriod;
	}
	public Calendar getStartDate() {
		return startDate;
	}
	public void setStartDate(Calendar startDate) {
		this.startDate = startDate;
	}
	public int getLevel() {
		return level;
	}
	public void setLevel(int level) {
		this.level = level;
	}
	public int getCompletion() {
		return completion;
	}
	public void setCompletion(int completion) {
		this.completion = Math.min(Math.max(completion, 0), 100);
	}
	public Integer getIndex() {
		return index;
	}
	public void setIndex(Integer index) {
		this.index = index;
	}
	public boolean isParent() {
		return level > 0;
	}
	public boolean isMilestone() {
		return (period == null || period == 0) && realPeriod == 0;
	}
	public boolean isDrawable() {
		return startDate != null;
	}
	
	/**
	 * 終了日を返す。Project#updteを呼び出してrealPeriodを計算してから使用すること。
	 * @return
	 */
	public Calendar getEndDate() {
		if (startDate == null) return null;
		Calendar endDate = (Calendar)startDate.clone();
		if (realPeriod != null && realPeriod > 0) {
			endDate.add(Calendar.DATE, realPeriod.intValue());
		}
		return endDate;
	}
	
	public void addRestriction(Task targetTask) {
		if (targetTask != this
				&& !targetTask.getRestrictions().contains(this)
				&& !getRestrictions().contains(targetTask)) {
			restrictions.add(targetTask);
		}
	}

}
