package jp.sourceforge.freegantt.swing;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;


public class GanttChartPane extends JPanel {
	private static final long serialVersionUID = -968483593747003051L;
	
	Application app;
	
	GanttChartSplitPane ganttChartSplitPane;
	TaskLineRootPane taskLineRootPane;
	TaskListRootPane taskListRootPane;
	
	public GanttChartPane(Application app) {
		super(new BorderLayout());
		
		this.app = app;
		setBackground(Color.blue);
		
		ganttChartSplitPane = new GanttChartSplitPane(JSplitPane.HORIZONTAL_SPLIT);
		ganttChartSplitPane.setBounds(0, 0, 300, 200);
		ganttChartSplitPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
		ganttChartSplitPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
		ganttChartSplitPane.setDividerSize(4);
		ganttChartSplitPane.setContinuousLayout(true);
		add(ganttChartSplitPane);
		
		taskListRootPane = new TaskListRootPane(app);
		taskListRootPane.setBounds(0, 0, 100, 200);
		ganttChartSplitPane.add(taskListRootPane);
		
		taskLineRootPane = new TaskLineRootPane(app);
		taskLineRootPane.setBounds(0, 0, 500, 200);
		taskLineRootPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
		ganttChartSplitPane.add(taskLineRootPane);
		
		ganttChartSplitPane.setDividerLocation(351);
		ganttChartSplitPane.setMaximumDividerLocation(351);
	}

	public TaskLineRootPane getTaskLineRootPane() {
		return taskLineRootPane;
	}

	public TaskListRootPane getTaskListRootPane() {
		return taskListRootPane;
	}

	@Override
	public void doLayout() {
		super.doLayout();
		
		ganttChartSplitPane.setSize(getSize());
	}
	
	
}
