package jp.sourceforge.freegantt.data.model;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.freegantt.data.Project;

public class ProjectViewModel {

	Project project;
	List<ProjectViewChangedListener> listeners = new ArrayList<ProjectViewChangedListener>();
	
	public ProjectViewModel(Project project) {
		this.project = project;
	}
	
	public void addProjectViewChangedListener(ProjectViewChangedListener l) {
		listeners.add(l);
	}
	
	public void removeProjectViewChangedListener(ProjectViewChangedListener l) {
		listeners.remove(l);
	}
	
	public void fireProjectViewChangedEvent() {
		for (ProjectViewChangedListener listener: listeners) {
			listener.projectViewChanged();
		}
	}
}
