package jp.sourceforge.freegantt.data.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class StatefullUndoManager extends UndoManager {
	private static final long serialVersionUID = 202681486064882611L;
	
	boolean running;

	public boolean isRunning() {
		return running;
	}

	public void setRunning(boolean running) {
		this.running = running;
	}

	@Override
	public synchronized boolean addEdit(UndoableEdit anEdit) {
		if (running) {
			return false;
		} else {
			return super.addEdit(anEdit);
		}
	}

	@Override
	public synchronized void undo() throws CannotUndoException {
		running = true;
		super.undo();
		running = false;
	}

	@Override
	public synchronized void redo() throws CannotRedoException {
		running = true;
		super.redo();
		running = false;
	}
	
	
}
