package jp.sourceforge.freegantt.data.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import jp.sourceforge.freegantt.data.Project;

public class UpdateCalendarModeEdit extends AbstractUndoableEdit {
	private static final long serialVersionUID = -4220083306749208343L;

	Project project;
	int oldMode;
	int newMode;
	
	public UpdateCalendarModeEdit(Project project, int mode) {
		this.project = project;
		oldMode = project.getCalendarMode();
		newMode = mode;
	}
	
	@Override
	public void undo() throws CannotUndoException {
		System.out.println("Undo " + getClass().toString());
		super.undo();
		project.getController().setCalendarMode(oldMode);
	}

	@Override
	public void redo() throws CannotRedoException {
		super.redo();
		project.getController().setCalendarMode(newMode);
	}

	@Override
	public void die() {
		super.die();
		project = null;
	}

}
