package jp.sourceforge.freegantt.data.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import jp.sourceforge.freegantt.data.Project;

public class UpdateProjectSummaryEdit extends AbstractUndoableEdit {
	private static final long serialVersionUID = 4340786427425901342L;

	Project project;
	String oldText;
	String newText;
	
	public UpdateProjectSummaryEdit(Project project, String text) {
		this.project = project;
		this.oldText = project.getSummary().toString();
		this.newText = text.toString();
	}

	@Override
	public void undo() throws CannotUndoException {
		System.out.println("Undo " + getClass().toString());
		super.undo();
		project.getController().setSummary(oldText);
	}

	@Override
	public void redo() throws CannotRedoException {
		super.redo();
		project.getController().setSummary(newText);
	}

	@Override
	public void die() {
		super.die();
		project = null;
		oldText = null;
		newText = null;
	}

}
