package jp.sourceforge.freegantt.swing;

import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;

import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.JTableHeader;

public class TaskListRootPane extends JScrollPane {
	private static final long serialVersionUID = 1618049203954194983L;

	Application app;
	TaskListTable taskListTable;

	public TaskListRootPane(Application app) {
		super(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
				JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
		this.app = app;
		
		setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
		setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
		
		taskListTable = new TaskListTable(app);
		taskListTable.setBounds(0, 0, 300, 400);
		taskListTable.setFillsViewportHeight(true);
		taskListTable.setPreferredScrollableViewportSize(new Dimension(1000, 1000));
		setViewportView(taskListTable);
		
		JTableHeader header = taskListTable.getTableHeader();
		header.setPreferredSize(new Dimension(1, 32));
		
		// タスクリストテーブルのスクロールにあわせてチャートペインのスクロールを調整する。
		// これによって、ひとつのスクロールバーで２つの画面をスクロールさせる
		getViewport().addChangeListener(new ChangeListener() {
			@Override
			public void stateChanged(ChangeEvent e) {
				// チャートペインのビューポート位置をタスクリストテーブルのビューポート位置と同じに設定し、再描画させる
				JViewport dataViewport = TaskListRootPane.this.app.getDataViewport();
				Point newViewPosition = getViewport().getViewPosition();
				Point currentViewPosition = dataViewport.getViewPosition();
				dataViewport.setViewPosition(new Point(currentViewPosition.x, newViewPosition.y));
			}
		});
	}

	public TaskListTable getTaskListTable() {
		return taskListTable;
	}
	
}
