import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

public class CellPanel extends JPanel implements MouseListener, ActionListener{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private int CELL_WIDTH = 52;
	private int CELL_HEIGHT = 52;
	
	private int CurrentSelectedIcon;
	private Timer timer;
	
	public CellPanel() {
	    this.setPreferredSize(new Dimension(CELL_WIDTH * 5, CELL_HEIGHT * 2));
		CurrentSelectedIcon = 0;
		this.addMouseListener(this);
		timer = new Timer(30,this);
		timer.start();
	}
	
	@Override
	public void paintComponent(Graphics g) {
	    Font font = new Font("Serif", Font.BOLD, 44);
	    g.setFont(font);
	    super.paintComponent(g);
	    for(int i = 0; i < 10; i++) {
		if(i == CurrentSelectedIcon) {
		    g.drawRect(CELL_WIDTH * (i % 5),
			       CELL_HEIGHT * (i / 5),
			       50, 50);
		}
		g.drawString(Integer.toString(i), 
			     (CELL_WIDTH) * (i % 5) + 10,
			     (CELL_HEIGHT) * (i / 5)+ 44);
	    }
	}

	@Override
	public void mouseClicked(MouseEvent e) {
		
	}

	@Override
	public void mouseEntered(MouseEvent e) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mouseExited(MouseEvent e) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mousePressed(MouseEvent e) {
		// TODO Auto-generated method stub
		int newSelect = e.getX() / (CELL_WIDTH) + e.getY() / CELL_HEIGHT * 5;
		if(newSelect <= 10)  {
			CurrentSelectedIcon = newSelect;
		}
	}

	@Override
	public void mouseReleased(MouseEvent e) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		// TODO Auto-generated method stub
		//System.out.println("CurrentSelectedIcon: " + CurrentSelectedIcon);
		repaint();
	}
	
	
	public int getCurrentIcon() {
		return CurrentSelectedIcon;
	}
	
}
